/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.jbang.core.commands.process;

import java.util.List;
import org.apache.camel.dsl.jbang.core.commands.CamelJBangMain;
import org.apache.camel.dsl.jbang.core.commands.process.AvailablePortFinder;
import org.apache.camel.dsl.jbang.core.commands.process.ProcessBaseCommand;
import org.jolokia.jvmagent.client.command.CommandDispatcher;
import org.jolokia.jvmagent.client.util.OptionsAndArgs;
import org.jolokia.jvmagent.client.util.PlatformUtils;
import org.jolokia.jvmagent.client.util.VirtualMachineHandlerOperations;
import picocli.CommandLine;

@CommandLine.Command(name="jolokia", description={"Attach Jolokia JVM Agent to a running Camel integration"}, sortOptions=false, showDefaultValues=true)
public class Jolokia
extends ProcessBaseCommand {
    @CommandLine.Parameters(description={"Name or pid of running Camel integration"}, arity="1")
    String name;
    @CommandLine.Option(names={"--stop"}, description={"Stops the Jolokia JVM Agent in the running Camel integration"})
    boolean stop;
    @CommandLine.Option(names={"--port"}, description={"To use a specific port number when attaching Jolokia JVM Agent (default a free port is found in range 8778-9999)"})
    int port;
    private volatile long pid;

    public Jolokia(CamelJBangMain main) {
        super(main);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Integer doCall() throws Exception {
        int exitCode;
        List<Long> pids = this.findPids(this.name);
        if (pids.isEmpty()) {
            return 0;
        }
        if (pids.size() > 1) {
            this.printer().println("Name or pid " + this.name + " matches " + pids.size() + " running Camel integrations. Specify a name or PID that matches exactly one.");
            return 0;
        }
        this.pid = pids.get(0);
        try {
            OptionsAndArgs options;
            if (this.stop) {
                options = new OptionsAndArgs(null, new String[]{"stop", Long.toString(this.pid)});
            } else {
                long p = this.port;
                if (p <= 0L) {
                    p = AvailablePortFinder.getNextAvailable(8778, 10000);
                }
                options = new OptionsAndArgs(null, new String[]{"--port", Long.toString(p), "--discoveryEnabled", "true", "start", Long.toString(this.pid)});
            }
            VirtualMachineHandlerOperations vmHandler = PlatformUtils.createVMAccess((OptionsAndArgs)options);
            CommandDispatcher dispatcher = new CommandDispatcher(options);
            Object vm = options.needsVm() ? vmHandler.attachVirtualMachine() : null;
            try {
                exitCode = dispatcher.dispatchCommand(vm, vmHandler);
            }
            finally {
                if (vm != null) {
                    vmHandler.detachAgent(vm);
                }
            }
        }
        catch (Exception e) {
            this.printer().printErr("Cannot execute jolokia command due: " + e.getMessage());
            exitCode = 1;
        }
        return exitCode;
    }

    long getPid() {
        return this.pid;
    }
}

