/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.jbang.core.commands.process;

import com.github.freva.asciitable.AsciiTable;
import com.github.freva.asciitable.Column;
import com.github.freva.asciitable.HorizontalAlign;
import com.github.freva.asciitable.OverflowBehaviour;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.camel.dsl.jbang.core.commands.CamelJBangMain;
import org.apache.camel.dsl.jbang.core.commands.process.ProcessWatchCommand;
import org.apache.camel.dsl.jbang.core.common.CamelCommandHelper;
import org.apache.camel.dsl.jbang.core.common.PidNameAgeCompletionCandidates;
import org.apache.camel.dsl.jbang.core.common.ProcessHelper;
import org.apache.camel.dsl.jbang.core.common.VersionHelper;
import org.apache.camel.util.TimeUtils;
import org.apache.camel.util.json.JsonArray;
import org.apache.camel.util.json.JsonObject;
import picocli.CommandLine;

@CommandLine.Command(name="context", description={"Get status of Camel integrations"}, sortOptions=false, showDefaultValues=true)
public class CamelContextStatus
extends ProcessWatchCommand {
    @CommandLine.Parameters(description={"Name or pid of running Camel integration"}, arity="0..1")
    String name = "*";
    @CommandLine.Option(names={"--sort"}, completionCandidates=PidNameAgeCompletionCandidates.class, description={"Sort by pid, name or age"}, defaultValue="pid")
    String sort;
    @CommandLine.Option(names={"--remote"}, description={"Break down counters into remote/total pairs"})
    boolean remote;

    public CamelContextStatus(CamelJBangMain main) {
        super(main);
    }

    @Override
    public Integer doProcessWatchCall() throws Exception {
        ArrayList rows = new ArrayList();
        List<Long> pids = this.findPids(this.name);
        ProcessHandle.allProcesses().filter(ph -> pids.contains(ph.pid())).forEach(ph -> {
            JsonObject root = this.loadStatus(ph.pid());
            if (root != null) {
                Row row = new Row();
                JsonObject context = (JsonObject)root.get((Object)"context");
                if (context == null) {
                    return;
                }
                row.name = context.getString("name");
                if ("CamelJBang".equals(row.name)) {
                    row.name = ProcessHelper.extractName(root, ph);
                }
                row.pid = Long.toString(ph.pid());
                row.uptime = CamelContextStatus.extractSince(ph);
                row.age = TimeUtils.printSince((long)row.uptime);
                JsonObject runtime = (JsonObject)root.get((Object)"runtime");
                row.platform = this.extractPlatform((ProcessHandle)ph, runtime);
                row.platformVersion = this.extractPlatformVersion(row.platform, runtime != null ? runtime.getString("platformVersion") : null);
                row.state = context.getInteger("phase");
                row.camelVersion = context.getString("version");
                row.profile = context.getString("profile");
                Map stats = context.getMap("statistics");
                if (stats != null) {
                    long time;
                    Object last;
                    Object thp = stats.get("exchangesThroughput");
                    if (thp != null) {
                        row.throughput = thp.toString();
                    }
                    row.total = stats.get("exchangesTotal").toString();
                    Object num = stats.get("remoteExchangesTotal");
                    if (num != null) {
                        row.totalRemote = num.toString();
                    }
                    row.failed = stats.get("exchangesFailed").toString();
                    num = stats.get("remoteExchangesFailed");
                    if (num != null) {
                        row.failedRemote = num.toString();
                    }
                    row.inflight = stats.get("exchangesInflight").toString();
                    num = stats.get("remoteExchangesInflight");
                    if (num != null) {
                        row.inflightRemote = num.toString();
                    }
                    if ((last = stats.get("lastProcessingTime")) != null) {
                        row.last = last.toString();
                    }
                    if ((last = stats.get("deltaProcessingTime")) != null) {
                        row.delta = last.toString();
                    }
                    if ((last = stats.get("lastCreatedExchangeTimestamp")) != null) {
                        time = Long.parseLong(last.toString());
                        row.sinceLastStarted = TimeUtils.printSince((long)time);
                    }
                    if ((last = stats.get("lastCompletedExchangeTimestamp")) != null) {
                        time = Long.parseLong(last.toString());
                        row.sinceLastCompleted = TimeUtils.printSince((long)time);
                    }
                    if ((last = stats.get("lastFailedExchangeTimestamp")) != null) {
                        time = Long.parseLong(last.toString());
                        row.sinceLastFailed = TimeUtils.printSince((long)time);
                    }
                    row.reloaded = (String)stats.get("reloaded");
                    if ((stats = (Map)stats.get("reload")) != null) {
                        row.reloaded = stats.get("reloaded").toString();
                        row.reloadedFailed = stats.get("failed").toString();
                        if ((stats = (Map)stats.get("lastError")) != null) {
                            row.reloadedError = stats.get("message").toString();
                        }
                    }
                }
                JsonArray array = (JsonArray)root.get((Object)"routes");
                for (int i = 0; i < array.size(); ++i) {
                    JsonObject o = (JsonObject)array.get(i);
                    String state = o.getString("state");
                    ++row.routeTotal;
                    if (!"Started".equals(state)) continue;
                    ++row.routeStarted;
                }
                JsonObject hc = (JsonObject)root.get((Object)"healthChecks");
                boolean rdy = hc != null && hc.getBoolean("ready") != false;
                row.ready = rdy ? "1/1" : "0/1";
                rows.add(row);
            }
        });
        rows.sort(this::sortRow);
        if (!rows.isEmpty()) {
            this.printer().println(AsciiTable.getTable((Character[])AsciiTable.NO_BORDERS, rows, Arrays.asList(new Column().header("PID").headerAlign(HorizontalAlign.CENTER).with(r -> r.pid), new Column().header("NAME").dataAlign(HorizontalAlign.LEFT).maxWidth(30, OverflowBehaviour.ELLIPSIS_RIGHT).with(r -> r.name), new Column().header("CAMEL").dataAlign(HorizontalAlign.LEFT).with(r -> r.camelVersion), new Column().header("PLATFORM").dataAlign(HorizontalAlign.LEFT).with(this::getPlatform), new Column().header("PROFILE").dataAlign(HorizontalAlign.LEFT).with(this::getProfile), new Column().header("READY").dataAlign(HorizontalAlign.CENTER).with(r -> r.ready), new Column().header("STATUS").headerAlign(HorizontalAlign.CENTER).with(this::getStatus), new Column().header("RELOAD").with(this::getReloaded), new Column().header("AGE").headerAlign(HorizontalAlign.CENTER).with(r -> r.age), new Column().header("ROUTE").with(this::getRoutes), new Column().header("MSG/S").with(this::getThroughput), new Column().header("TOTAL").with(this::getTotal), new Column().header("FAIL").with(this::getFailed), new Column().header("INFLIGHT").with(this::getInflight), new Column().header("LAST").with(r -> r.last), new Column().header("SINCE-LAST").with(this::getSinceLast), new Column().header("").headerAlign(HorizontalAlign.LEFT).dataAlign(HorizontalAlign.LEFT).maxWidth(70, OverflowBehaviour.NEWLINE).with(this::getDescription))));
        }
        return 0;
    }

    private String extractPlatform(ProcessHandle ph, JsonObject runtime) {
        String cl;
        String answer;
        String string = answer = runtime != null ? runtime.getString("platform") : null;
        if ("Camel".equals(answer) && (cl = ph.info().commandLine().orElse("")).contains("main.CamelJBang run")) {
            answer = "JBang";
        }
        return answer;
    }

    private String extractPlatformVersion(String platform, String platformVersion) {
        if (platformVersion == null && "JBang".equals(platform)) {
            platformVersion = VersionHelper.getJBangVersion();
        }
        return platformVersion;
    }

    protected int sortRow(Row o1, Row o2) {
        String s = this.sort;
        int negate = 1;
        if (s.startsWith("-")) {
            s = s.substring(1);
            negate = -1;
        }
        switch (s) {
            case "pid": {
                return Long.compare(Long.parseLong(o1.pid), Long.parseLong(o2.pid)) * negate;
            }
            case "name": {
                return o1.name.compareToIgnoreCase(o2.name) * negate;
            }
            case "age": {
                return Long.compare(o1.uptime, o2.uptime) * negate;
            }
        }
        return 0;
    }

    private String getStatus(Row r) {
        if (r.reloadedError != null) {
            return "Error";
        }
        return CamelCommandHelper.extractState(r.state);
    }

    private String getDescription(Row r) {
        if (r.reloadedError != null) {
            return "Reload failed due to: " + r.reloadedError;
        }
        return null;
    }

    private String getTotal(Row r) {
        if (this.remote && r.totalRemote != null) {
            return r.totalRemote + "/" + r.total;
        }
        return r.total;
    }

    private String getFailed(Row r) {
        if (this.remote && r.failedRemote != null) {
            return r.failedRemote + "/" + r.failed;
        }
        return r.failed;
    }

    private String getInflight(Row r) {
        if (this.remote && r.inflightRemote != null) {
            return r.inflightRemote + "/" + r.inflight;
        }
        return r.inflight;
    }

    private String getPlatform(Row r) {
        if (r.platformVersion != null) {
            return r.platform + " v" + r.platformVersion;
        }
        return r.platform;
    }

    protected String getProfile(Row r) {
        String s = r.profile;
        if (s == null || s.isEmpty()) {
            s = "";
        }
        return s;
    }

    protected String getDelta(Row r) {
        if (r.delta != null) {
            if (r.delta.startsWith("-")) {
                return r.delta;
            }
            if (!"0".equals(r.delta)) {
                return "+" + r.delta;
            }
        }
        return r.delta;
    }

    protected String getSinceLast(Row r) {
        String s1 = r.sinceLastStarted != null ? r.sinceLastStarted : "-";
        String s2 = r.sinceLastCompleted != null ? r.sinceLastCompleted : "-";
        String s3 = r.sinceLastFailed != null ? r.sinceLastFailed : "-";
        return s1 + "/" + s2 + "/" + s3;
    }

    protected String getThroughput(Row r) {
        String s = r.throughput;
        if (s == null || s.isEmpty()) {
            s = "";
        }
        return s;
    }

    protected String getReloaded(Row row) {
        return row.reloaded + "/" + row.reloadedFailed;
    }

    protected String getRoutes(Row r) {
        return r.routeStarted + "/" + r.routeTotal;
    }

    private static class Row {
        String pid;
        String platform;
        String platformVersion;
        String camelVersion;
        String profile;
        String name;
        String ready;
        int routeStarted;
        int routeTotal;
        int state;
        String reloaded;
        String reloadedFailed;
        String reloadedError;
        String age;
        long uptime;
        String throughput;
        String total;
        String totalRemote;
        String failed;
        String failedRemote;
        String inflight;
        String inflightRemote;
        String last;
        String delta;
        String sinceLastStarted;
        String sinceLastCompleted;
        String sinceLastFailed;

        private Row() {
        }
    }
}

