/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.jbang.core.commands.infra;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.camel.dsl.jbang.core.commands.CamelJBangMain;
import org.apache.camel.dsl.jbang.core.commands.infra.InfraBaseCommand;
import org.apache.camel.dsl.jbang.core.common.CommandLineHelper;
import picocli.CommandLine;

@CommandLine.Command(name="stop", description={"Stop an external service"})
public class InfraStop
extends InfraBaseCommand {
    @CommandLine.Parameters(description={"Service name"}, arity="1")
    private List<String> serviceName;

    public InfraStop(CamelJBangMain main) {
        super(main);
    }

    @Override
    public Integer doCall() throws Exception {
        String serviceToStop = this.serviceName.get(0);
        boolean serviceStopped = false;
        String pid = null;
        try {
            List pidFiles = Files.list(CommandLineHelper.getCamelDir()).filter(p -> p.getFileName().toString().startsWith("infra-" + serviceToStop + "-")).collect(Collectors.toList());
            Iterator iterator = pidFiles.iterator();
            if (iterator.hasNext()) {
                Path pidFile = (Path)iterator.next();
                String name = pidFile.getFileName().toString();
                pid = name.substring(name.lastIndexOf("-") + 1, name.lastIndexOf(46));
                Files.deleteIfExists(pidFile);
                serviceStopped = true;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (!serviceStopped) {
            this.printer().println("No Camel Infrastructure found with name " + serviceToStop + " found.");
            return -1;
        }
        this.printer().println("Shutting down service " + serviceToStop + " (PID: " + pid + ")");
        ProcessHandle.of(Long.valueOf(pid)).ifPresent(ProcessHandle::destroy);
        return 0;
    }
}

