/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.jbang.core.commands.infra;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.camel.dsl.jbang.core.commands.CamelJBangMain;
import org.apache.camel.dsl.jbang.core.commands.infra.InfraBaseCommand;
import org.apache.camel.dsl.jbang.core.common.CommandLineHelper;
import picocli.CommandLine;

@CommandLine.Command(name="ps", description={"Displays running services"}, sortOptions=false, showDefaultValues=true)
public class InfraPs
extends InfraBaseCommand {
    public InfraPs(CamelJBangMain main) {
        super(main);
    }

    @Override
    public Integer doCall() throws Exception {
        HashSet<String> runningAliases = new HashSet<String>();
        try {
            List pidFiles = Files.list(CommandLineHelper.getCamelDir()).filter(p -> p.getFileName().toString().startsWith("infra-")).collect(Collectors.toList());
            for (Path pidFile : pidFiles) {
                String runningServiceName = pidFile.getFileName().toString().split("-")[1];
                runningAliases.add(runningServiceName);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.listServices(rows -> {
            if (runningAliases.isEmpty()) {
                rows.clear();
            } else {
                rows.removeIf(row -> !runningAliases.contains(row.alias()));
            }
        });
    }
}

