/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.jbang.core.commands.infra;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.camel.dsl.jbang.core.commands.CamelJBangMain;
import org.apache.camel.dsl.jbang.core.commands.infra.InfraBaseCommand;
import org.apache.camel.dsl.jbang.core.common.CommandLineHelper;
import picocli.CommandLine;

@CommandLine.Command(name="get", description={"Displays running service information"}, sortOptions=false, showDefaultValues=true)
public class InfraGet
extends InfraBaseCommand {
    @CommandLine.Parameters(description={"Service name"}, arity="1")
    private List<String> serviceName;

    public InfraGet(CamelJBangMain main) {
        super(main);
    }

    @Override
    public Integer doCall() throws Exception {
        String serviceToGet = this.serviceName.get(0);
        boolean found = false;
        try {
            List jsonFiles = Files.list(CommandLineHelper.getCamelDir()).filter(p -> {
                String name = p.getFileName().toString();
                return name.startsWith("infra-" + serviceToGet + "-") && name.endsWith(".json");
            }).collect(Collectors.toList());
            if (!jsonFiles.isEmpty()) {
                this.printer().println(Files.readString((Path)jsonFiles.get(0)));
                found = true;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (!found) {
            this.printer().println("No running service found with alias " + serviceToGet);
            return -1;
        }
        return 0;
    }
}

