/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.jbang.core.commands.infra;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.github.freva.asciitable.AsciiTable;
import com.github.freva.asciitable.Column;
import com.github.freva.asciitable.HorizontalAlign;
import com.github.freva.asciitable.OverflowBehaviour;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.camel.catalog.DefaultCamelCatalog;
import org.apache.camel.dsl.jbang.core.commands.CamelCommand;
import org.apache.camel.dsl.jbang.core.commands.CamelJBangMain;
import org.apache.camel.util.json.Jsoner;
import picocli.CommandLine;

public abstract class InfraBaseCommand
extends CamelCommand {
    protected final ObjectMapper jsonMapper = new ObjectMapper();
    @CommandLine.Option(names={"--json"}, description={"Output in JSON Format"})
    boolean jsonOutput;

    public InfraBaseCommand(CamelJBangMain main) {
        super(main);
        this.jsonMapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        this.jsonMapper.enable(SerializationFeature.INDENT_OUTPUT);
        this.jsonMapper.configure(MapperFeature.SORT_PROPERTIES_ALPHABETICALLY, true);
        this.jsonMapper.configure(SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS, true);
    }

    protected List<TestInfraService> getMetadata() throws IOException {
        List metadata;
        DefaultCamelCatalog catalog = new DefaultCamelCatalog();
        try (InputStream is = catalog.loadResource("test-infra", "metadata.json");){
            String json = new String(is.readAllBytes(), StandardCharsets.UTF_8);
            metadata = (List)this.jsonMapper.readValue(json, (TypeReference)new TypeReference<List<TestInfraService>>(){});
        }
        return metadata;
    }

    public int listServices(Consumer<List<Row>> serviceConsumer) throws IOException {
        LinkedHashMap<String, InfraServiceAlias> services = new LinkedHashMap<String, InfraServiceAlias>();
        List<TestInfraService> metadata = this.getMetadata();
        ArrayList<Row> rows = new ArrayList<Row>(metadata.size());
        for (TestInfraService service : metadata) {
            for (String alias : service.alias()) {
                if (!services.containsKey(alias)) {
                    services.put(alias, new InfraServiceAlias(service.description()));
                }
                if (service.aliasImplementation() == null) continue;
                ((InfraServiceAlias)services.get(alias)).getAliasImplementation().addAll(service.aliasImplementation());
            }
        }
        int width = 0;
        for (Map.Entry entry : services.entrySet()) {
            width = Math.max(width, ((String)entry.getKey()).length());
            rows.add(new Row((String)entry.getKey(), ((InfraServiceAlias)entry.getValue()).getAliasImplementation().stream().sorted().collect(Collectors.joining(", ")), ((InfraServiceAlias)entry.getValue()).getDescription()));
        }
        rows.sort(Comparator.comparing(Row::alias));
        serviceConsumer.accept(rows);
        if (this.jsonOutput) {
            this.printer().println(Jsoner.serialize(rows.stream().map(row -> Map.of("alias", row.alias(), "aliasImplementation", row.aliasImplementation(), "description", row.description() == null ? "" : row.description())).collect(Collectors.toList())));
        } else {
            this.printer().println(AsciiTable.getTable((Character[])AsciiTable.NO_BORDERS, rows, Arrays.asList(new Column().header("ALIAS").minWidth(width + 5).dataAlign(HorizontalAlign.LEFT).with(r -> r.alias()), new Column().header("IMPLEMENTATION").maxWidth(40, OverflowBehaviour.NEWLINE).dataAlign(HorizontalAlign.LEFT).with(r -> r.aliasImplementation()), new Column().header("DESCRIPTION").dataAlign(HorizontalAlign.LEFT).with(r -> r.description()))));
        }
        return 0;
    }

    public String getLogFileName(String service, String pid) {
        return String.format("infra-%s-%s.log", service, pid);
    }

    public String getJsonFileName(String service, String pid) {
        return String.format("infra-%s-%s.json", service, pid);
    }

    record TestInfraService(String service, String implementation, String description, List<String> alias, List<String> aliasImplementation, String groupId, String artifactId, String version) {
    }

    private class InfraServiceAlias {
        private final String description;
        private final Set<String> aliasImplementation = new HashSet<String>();

        public InfraServiceAlias(String description) {
            this.description = description;
        }

        public String getDescription() {
            return this.description;
        }

        public Set<String> getAliasImplementation() {
            return this.aliasImplementation;
        }
    }

    record Row(String alias, String aliasImplementation, String description) {
    }
}

