/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.jbang.core.commands.config;

import java.io.IOException;
import org.apache.camel.dsl.jbang.core.commands.CamelCommand;
import org.apache.camel.dsl.jbang.core.commands.CamelJBangMain;
import org.apache.camel.dsl.jbang.core.common.CommandLineHelper;
import org.apache.camel.util.StringHelper;
import picocli.CommandLine;

@CommandLine.Command(name="set", description={"Set user configuration value"}, sortOptions=false, showDefaultValues=true)
public class ConfigSet
extends CamelCommand {
    @CommandLine.Parameters(description={"Configuration parameter (ex. key=value)"}, arity="1")
    String configuration;
    @CommandLine.Option(names={"--global"}, description={"Use global or local configuration"})
    boolean global = true;

    public ConfigSet(CamelJBangMain main) {
        super(main);
    }

    @Override
    public Integer doCall() throws Exception {
        return this.setConfiguration(!this.global);
    }

    private int setConfiguration(boolean local) throws IOException {
        CommandLineHelper.createPropertyFile(local);
        if (this.configuration.split("=").length == 1) {
            this.printer().println("Configuration parameter not in key=value format");
            return 1;
        }
        CommandLineHelper.loadProperties(properties -> {
            String key = StringHelper.before((String)this.configuration, (String)"=").trim();
            String value = StringHelper.after((String)this.configuration, (String)"=").trim();
            properties.put(key, value);
            CommandLineHelper.storeProperties(properties, this.printer(), local);
        }, local);
        return 0;
    }
}

