/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.jbang.core.commands.config;

import org.apache.camel.dsl.jbang.core.commands.CamelCommand;
import org.apache.camel.dsl.jbang.core.commands.CamelJBangMain;
import org.apache.camel.dsl.jbang.core.common.CommandLineHelper;
import picocli.CommandLine;

@CommandLine.Command(name="list", description={"Displays user configuration"}, sortOptions=false, showDefaultValues=true)
public class ConfigList
extends CamelCommand {
    @CommandLine.Option(names={"--global"}, description={"Use global or local configuration"})
    boolean global = true;

    public ConfigList(CamelJBangMain main) {
        super(main);
    }

    @Override
    public Integer doCall() throws Exception {
        this.listConfigurations(true);
        if (!this.global) {
            return 0;
        }
        this.listConfigurations(false);
        return 0;
    }

    private void listConfigurations(boolean local) {
        CommandLineHelper.loadProperties(p -> {
            if (!p.stringPropertyNames().isEmpty()) {
                String configurationType = local ? "Local" : "Global";
                this.printer().println("----- " + configurationType + " -----");
            }
            for (String k : p.stringPropertyNames()) {
                String v = p.getProperty(k);
                this.printer().printf("%s = %s%n", k, v);
            }
        }, local);
    }
}

