/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.jbang.core.commands.bind;

import java.io.InputStream;
import java.util.Map;
import org.apache.camel.dsl.jbang.core.commands.bind.BindingProvider;
import org.apache.camel.util.StringHelper;

public interface TemplateProvider {
    default public InputStream getPipeTemplate() {
        return TemplateProvider.class.getClassLoader().getResourceAsStream("templates/pipe.yaml.tmpl");
    }

    default public InputStream getStepTemplate(String stepType) {
        return TemplateProvider.class.getClassLoader().getResourceAsStream("templates/step-%s.yaml.tmpl".formatted(stepType));
    }

    default public InputStream getEndpointTemplate(String endpointType) {
        return TemplateProvider.class.getClassLoader().getResourceAsStream("templates/endpoint-%s.yaml.tmpl".formatted(endpointType));
    }

    default public InputStream getErrorHandlerTemplate(String type) {
        return TemplateProvider.class.getClassLoader().getResourceAsStream("templates/error-handler-%s.yaml.tmpl".formatted(type));
    }

    default public String asEndpointProperties(Map<String, Object> props) {
        StringBuilder sb = new StringBuilder();
        if (props.isEmpty()) {
            return sb.append("#properties:\n      ").append("#key: \"value\"").toString();
        }
        sb.append("properties:\n");
        for (Map.Entry<String, Object> propertyEntry : props.entrySet()) {
            String propValue = propertyEntry.getValue().toString();
            if (propValue.contains(":") && !StringHelper.isQuoted((String)propValue)) {
                propValue = "\"%s\"".formatted(propValue);
            }
            sb.append("      ").append(propertyEntry.getKey()).append(": ").append(propValue).append("\n");
        }
        return sb.toString().trim();
    }

    default public String asErrorHandlerParameters(Map<String, Object> props) {
        if (props.isEmpty()) {
            return "parameters: {}";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("parameters:\n");
        for (Map.Entry<String, Object> propertyEntry : props.entrySet()) {
            sb.append("        ").append(propertyEntry.getKey()).append(": ").append(propertyEntry.getValue()).append("\n");
        }
        return sb.toString().trim();
    }

    default public int getAdditionalIndent(BindingProvider.EndpointType type) {
        if (type == BindingProvider.EndpointType.ERROR_HANDLER) {
            return 4;
        }
        return 0;
    }
}

