/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.jbang.core.commands.bind;

import java.io.Closeable;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.camel.CamelException;
import org.apache.camel.dsl.jbang.core.commands.bind.BindingProvider;
import org.apache.camel.dsl.jbang.core.commands.bind.TemplateProvider;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StringHelper;
import org.apache.camel.util.URISupport;

public class ObjectReferenceBindingProvider
implements BindingProvider {
    private static final Pattern OBJECT_REFERENCE_URI_PATTERN = Pattern.compile("^([a-z.]+/[alphbetv0-9]+):([A-Z][a-z]+):([a-z][a-z-]*/?[a-z][a-z-]*)\\??[^?]*", 32);
    private final String apiVersion;
    private final String kind;

    public ObjectReferenceBindingProvider() {
        this("", "");
    }

    protected ObjectReferenceBindingProvider(String apiVersion, String kind) {
        if (ObjectHelper.isNotEmpty((String)kind) && ObjectHelper.isEmpty((String)apiVersion)) {
            throw new IllegalArgumentException("Object reference provider with static kind '%s' requires apiVersion to be set.".formatted(kind));
        }
        this.apiVersion = apiVersion;
        this.kind = kind;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public String getEndpoint(BindingProvider.EndpointType type, String uriExpression, Map<String, Object> endpointProperties, TemplateProvider templateProvider) throws Exception {
        String namespace;
        String objectName;
        String kindValue;
        String apiVersionValue;
        if (ObjectHelper.isEmpty((String)this.kind)) {
            Matcher objectRef = OBJECT_REFERENCE_URI_PATTERN.matcher(uriExpression);
            if (!objectRef.matches()) throw new CamelException("Unsupported object reference: %s".formatted(uriExpression));
            apiVersionValue = objectRef.group(1);
            kindValue = objectRef.group(2);
            String namespacedName = objectRef.group(3);
            objectName = this.getObjectName(namespacedName);
            namespace = this.getNamespace(namespacedName);
        } else {
            apiVersionValue = this.apiVersion;
            kindValue = this.kind;
            objectName = this.getObjectName(uriExpression);
            namespace = this.getNamespace(uriExpression);
        }
        Map<String, Object> endpointUriProperties = this.getEndpointUriProperties(type, objectName, uriExpression, endpointProperties);
        InputStream is = type == BindingProvider.EndpointType.STEP ? templateProvider.getStepTemplate("ref") : templateProvider.getEndpointTemplate("ref");
        String context = IOHelper.loadText((InputStream)is);
        IOHelper.close((Closeable)is);
        Object namespaceContext = "";
        if (namespace != null) {
            namespaceContext = "      namespace: " + namespace + "\n";
        }
        context = context.replaceFirst("\\{\\{ \\.ApiVersion }}", apiVersionValue);
        context = context.replaceFirst("\\{\\{ \\.Kind }}", kindValue);
        context = context.replaceFirst("\\{\\{ \\.Name }}", objectName);
        context = context.replaceFirst("\\{\\{ \\.Namespace }}\n", (String)namespaceContext);
        return context.replaceFirst("\\{\\{ \\.EndpointProperties }}\n", templateProvider.asEndpointProperties(endpointUriProperties));
    }

    protected String getObjectName(String uriExpression) {
        String namespacedName = uriExpression;
        if (uriExpression.contains("?")) {
            namespacedName = StringHelper.before((String)uriExpression, (String)"?");
        }
        if (namespacedName.contains("/")) {
            return namespacedName.split("/", 2)[1];
        }
        return namespacedName;
    }

    protected String getNamespace(String uriExpression) {
        String namespacedName = uriExpression;
        if (uriExpression.contains("?")) {
            namespacedName = StringHelper.before((String)uriExpression, (String)"?");
        }
        if (namespacedName.contains("/")) {
            return namespacedName.split("/", 2)[0];
        }
        return null;
    }

    protected Map<String, Object> getEndpointUriProperties(BindingProvider.EndpointType type, String objectName, String uriExpression, Map<String, Object> endpointProperties) throws Exception {
        String query;
        Map<String, Object> endpointUriProperties = new HashMap<String, Object>(endpointProperties);
        if (uriExpression.contains("?") && (query = StringHelper.after((String)uriExpression, (String)"?")) != null) {
            endpointUriProperties = URISupport.parseQuery((String)query, (boolean)true);
        }
        return endpointUriProperties;
    }

    @Override
    public boolean canHandle(String uriExpression) {
        if (ObjectHelper.isNotEmpty((String)this.kind)) {
            return uriExpression.startsWith(this.kind.toLowerCase(Locale.US) + ":");
        }
        return OBJECT_REFERENCE_URI_PATTERN.matcher(uriExpression).matches();
    }
}

