/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.jbang.core.commands.action;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.apache.camel.dsl.jbang.core.commands.CamelJBangMain;
import org.apache.camel.dsl.jbang.core.commands.Run;
import org.apache.camel.dsl.jbang.core.commands.action.ActionWatchCommand;
import org.apache.camel.dsl.jbang.core.commands.action.MessageTableHelper;
import org.apache.camel.dsl.jbang.core.common.CommandLineHelper;
import org.apache.camel.dsl.jbang.core.common.PathUtils;
import org.apache.camel.dsl.jbang.core.common.VersionHelper;
import org.apache.camel.util.StopWatch;
import org.apache.camel.util.StringHelper;
import org.apache.camel.util.TimeUtils;
import org.apache.camel.util.json.JsonArray;
import org.apache.camel.util.json.JsonObject;
import org.apache.camel.util.json.Jsoner;
import org.fusesource.jansi.Ansi;
import org.fusesource.jansi.AnsiConsole;
import picocli.CommandLine;

@CommandLine.Command(name="message", description={"Transform message from one format to another via an existing running Camel integration"}, sortOptions=false, showDefaultValues=true)
public class TransformMessageAction
extends ActionWatchCommand {
    @CommandLine.Option(names={"--camel-version"}, description={"To run using a different Camel version than the default version."})
    String camelVersion;
    @CommandLine.Option(names={"--body"}, required=true, description={"Message body to send (prefix with file: to refer to loading message body from file)"})
    String body;
    @CommandLine.Option(names={"--header"}, description={"Message header (key=value)"})
    List<String> headers;
    @CommandLine.Option(names={"--source"}, description={"Instead of using external template file then refer to an existing Camel route source with inlined Camel language expression in a route. (use :line-number or :id to refer to the exact location of the EIP to use)"})
    private String source;
    @CommandLine.Option(names={"--language"}, description={"The language to use for message transformation"})
    private String language;
    @CommandLine.Option(names={"--component"}, description={"The component to use for message transformation"})
    private String component;
    @CommandLine.Option(names={"--dataformat"}, description={"The dataformat to use for message transformation"})
    private String dataformat;
    @CommandLine.Option(names={"--template"}, description={"The template to use for message transformation (prefix with file: to refer to loading message body from file)"})
    private String template;
    @CommandLine.Option(names={"--option"}, description={"Option for additional configuration of the used language, component or dataformat (key=value)"})
    List<String> options;
    @CommandLine.Option(names={"--output"}, description={"File to store output. If none provide then output is printed to console."})
    private String output;
    @CommandLine.Option(names={"--show-exchange-properties"}, defaultValue="false", description={"Show exchange properties from the output message"})
    boolean showExchangeProperties;
    @CommandLine.Option(names={"--show-headers"}, defaultValue="true", description={"Show message headers from the output message"})
    boolean showHeaders = true;
    @CommandLine.Option(names={"--show-body"}, defaultValue="true", description={"Show message body from the output message"})
    boolean showBody = true;
    @CommandLine.Option(names={"--show-exception"}, defaultValue="true", description={"Show exception and stacktrace for failed transformation"})
    boolean showException = true;
    @CommandLine.Option(names={"--timeout"}, defaultValue="20000", description={"Timeout in millis waiting for message to be transformed"})
    long timeout = 20000L;
    @CommandLine.Option(names={"--logging-color"}, defaultValue="true", description={"Use colored logging"})
    boolean loggingColor = true;
    @CommandLine.Option(names={"--pretty"}, description={"Pretty print message body when using JSon or XML format"})
    boolean pretty;
    @CommandLine.Option(names={"--repos"}, description={"Additional maven repositories (Use commas to separate multiple repositories)"})
    String repositories;
    private volatile long pid;
    private MessageTableHelper tableHelper;

    public TransformMessageAction(CamelJBangMain main) {
        super(main);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Integer doCall() throws Exception {
        Integer exit;
        Path f;
        if (this.dataformat == null) {
            if (this.source == null && this.template == null && this.language == null && this.component == null) {
                this.printer().printErr("Either source or template and one of language/component must be configured");
                return -1;
            }
            if (this.source == null && (this.template == null || this.language == null && this.component == null)) {
                this.printer().printErr("Both template and one of language/component must be configured");
                return -1;
            }
        }
        if (this.source != null && this.source.startsWith("file:")) {
            String s = this.source.substring(5);
            Path f2 = Path.of(s = StringHelper.beforeLast((String)s, (String)":", (String)s), new String[0]);
            if (!Files.exists(f2, new LinkOption[0])) {
                this.printer().printErr("Source file does not exist: " + String.valueOf(f2));
                return -1;
            }
        }
        if (this.template != null && this.template.startsWith("file:") && !Files.exists(f = Path.of(this.template.substring(5), new String[0]), new LinkOption[0])) {
            this.printer().printErr("Template file does not exist: " + String.valueOf(f));
            return -1;
        }
        try {
            Run run = new Run(this.getMain());
            if (this.camelVersion != null && VersionHelper.isLE(this.camelVersion, "4.2.0")) {
                this.printer().printErr("This requires Camel version 4.3 or newer");
                Integer n = -1;
                return n;
            }
            exit = run.runTransformMessage(this.camelVersion, this.repositories);
            this.pid = run.spawnPid;
            if (exit == 0) {
                exit = super.doCall();
            }
        }
        finally {
            if (this.pid > 0L) {
                Path outputFile = this.getOutputFile(Long.toString(this.pid));
                PathUtils.deleteFile(outputFile);
                Path parent = CommandLineHelper.getCamelDir();
                Path pidFile = parent.resolve(Long.toString(this.pid));
                if (Files.exists(pidFile, new LinkOption[0])) {
                    PathUtils.deleteFile(pidFile);
                }
            }
        }
        return exit;
    }

    @Override
    protected Integer doWatchCall() throws Exception {
        JsonObject jo;
        JsonArray arr;
        Path outputFile = this.getOutputFile(Long.toString(this.pid));
        PathUtils.deleteFile(outputFile);
        JsonObject root = new JsonObject();
        root.put((Object)"action", (Object)"transform");
        if (this.source != null) {
            root.put((Object)"source", (Object)this.source);
        }
        if (this.language != null) {
            root.put((Object)"language", (Object)this.language);
        }
        if (this.component != null) {
            root.put((Object)"component", (Object)this.component);
        }
        if (this.dataformat != null) {
            root.put((Object)"dataformat", (Object)this.dataformat);
        }
        if (this.template != null) {
            root.put((Object)"template", (Object)Jsoner.escape((String)this.template));
        }
        root.put((Object)"body", (Object)Jsoner.escape((String)this.body));
        if (this.headers != null) {
            arr = new JsonArray();
            for (String h : this.headers) {
                jo = new JsonObject();
                if (!h.contains("=")) {
                    this.printer().println("Header must be in key=value format, was: " + h);
                    return 0;
                }
                jo.put((Object)"key", (Object)StringHelper.before((String)h, (String)"="));
                jo.put((Object)"value", (Object)StringHelper.after((String)h, (String)"="));
                arr.add((Object)jo);
            }
            root.put((Object)"headers", (Object)arr);
        }
        if (this.options != null) {
            arr = new JsonArray();
            for (String h : this.options) {
                jo = new JsonObject();
                if (!h.contains("=")) {
                    this.printer().println("Option must be in key=value format, was: " + h);
                    return 0;
                }
                jo.put((Object)"key", (Object)StringHelper.before((String)h, (String)"="));
                jo.put((Object)"value", (Object)StringHelper.after((String)h, (String)"="));
                arr.add((Object)jo);
            }
            root.put((Object)"options", (Object)arr);
        }
        Path f = this.getActionFile(Long.toString(this.pid));
        try {
            PathUtils.writeTextSafely(root.toJson(), f);
        }
        catch (Exception exception) {
            // empty catch block
        }
        JsonObject jo2 = this.waitForOutputFile(outputFile);
        if (jo2 != null) {
            this.printStatusLine(jo2);
            String exchangeId = jo2.getString("exchangeId");
            JsonObject message = (JsonObject)jo2.getMap("message");
            JsonObject cause = (JsonObject)jo2.getMap("exception");
            if (message != null || cause != null) {
                if (this.output != null) {
                    Path target = Path.of(this.output, new String[0]);
                    String json = jo2.toJson();
                    if (this.pretty) {
                        json = Jsoner.prettyPrint((String)json, (int)2);
                    }
                    Files.writeString(target, (CharSequence)json, new OpenOption[0]);
                }
                if (!this.showExchangeProperties && message != null) {
                    message.remove((Object)"exchangeProperties");
                }
                if (!this.showHeaders && message != null) {
                    message.remove((Object)"headers");
                }
                if (!this.showBody && message != null) {
                    message.remove((Object)"body");
                }
                if (!this.showException && cause != null) {
                    cause = null;
                }
                if (this.output == null) {
                    if (this.watch) {
                        this.clearScreen();
                    }
                    this.tableHelper = new MessageTableHelper();
                    this.tableHelper.setPretty(this.pretty);
                    this.tableHelper.setLoggingColor(this.loggingColor);
                    this.tableHelper.setShowExchangeProperties(this.showExchangeProperties);
                    String table = this.tableHelper.getDataAsTable(exchangeId, "InOut", null, null, message, cause);
                    this.printer().println(table);
                }
            }
        }
        PathUtils.deleteFile(outputFile);
        return 0;
    }

    private void printStatusLine(JsonObject jo) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        String ts = sdf.format(new Date(jo.getLong("timestamp")));
        if (this.loggingColor) {
            AnsiConsole.out().print((Object)Ansi.ansi().fgBrightDefault().a(Ansi.Attribute.INTENSITY_FAINT).a(ts).reset());
        } else {
            this.printer().print(ts);
        }
        this.printer().print("  ");
        String p = String.format("%5.5s", this.pid);
        if (this.loggingColor) {
            AnsiConsole.out().print((Object)Ansi.ansi().fgMagenta().a(p).reset());
            AnsiConsole.out().print((Object)Ansi.ansi().fgBrightDefault().a(Ansi.Attribute.INTENSITY_FAINT).a(" --- ").reset());
        } else {
            this.printer().print(p);
            this.printer().print(" --- ");
        }
        this.printer().print(this.getStatus(jo));
        String e = TimeUtils.printDuration((long)jo.getLong("elapsed"), (boolean)true);
        if (this.loggingColor) {
            AnsiConsole.out().print((Object)Ansi.ansi().fgBrightDefault().a(" (" + e + ")").reset());
        } else {
            this.printer().print("(" + e + ")");
        }
        this.printer().println();
    }

    private String getStatus(JsonObject r) {
        boolean failed;
        boolean bl = failed = "failed".equals(r.getString("status")) || "error".equals(r.getString("status"));
        String status = failed ? "Failed (exception)" : (this.output != null ? "Output saved to file (success)" : "Message transformed (success)");
        if (this.loggingColor) {
            return Ansi.ansi().fg(failed ? Ansi.Color.RED : Ansi.Color.GREEN).a(status).reset().toString();
        }
        return status;
    }

    protected JsonObject waitForOutputFile(Path outputFile) {
        StopWatch watch = new StopWatch();
        while (watch.taken() < this.timeout) {
            try {
                Thread.sleep(20L);
                if (!Files.exists(outputFile, new LinkOption[0])) continue;
                String text = Files.readString(outputFile);
                return (JsonObject)Jsoner.deserialize((String)text);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (Exception exception) {
            }
        }
        return null;
    }
}

