/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.jbang.core.commands.action;

import com.github.freva.asciitable.AsciiTable;
import com.github.freva.asciitable.Column;
import com.github.freva.asciitable.HorizontalAlign;
import com.github.freva.asciitable.OverflowBehaviour;
import java.io.Closeable;
import java.io.IOException;
import java.io.LineNumberReader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import org.apache.camel.catalog.impl.TimePatternConverter;
import org.apache.camel.dsl.jbang.core.commands.CamelJBangMain;
import org.apache.camel.dsl.jbang.core.commands.CommandHelper;
import org.apache.camel.dsl.jbang.core.commands.action.ActionBaseCommand;
import org.apache.camel.dsl.jbang.core.commands.action.MessageTableHelper;
import org.apache.camel.dsl.jbang.core.common.PidNameAgeCompletionCandidates;
import org.apache.camel.dsl.jbang.core.common.ProcessHelper;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.StopWatch;
import org.apache.camel.util.StringHelper;
import org.apache.camel.util.TimeUtils;
import org.apache.camel.util.URISupport;
import org.apache.camel.util.json.JsonArray;
import org.apache.camel.util.json.JsonObject;
import org.apache.camel.util.json.Jsoner;
import org.fusesource.jansi.Ansi;
import org.fusesource.jansi.AnsiConsole;
import picocli.CommandLine;

@CommandLine.Command(name="trace", description={"Tail message traces from running Camel integrations"}, sortOptions=false, showDefaultValues=true)
public class CamelTraceAction
extends ActionBaseCommand {
    private static final int NAME_MAX_WIDTH = 25;
    private static final int NAME_MIN_WIDTH = 10;
    private CommandHelper.ReadConsoleTask waitUserTask;
    @CommandLine.Parameters(description={"Name or pid of running Camel integration. (default selects all)"}, arity="0..1")
    String name = "*";
    @CommandLine.Option(names={"--action"}, completionCandidates=ActionCompletionCandidates.class, defaultValue="status", description={"Action to start, stop, clear, list status, or dump traces"})
    String action;
    @CommandLine.Option(names={"--sort"}, completionCandidates=PidNameAgeCompletionCandidates.class, description={"Sort by pid, name or age for showing status of tracing"}, defaultValue="pid")
    String sort;
    @CommandLine.Option(names={"--timestamp"}, defaultValue="true", description={"Print timestamp."})
    boolean timestamp = true;
    @CommandLine.Option(names={"--ago"}, description={"Use ago instead of yyyy-MM-dd HH:mm:ss in timestamp."})
    boolean ago;
    @CommandLine.Option(names={"--follow"}, defaultValue="true", description={"Keep following and outputting new traces (press enter to exit)."})
    boolean follow = true;
    @CommandLine.Option(names={"--prefix"}, defaultValue="auto", completionCandidates=PrefixCompletionCandidates.class, description={"Print prefix with running Camel integration name. auto=only prefix when running multiple integrations. true=always prefix. false=prefix off."})
    String prefix = "auto";
    @CommandLine.Option(names={"--source"}, description={"Prefer to display source filename/code instead of IDs"})
    boolean source;
    @CommandLine.Option(names={"--depth"}, defaultValue="9", description={"Depth of tracing. 0=Created+Completed. 1=All events on 1st route, 2=All events on 1st+2nd depth, and so on. 9 = all events on every depth."})
    int depth;
    @CommandLine.Option(names={"--tail"}, defaultValue="-1", description={"The number of traces from the end of the trace to show. Use -1 to read from the beginning. Use 0 to read only new lines. Defaults to showing all traces from beginning."})
    int tail = -1;
    @CommandLine.Option(names={"--since"}, description={"Return traces newer than a relative duration like 5s, 2m, or 1h. The value is in seconds if no unit specified."})
    String since;
    @CommandLine.Option(names={"--find"}, description={"Find and highlight matching text (ignore case)."}, arity="0..*")
    String[] find;
    @CommandLine.Option(names={"--grep"}, description={"Filter traces to only output trace matching text (ignore case)."}, arity="0..*")
    String[] grep;
    @CommandLine.Option(names={"--show-exchange-properties"}, defaultValue="false", description={"Show exchange properties in traced messages"})
    boolean showExchangeProperties;
    @CommandLine.Option(names={"--show-exchange-variables"}, defaultValue="true", description={"Show exchange variables in traced messages"})
    boolean showExchangeVariables = true;
    @CommandLine.Option(names={"--show-headers"}, defaultValue="true", description={"Show message headers in traced messages"})
    boolean showHeaders = true;
    @CommandLine.Option(names={"--show-body"}, defaultValue="true", description={"Show message body in traced messages"})
    boolean showBody = true;
    @CommandLine.Option(names={"--show-exception"}, defaultValue="true", description={"Show exception and stacktrace for failed messages"})
    boolean showException = true;
    @CommandLine.Option(names={"--logging-color"}, defaultValue="true", description={"Use colored logging"})
    boolean loggingColor = true;
    @CommandLine.Option(names={"--compact"}, defaultValue="true", description={"Compact output (no empty line separating traced messages)"})
    boolean compact = true;
    @CommandLine.Option(names={"--latest"}, description={"Only output traces from the latest (follow if necessary until complete and exit)"})
    boolean latest;
    @CommandLine.Option(names={"--mask"}, description={"Whether to mask endpoint URIs to avoid printing sensitive information such as password or access keys"})
    boolean mask;
    @CommandLine.Option(names={"--pretty"}, description={"Pretty print message body when using JSon or XML format"})
    boolean pretty;
    String findAnsi;
    private int nameMaxWidth;
    private boolean prefixShown;
    private MessageTableHelper tableHelper;
    private final Map<String, Ansi.Color> nameColors = new HashMap<String, Ansi.Color>();
    private final Map<String, Ansi.Color> exchangeIdColors = new HashMap<String, Ansi.Color>();
    private int exchangeIdColorsIndex = 1;

    public CamelTraceAction(CamelJBangMain main) {
        super(main);
    }

    @Override
    public Integer doCall() throws Exception {
        if ("dump".equals(this.action)) {
            return this.doDumpCall();
        }
        if ("status".equals(this.action)) {
            return this.doStatusCall();
        }
        List<Long> pids = this.findPids(this.name);
        for (long pid : pids) {
            if ("clear".equals(this.action)) {
                Path f = this.getTraceFile("" + pid);
                if (!Files.exists(f, new LinkOption[0])) continue;
                Files.writeString(f, (CharSequence)"{}", new OpenOption[0]);
                continue;
            }
            JsonObject root = new JsonObject();
            root.put((Object)"action", (Object)"trace");
            if ("start".equals(this.action)) {
                root.put((Object)"enabled", (Object)"true");
            } else if ("stop".equals(this.action)) {
                root.put((Object)"enabled", (Object)"false");
            }
            Path f = this.getActionFile(Long.toString(pid));
            Files.writeString(f, (CharSequence)root.toJson(), new OpenOption[0]);
        }
        return 0;
    }

    protected Integer doStatusCall() {
        ArrayList rows = new ArrayList();
        List<Long> pids = this.findPids(this.name);
        ProcessHandle.allProcesses().filter(ph -> pids.contains(ph.pid())).forEach(ph -> {
            JsonObject root = this.loadStatus(ph.pid());
            if (root != null) {
                StatusRow row = new StatusRow();
                JsonObject context = (JsonObject)root.get((Object)"context");
                if (context == null) {
                    return;
                }
                row.name = context.getString("name");
                if ("CamelJBang".equals(row.name)) {
                    row.name = ProcessHelper.extractName(root, ph);
                }
                row.pid = Long.toString(ph.pid());
                row.uptime = CamelTraceAction.extractSince(ph);
                row.age = TimeUtils.printSince((long)row.uptime);
                JsonObject jo = (JsonObject)root.getMap("trace");
                if (jo != null) {
                    row.enabled = jo.getBoolean("enabled");
                    row.standby = jo.getBoolean("standby");
                    row.counter = jo.getLong("counter");
                    row.queueSize = jo.getLong("queueSize");
                    row.filter = jo.getString("traceFilter");
                    row.pattern = jo.getString("tracePattern");
                }
                rows.add(row);
            }
        });
        rows.sort(this::sortStatusRow);
        if (!rows.isEmpty()) {
            this.printer().println(AsciiTable.getTable((Character[])AsciiTable.NO_BORDERS, rows, Arrays.asList(new Column().header("PID").headerAlign(HorizontalAlign.CENTER).with(r -> r.pid), new Column().header("NAME").dataAlign(HorizontalAlign.LEFT).maxWidth(30, OverflowBehaviour.ELLIPSIS_RIGHT).with(r -> r.name), new Column().header("AGE").headerAlign(HorizontalAlign.CENTER).with(r -> r.age), new Column().header("STATUS").with(this::getTraceStatus), new Column().header("TOTAL").with(r -> "" + r.counter), new Column().header("QUEUE").with(r -> "" + r.queueSize), new Column().header("FILTER").with(r -> r.filter), new Column().header("PATTERN").with(r -> r.pattern))));
        }
        return 0;
    }

    private String getTraceStatus(StatusRow r) {
        if (r.enabled) {
            return "Started";
        }
        if (r.standby) {
            return "Standby";
        }
        return "Stopped";
    }

    protected int sortStatusRow(StatusRow o1, StatusRow o2) {
        String s = this.sort;
        int negate = 1;
        if (s.startsWith("-")) {
            s = s.substring(1);
            negate = -1;
        }
        switch (s) {
            case "pid": {
                return Long.compare(Long.parseLong(o1.pid), Long.parseLong(o2.pid)) * negate;
            }
            case "name": {
                return o1.name.compareToIgnoreCase(o2.name) * negate;
            }
            case "age": {
                return Long.compare(o1.uptime, o2.uptime) * negate;
            }
        }
        return 0;
    }

    protected Integer doDumpCall() throws Exception {
        this.tableHelper = new MessageTableHelper();
        this.tableHelper.setPretty(this.pretty);
        this.tableHelper.setLoggingColor(this.loggingColor);
        this.tableHelper.setShowExchangeProperties(this.showExchangeProperties);
        this.tableHelper.setShowExchangeVariables(this.showExchangeVariables);
        this.tableHelper.setExchangeIdColorChooser(value -> {
            Ansi.Color color = this.exchangeIdColors.get(value);
            if (color == null) {
                ++this.exchangeIdColorsIndex;
                if (this.exchangeIdColorsIndex > 6) {
                    this.exchangeIdColorsIndex = 2;
                }
                color = Ansi.Color.values()[this.exchangeIdColorsIndex];
                this.exchangeIdColors.put(value, color);
            }
            return color;
        });
        LinkedHashMap<Long, Pid> pids = new LinkedHashMap<Long, Pid>();
        if (this.latest) {
            this.tail = 0;
            this.since = null;
        }
        this.updatePids(pids);
        if (!pids.isEmpty()) {
            String f;
            int i;
            if (this.find != null) {
                this.findAnsi = Ansi.ansi().fg(Ansi.Color.BLACK).bg(Ansi.Color.YELLOW).a("$0").reset().toString();
                for (i = 0; i < this.find.length; ++i) {
                    f = this.find[i];
                    this.find[i] = f = Pattern.quote(f);
                }
            }
            if (this.grep != null) {
                this.findAnsi = Ansi.ansi().fg(Ansi.Color.BLACK).bg(Ansi.Color.YELLOW).a("$0").reset().toString();
                for (i = 0; i < this.grep.length; ++i) {
                    f = this.grep[i];
                    this.grep[i] = f = Pattern.quote(f);
                }
            }
            Date limit = null;
            if (this.since != null) {
                long millis = StringHelper.isDigit((String)this.since) ? TimePatternConverter.toMilliSeconds((String)this.since) * 1000L : TimePatternConverter.toMilliSeconds((String)this.since);
                limit = new Date(System.currentTimeMillis() - millis);
            }
            if (this.tail != 0) {
                this.tailTraceFiles(pids, this.tail);
                this.dumpTraceFiles(pids, this.tail, limit);
            } else if (this.latest) {
                this.positionTraceLatest(pids);
            }
        }
        if (this.follow) {
            boolean waitMessage = true;
            AtomicBoolean running = new AtomicBoolean(true);
            StopWatch watch = new StopWatch();
            Thread t = new Thread(() -> {
                this.waitUserTask = new CommandHelper.ReadConsoleTask(() -> running.set(false));
                this.waitUserTask.run();
            }, "WaitForUser");
            t.start();
            boolean more = true;
            do {
                int lines;
                if (pids.isEmpty()) {
                    if (waitMessage) {
                        this.printer().println("Waiting for traces ...");
                        waitMessage = false;
                    }
                    Thread.sleep(500L);
                    this.updatePids(pids);
                    continue;
                }
                waitMessage = true;
                if (watch.taken() > 500L) {
                    this.updatePids(pids);
                    watch.restart();
                }
                if ((lines = this.readTraceFiles(pids)) > 0) {
                    more = this.dumpTraceFiles(pids, 0, null);
                    continue;
                }
                if (lines != 0) break;
                Thread.sleep(100L);
            } while (more && running.get());
        }
        return 0;
    }

    private void positionTraceLatest(Map<Long, Pid> pids) throws Exception {
        for (Pid pid : pids.values()) {
            Path file = this.getTraceFile(pid.pid);
            long position = -1L;
            if (Files.exists(file, new LinkOption[0])) {
                String line;
                pid.reader = new LineNumberReader(Files.newBufferedReader(file));
                long counter = 0L;
                block1: do {
                    if ((line = pid.reader.readLine()) == null) continue;
                    ++counter;
                    List<Row> rows = this.parseTraceLine(pid, line);
                    for (Row r : rows) {
                        if (!r.first) continue;
                        position = counter;
                        continue block1;
                    }
                } while (line != null);
            }
            if (position == -1L) continue;
            IOHelper.close((Closeable)pid.reader);
            pid.reader = new LineNumberReader(Files.newBufferedReader(file));
            while (--position > 0L) {
                pid.reader.readLine();
            }
        }
    }

    private void tailTraceFiles(Map<Long, Pid> pids, int tail) throws Exception {
        for (Pid pid : pids.values()) {
            String line;
            Path file = this.getTraceFile(pid.pid);
            if (!Files.exists(file, new LinkOption[0])) continue;
            pid.reader = new LineNumberReader(Files.newBufferedReader(file));
            pid.fifo = tail <= 0 ? new ArrayDeque<String>() : new ArrayBlockingQueue<String>(tail);
            do {
                if ((line = pid.reader.readLine()) == null) continue;
                while (!pid.fifo.offer(line)) {
                    pid.fifo.poll();
                }
            } while (line != null);
        }
    }

    private void updatePids(Map<Long, Pid> rows) {
        List<Long> pids = this.findPids(this.name);
        ProcessHandle.allProcesses().filter(ph -> pids.contains(ph.pid())).forEach(ph -> {
            JsonObject root = this.loadStatus(ph.pid());
            if (root != null) {
                int len;
                Pid row = new Pid();
                row.pid = Long.toString(ph.pid());
                JsonObject context = (JsonObject)root.get((Object)"context");
                if (context == null) {
                    return;
                }
                row.name = context.getString("name");
                if ("CamelJBang".equals(row.name)) {
                    row.name = ProcessHelper.extractName(root, ph);
                }
                if ((len = row.name.length()) < 10) {
                    len = 10;
                }
                if (len > 25) {
                    len = 25;
                }
                if (len > this.nameMaxWidth) {
                    this.nameMaxWidth = len;
                }
                if (!rows.containsKey(ph.pid())) {
                    rows.put(ph.pid(), row);
                }
            }
        });
        HashSet<Long> remove = new HashSet<Long>();
        for (long pid : rows.keySet()) {
            if (pids.contains(pid)) continue;
            remove.add(pid);
        }
        for (long pid : remove) {
            rows.remove(pid);
        }
    }

    private int readTraceFiles(Map<Long, Pid> pids) throws Exception {
        int lines = 0;
        for (Pid pid : pids.values()) {
            String line;
            Path file;
            if (pid.reader == null && Files.exists(file = this.getTraceFile(pid.pid), new LinkOption[0])) {
                pid.reader = new LineNumberReader(Files.newBufferedReader(file));
                if (this.tail == 0) {
                    long size = Files.size(file);
                    pid.reader.skip(size);
                }
            }
            if (pid.reader == null) continue;
            do {
                try {
                    line = pid.reader.readLine();
                    if (line == null) continue;
                    ++lines;
                    if (pid.fifo == null || pid.fifo instanceof ArrayBlockingQueue) {
                        pid.fifo = new ArrayDeque<String>();
                    }
                    pid.fifo.offer(line);
                }
                catch (IOException e) {
                    line = null;
                }
            } while (line != null);
        }
        return lines;
    }

    private List<Row> parseTraceLine(Pid pid, String line) {
        JsonObject root = null;
        try {
            root = (JsonObject)Jsoner.deserialize((String)line);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (root != null) {
            ArrayList<Row> rows = new ArrayList<Row>();
            JsonArray arr = (JsonArray)root.getCollection("traces");
            if (arr != null) {
                for (Object o : arr) {
                    Long ts;
                    JsonObject es;
                    Row row = new Row(pid);
                    row.pid = pid.pid;
                    row.name = pid.name;
                    JsonObject jo = (JsonObject)o;
                    row.uid = jo.getLong("uid");
                    row.first = jo.getBoolean("first");
                    row.last = jo.getBoolean("last");
                    row.location = jo.getString("location");
                    row.routeId = jo.getString("routeId");
                    row.nodeId = jo.getString("nodeId");
                    String uri = jo.getString("endpointUri");
                    if (uri != null) {
                        row.endpoint = new JsonObject();
                        if (this.mask) {
                            uri = URISupport.sanitizeUri((String)uri);
                        }
                        row.endpoint.put((Object)"endpoint", (Object)uri);
                        row.endpoint.put((Object)"remote", (Object)jo.getBooleanOrDefault("remoteEndpoint", true));
                    }
                    if ((es = (JsonObject)jo.getMap("endpointService")) != null) {
                        row.endpointService = es;
                    }
                    if ((ts = jo.getLong("timestamp")) != null) {
                        row.timestamp = ts;
                    }
                    row.elapsed = jo.getLong("elapsed");
                    row.failed = jo.getBoolean("failed");
                    row.done = jo.getBoolean("done");
                    row.threadName = jo.getString("threadName");
                    row.message = (JsonObject)jo.getMap("message");
                    row.exception = (JsonObject)jo.getMap("exception");
                    row.exchangeId = row.message.getString("exchangeId");
                    row.exchangePattern = row.message.getString("exchangePattern");
                    row.message.remove((Object)"exchangeId");
                    row.message.remove((Object)"exchangePattern");
                    if (!this.showExchangeVariables) {
                        row.message.remove((Object)"exchangeVariables");
                    }
                    if (!this.showExchangeProperties) {
                        row.message.remove((Object)"exchangeProperties");
                    }
                    if (!this.showHeaders) {
                        row.message.remove((Object)"headers");
                    }
                    if (!this.showBody) {
                        row.message.remove((Object)"body");
                    }
                    if (!this.showException) {
                        row.exception = null;
                    }
                    rows.add(row);
                }
            }
            return rows;
        }
        return null;
    }

    private boolean dumpTraceFiles(Map<Long, Pid> pids, int tail, Date limit) {
        int pos;
        HashSet<String> names = new HashSet<String>();
        List<Row> rows = new ArrayList();
        for (Pid pid : pids.values()) {
            Queue<String> queue = pid.fifo;
            if (queue == null) continue;
            for (String l : queue) {
                names.add(pid.name);
                List<Row> parsed = this.parseTraceLine(pid, l);
                if (parsed == null || parsed.isEmpty()) continue;
                rows.addAll(parsed);
            }
            pid.fifo.clear();
        }
        if (names.size() > 1) {
            HashMap lastTimestamp = new HashMap();
            rows.sort((r1, r2) -> {
                long t1 = r1.timestamp;
                long t2 = r2.timestamp;
                if (t1 == 0L) {
                    t1 = (Long)lastTimestamp.get(r1.name);
                }
                if (t1 == 0L) {
                    t1 = (Long)lastTimestamp.get(r2.name);
                }
                if (t1 == 0L && t2 == 0L) {
                    return 0;
                }
                if (t1 == 0L) {
                    return -1;
                }
                if (t2 == 0L) {
                    return 1;
                }
                lastTimestamp.put(r1.name, t1);
                lastTimestamp.put(r2.name, t2);
                return Long.compare(t1, t2);
            });
        }
        if (tail > 0 && (pos = rows.size() - tail) > 0) {
            rows = rows.subList(pos, rows.size());
        }
        int doneTraces = 0;
        for (Row r : rows) {
            this.printTrace(r.name, pids.size(), r, limit);
            if (!r.done) continue;
            ++doneTraces;
        }
        if (this.latest) {
            return doneTraces == 0;
        }
        return true;
    }

    private boolean isValidGrep(String line) {
        if (this.grep == null) {
            return true;
        }
        for (String g : this.grep) {
            boolean m = Pattern.compile("(?i)" + g).matcher(line).find();
            if (!m) continue;
            return true;
        }
        return false;
    }

    private boolean isValidSince(Date limit, long timestamp) {
        if (limit == null || timestamp == 0L) {
            return true;
        }
        Date row = new Date(timestamp);
        return row.compareTo(limit) >= 0;
    }

    protected void printTrace(String name, int pids, Row row, Date limit) {
        String[] lines;
        boolean valid;
        if (!this.prefixShown && ("false".equals(this.prefix) || "auto".equals(this.prefix) && pids <= 1)) {
            name = null;
        }
        boolean bl = this.prefixShown = name != null;
        if (row.first) {
            ++row.parent.depth;
        } else if (row.last) {
            --row.parent.depth;
        }
        String data = this.getDataAsTable(row);
        boolean bl2 = valid = this.filterDepth(row) && this.isValidSince(limit, row.timestamp) && this.isValidGrep(data);
        if (!valid) {
            return;
        }
        Object nameWithPrefix = null;
        if (name != null) {
            if (this.loggingColor) {
                Ansi.Color color = this.nameColors.get(name);
                if (color == null) {
                    int idx = this.nameColors.size() % 6 + 1;
                    color = Ansi.Color.values()[idx];
                    this.nameColors.put(name, color);
                }
                String n = String.format("%-" + this.nameMaxWidth + "s", name);
                nameWithPrefix = Ansi.ansi().fg(color).a(n).a("| ").reset().toString();
            } else {
                nameWithPrefix = String.format("%-" + this.nameMaxWidth + "s", name) + "| ";
            }
            this.printer().print((String)nameWithPrefix);
        }
        if (this.timestamp) {
            String ts;
            if (this.ago) {
                ts = String.format("%12s", TimeUtils.printSince((long)row.timestamp) + " ago");
            } else {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
                ts = sdf.format(new Date(row.timestamp));
            }
            if (this.loggingColor) {
                AnsiConsole.out().print((Object)Ansi.ansi().fgBrightDefault().a(Ansi.Attribute.INTENSITY_FAINT).a(ts).reset());
            } else {
                this.printer().print(ts);
            }
            this.printer().print("  ");
        }
        String p = String.format("%5.5s", row.pid);
        if (this.loggingColor) {
            AnsiConsole.out().print((Object)Ansi.ansi().fgMagenta().a(p).reset());
            AnsiConsole.out().print((Object)Ansi.ansi().fgBrightDefault().a(Ansi.Attribute.INTENSITY_FAINT).a(" --- ").reset());
        } else {
            this.printer().print(p);
            this.printer().print(" --- ");
        }
        String tn = row.threadName;
        if (tn.length() > 25) {
            tn = tn.substring(tn.length() - 25);
        }
        tn = String.format("[%25.25s]", tn);
        if (this.loggingColor) {
            AnsiConsole.out().print((Object)Ansi.ansi().fgBrightDefault().a(Ansi.Attribute.INTENSITY_FAINT).a(tn).reset());
        } else {
            this.printer().print(tn);
        }
        this.printer().print(" ");
        Object ids = this.source ? row.location : row.routeId + "/" + this.getId(row);
        if (((String)ids).length() > 40) {
            ids = ((String)ids).substring(((String)ids).length() - 40);
        }
        ids = String.format("%40.40s", ids);
        if (this.loggingColor) {
            AnsiConsole.out().print((Object)Ansi.ansi().fgCyan().a((String)ids).reset());
        } else {
            this.printer().print((String)ids);
        }
        this.printer().print(" : ");
        String u = String.format("%5.5s", row.uid);
        if (this.loggingColor) {
            AnsiConsole.out().print((Object)Ansi.ansi().fgMagenta().a(u).reset());
        } else {
            this.printer().print(u);
        }
        this.printer().print(" - ");
        this.printer().print(this.getStatus(row));
        String e = this.getElapsed(row);
        if (e != null) {
            if (this.loggingColor) {
                AnsiConsole.out().print((Object)Ansi.ansi().fgBrightDefault().a(" (" + e + ")").reset());
            } else {
                this.printer().print("(" + e + ")");
            }
        }
        if ((lines = data.split(System.lineSeparator())).length > 0) {
            this.printer().println();
            for (String line : lines) {
                if (this.find != null) {
                    for (String f : this.find) {
                        line = line.replaceAll("(?i)" + f, this.findAnsi);
                    }
                }
                if (this.grep != null) {
                    for (String g : this.grep) {
                        line = line.replaceAll("(?i)" + g, this.findAnsi);
                    }
                }
                if (nameWithPrefix != null) {
                    this.printer().print((String)nameWithPrefix);
                }
                this.printer().print(" ");
                this.printer().println(line);
            }
            if (!this.compact) {
                if (nameWithPrefix != null) {
                    this.printer().println((String)nameWithPrefix);
                } else {
                    this.printer().println();
                }
            }
        }
        if (row.parent.depth <= 0 && row.last) {
            this.exchangeIdColors.remove(row.exchangeId);
        }
    }

    private boolean filterDepth(Row row) {
        if (this.depth >= 9) {
            return true;
        }
        if (this.depth == 0) {
            return row.parent.depth == 1 && row.first || row.parent.depth == 0 && row.last;
        }
        return row.parent.depth <= this.depth;
    }

    private String getDataAsTable(Row r) {
        return this.tableHelper.getDataAsTable(r.exchangeId, r.exchangePattern, r.endpoint, r.endpointService, r.message, r.exception);
    }

    private String getElapsed(Row r) {
        if (!r.first) {
            return TimeUtils.printDuration((long)r.elapsed, (boolean)true);
        }
        return null;
    }

    private String getStatus(Row r) {
        String s;
        boolean remote;
        boolean bl = remote = r.endpoint != null && r.endpoint.getBooleanOrDefault("remote", false) != false;
        if (r.first) {
            String s2;
            String string = s2 = r.parent.depth == 1 ? "Created" : "Routing to " + r.routeId;
            if (this.loggingColor) {
                return Ansi.ansi().fg(Ansi.Color.GREEN).a(s2).reset().toString();
            }
            return s2;
        }
        if (r.last) {
            String s3;
            String done = r.exception != null ? "Completed (exception)" : "Completed (success)";
            String string = s3 = r.parent.depth == 0 ? done : "Returning from " + r.routeId;
            if (this.loggingColor) {
                return Ansi.ansi().fg(r.failed ? Ansi.Color.RED : Ansi.Color.GREEN).a(s3).reset().toString();
            }
            return s3;
        }
        if (!r.done) {
            String s4;
            String string = s4 = remote ? "Sending" : "Processing";
            if (this.loggingColor) {
                return Ansi.ansi().fg(Ansi.Color.BLUE).a(s4).reset().toString();
            }
            return s4;
        }
        if (r.failed) {
            String fail;
            String string = fail = r.exception != null ? "Exception" : "Failed";
            if (this.loggingColor) {
                return Ansi.ansi().fg(Ansi.Color.RED).a(fail).reset().toString();
            }
            return fail;
        }
        String string = s = remote ? "Sent" : "Processed";
        if (this.loggingColor) {
            return Ansi.ansi().fg(Ansi.Color.GREEN).a(s).reset().toString();
        }
        return s;
    }

    private String getId(Row r) {
        if (r.first) {
            return "*-->";
        }
        if (r.last) {
            return "*<--";
        }
        return r.nodeId;
    }

    private static class StatusRow {
        String pid;
        String name;
        String age;
        long uptime;
        boolean enabled;
        boolean standby;
        long counter;
        long queueSize;
        String filter;
        String pattern;

        private StatusRow() {
        }
    }

    private static class Pid {
        String pid;
        String name;
        Queue<String> fifo;
        int depth;
        LineNumberReader reader;

        private Pid() {
        }
    }

    private static class Row {
        Pid parent;
        String pid;
        String name;
        boolean first;
        boolean last;
        long uid;
        String exchangeId;
        String exchangePattern;
        String threadName;
        String location;
        String routeId;
        String nodeId;
        long timestamp;
        long elapsed;
        boolean done;
        boolean failed;
        JsonObject endpoint;
        JsonObject endpointService;
        JsonObject message;
        JsonObject exception;

        Row(Pid parent) {
            this.parent = parent;
        }
    }

    public static class ActionCompletionCandidates
    implements Iterable<String> {
        @Override
        public Iterator<String> iterator() {
            return List.of("dump", "start", "stop", "status", "clear").iterator();
        }
    }

    public static class PrefixCompletionCandidates
    implements Iterable<String> {
        @Override
        public Iterator<String> iterator() {
            return List.of("auto", "true", "false").iterator();
        }
    }
}

