/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.jbang.core.commands.action;

import com.github.freva.asciitable.AsciiTable;
import com.github.freva.asciitable.Column;
import com.github.freva.asciitable.HorizontalAlign;
import com.github.freva.asciitable.OverflowBehaviour;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.camel.dsl.jbang.core.commands.CamelJBangMain;
import org.apache.camel.dsl.jbang.core.commands.action.ActionWatchCommand;
import org.apache.camel.dsl.jbang.core.commands.action.MessageTableHelper;
import org.apache.camel.dsl.jbang.core.common.PathUtils;
import org.apache.camel.support.PatternHelper;
import org.apache.camel.util.URISupport;
import org.apache.camel.util.json.JsonArray;
import org.apache.camel.util.json.JsonObject;
import org.fusesource.jansi.Ansi;
import picocli.CommandLine;

@CommandLine.Command(name="stub", description={"Browse stub endpoints"}, sortOptions=false, showDefaultValues=true)
public class CamelStubAction
extends ActionWatchCommand {
    @CommandLine.Parameters(description={"Name or pid of running Camel integration"}, arity="0..1")
    String name = "*";
    @CommandLine.Option(names={"--sort"}, description={"Sort by name, or total"}, defaultValue="name")
    String sort;
    @CommandLine.Option(names={"--filter"}, description={"Filter endpoints by queue name"})
    String filter;
    @CommandLine.Option(names={"--browse"}, description={"Whether to browse messages queued in the stub endpoints"})
    boolean browse;
    @CommandLine.Option(names={"--top"}, defaultValue="true", description={"Whether to browse top (latest) messages queued in the stub endpoints"})
    boolean top = true;
    @CommandLine.Option(names={"--limit"}, defaultValue="10", description={"Filter browsing queues by limiting to the given latest number of messages"})
    int limit = 10;
    @CommandLine.Option(names={"--find"}, description={"Find and highlight matching text (ignore case)."}, arity="0..*")
    String[] find;
    @CommandLine.Option(names={"--grep"}, description={"Filter browsing messages to only output trace matching text (ignore case)."}, arity="0..*")
    String[] grep;
    @CommandLine.Option(names={"--show-headers"}, defaultValue="true", description={"Show message headers in traced messages"})
    boolean showHeaders = true;
    @CommandLine.Option(names={"--show-body"}, defaultValue="true", description={"Show message body in traced messages"})
    boolean showBody = true;
    @CommandLine.Option(names={"--compact"}, defaultValue="true", description={"Compact output (no empty line separating browsed messages)"})
    boolean compact = true;
    @CommandLine.Option(names={"--mask"}, description={"Whether to mask endpoint URIs to avoid printing sensitive information such as password or access keys"})
    boolean mask;
    @CommandLine.Option(names={"--pretty"}, description={"Pretty print message body when using JSon or XML format"})
    boolean pretty;
    @CommandLine.Option(names={"--logging-color"}, defaultValue="true", description={"Use colored logging"})
    boolean loggingColor = true;
    private volatile long pid;
    String findAnsi;
    private MessageTableHelper tableHelper;
    private final Map<String, Ansi.Color> exchangeIdColors = new HashMap<String, Ansi.Color>();
    private int exchangeIdColorsIndex = 1;

    public CamelStubAction(CamelJBangMain main) {
        super(main);
    }

    @Override
    protected Integer doWatchCall() throws Exception {
        this.tableHelper = new MessageTableHelper();
        this.tableHelper.setPretty(this.pretty);
        this.tableHelper.setLoggingColor(this.loggingColor);
        this.tableHelper.setExchangeIdColorChooser(value -> {
            Ansi.Color color = this.exchangeIdColors.get(value);
            if (color == null) {
                ++this.exchangeIdColorsIndex;
                if (this.exchangeIdColorsIndex > 6) {
                    this.exchangeIdColorsIndex = 2;
                }
                color = Ansi.Color.values()[this.exchangeIdColorsIndex];
                this.exchangeIdColors.put(value, color);
            }
            return color;
        });
        if (this.find != null || this.grep != null) {
            this.findAnsi = Ansi.ansi().fg(Ansi.Color.BLACK).bg(Ansi.Color.YELLOW).a("$0").reset().toString();
        }
        ArrayList<Row> rows = new ArrayList<Row>();
        List<Long> pids = this.findPids(this.name);
        if (pids.isEmpty()) {
            return 0;
        }
        if (pids.size() > 1) {
            this.printer().println("Name or pid " + this.name + " matches " + pids.size() + " running Camel integrations. Specify a name or PID that matches exactly one.");
            return 0;
        }
        this.pid = pids.get(0);
        if (this.filter == null) {
            this.filter = "*";
        }
        Path outputFile = this.getOutputFile(Long.toString(this.pid));
        PathUtils.deleteFile(outputFile);
        JsonObject root = new JsonObject();
        root.put((Object)"action", (Object)"stub");
        root.put((Object)"format", (Object)"json");
        root.put((Object)"browse", (Object)this.browse);
        root.put((Object)"filter", (Object)"*");
        root.put((Object)"limit", (Object)this.limit);
        Path file = this.getActionFile(Long.toString(this.pid));
        try {
            Files.writeString(file, (CharSequence)root.toJson(), new OpenOption[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        JsonObject jo = this.waitForOutputFile(outputFile);
        if (jo != null) {
            JsonArray arr;
            JsonObject me = this.loadStatus(this.pid);
            if (me != null) {
                me = (JsonObject)me.get((Object)"context");
            }
            if ((arr = (JsonArray)jo.get((Object)"queues")) != null) {
                for (int i = 0; i < arr.size(); ++i) {
                    JsonObject o = (JsonObject)arr.get(i);
                    Row row = new Row();
                    row.pid = this.pid;
                    row.name = me != null ? me.getString("name") : null;
                    row.queue = o.getString("name");
                    row.max = o.getInteger("max");
                    row.size = o.getInteger("size");
                    String uri = o.getString("endpointUri");
                    if (uri != null) {
                        row.endpoint = new JsonObject();
                        if (this.mask) {
                            uri = URISupport.sanitizeUri((String)uri);
                        }
                        row.endpoint.put((Object)"endpoint", (Object)uri);
                    }
                    row.messages = (List)o.getCollection("messages");
                    boolean add = true;
                    if (this.filter != null) {
                        Object f = this.filter;
                        boolean negate = this.filter.startsWith("-");
                        if (negate) {
                            f = ((String)f).substring(1);
                        }
                        if (!((String)f).endsWith("*")) {
                            f = (String)f + "*";
                        }
                        boolean match = PatternHelper.matchPattern((String)row.queue, (String)f);
                        if (negate) {
                            boolean bl = match = !match;
                        }
                        if (!match) {
                            add = false;
                        }
                    }
                    if (!add) continue;
                    rows.add(row);
                }
            }
        } else {
            this.printer().println("Response from running Camel with PID " + this.pid + " not received within 5 seconds");
            return 1;
        }
        rows.sort(this::sortRow);
        if (this.watch) {
            this.clearScreen();
        }
        if (!rows.isEmpty()) {
            this.printStub(rows);
        }
        PathUtils.deleteFile(outputFile);
        return 0;
    }

    protected int sortRow(Row o1, Row o2) {
        String s = this.sort;
        int negate = 1;
        if (s.startsWith("-")) {
            s = s.substring(1);
            negate = -1;
        }
        switch (s) {
            case "name": {
                return o1.name.compareToIgnoreCase(o2.name) * negate;
            }
            case "total": {
                return Integer.compare(o1.size, o2.size) * negate;
            }
        }
        return 0;
    }

    private boolean isValidGrep(String line) {
        if (this.grep == null) {
            return true;
        }
        for (String g : this.grep) {
            boolean m = Pattern.compile("(?i)" + g).matcher(line).find();
            if (!m) continue;
            return true;
        }
        return false;
    }

    protected void printStub(List<Row> rows) {
        if (this.browse) {
            for (Row row : rows) {
                this.printer().println(AsciiTable.getTable((Character[])AsciiTable.NO_BORDERS, List.of(row), Arrays.asList(new Column().header("PID").headerAlign(HorizontalAlign.CENTER).with(r -> Long.toString(r.pid)), new Column().header("NAME").dataAlign(HorizontalAlign.LEFT).maxWidth(30, OverflowBehaviour.ELLIPSIS_RIGHT).with(r -> r.name), new Column().header("QUEUE").dataAlign(HorizontalAlign.LEFT).with(r -> r.queue), new Column().header("MAX").dataAlign(HorizontalAlign.RIGHT).with(r -> Integer.toString(r.max)), new Column().header("TOTAL").dataAlign(HorizontalAlign.RIGHT).with(r -> Integer.toString(r.size)))));
                if (row.messages == null) continue;
                List<JsonObject> list = row.messages;
                if (this.top) {
                    Collections.reverse(list);
                }
                boolean first = true;
                for (JsonObject jo : list) {
                    boolean valid;
                    String[] lines;
                    String data;
                    JsonObject root = (JsonObject)jo.get((Object)"message");
                    if (!this.showHeaders) {
                        root.remove((Object)"headers");
                    }
                    if (!this.showBody) {
                        root.remove((Object)"body");
                    }
                    if ((data = this.tableHelper.getDataAsTable(root.getString("exchangeId"), root.getString("exchangePattern"), row.endpoint, null, root, null)) == null || (lines = data.split(System.lineSeparator())).length <= 0 || !(valid = this.isValidGrep(data))) continue;
                    if (!this.compact && first) {
                        this.printer().println();
                    }
                    for (String line : lines) {
                        if (this.find != null) {
                            for (String f : this.find) {
                                line = line.replaceAll("(?i)" + f, this.findAnsi);
                            }
                        }
                        if (this.grep != null) {
                            for (String g : this.grep) {
                                line = line.replaceAll("(?i)" + g, this.findAnsi);
                            }
                        }
                        this.printer().print(" ");
                        this.printer().println(line);
                    }
                    if (!this.compact) {
                        this.printer().println();
                    }
                    first = false;
                }
            }
        } else {
            this.printer().println(AsciiTable.getTable((Character[])AsciiTable.NO_BORDERS, rows, Arrays.asList(new Column().header("PID").headerAlign(HorizontalAlign.CENTER).with(r -> Long.toString(r.pid)), new Column().header("NAME").dataAlign(HorizontalAlign.LEFT).maxWidth(30, OverflowBehaviour.ELLIPSIS_RIGHT).with(r -> r.name), new Column().header("QUEUE").dataAlign(HorizontalAlign.LEFT).with(r -> r.queue), new Column().header("MAX").dataAlign(HorizontalAlign.RIGHT).with(r -> Integer.toString(r.max)), new Column().header("TOTAL").dataAlign(HorizontalAlign.RIGHT).with(r -> Integer.toString(r.size)))));
        }
    }

    protected JsonObject waitForOutputFile(Path outputFile) {
        return CamelStubAction.getJsonObject(outputFile);
    }

    private static class Row {
        long pid;
        String name;
        String queue;
        int max;
        int size;
        JsonObject endpoint;
        List<JsonObject> messages;

        private Row() {
        }
    }
}

