/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.jbang.core.commands.action;

import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import org.apache.camel.dsl.jbang.core.commands.CamelJBangMain;
import org.apache.camel.dsl.jbang.core.commands.action.ActionBaseCommand;
import org.apache.camel.util.json.JsonObject;
import picocli.CommandLine;

@CommandLine.Command(name="reload", description={"Trigger reloading Camel"}, sortOptions=false, showDefaultValues=true)
public class CamelReloadAction
extends ActionBaseCommand {
    @CommandLine.Parameters(description={"Name or pid of running Camel integration. (default selects all)"}, arity="0..1")
    String name = "*";

    public CamelReloadAction(CamelJBangMain main) {
        super(main);
    }

    @Override
    public Integer doCall() throws Exception {
        List<Long> pids = this.findPids(this.name);
        for (long pid : pids) {
            JsonObject root = new JsonObject();
            root.put((Object)"action", (Object)"reload");
            Path f = this.getActionFile(Long.toString(pid));
            Files.writeString(f, (CharSequence)root.toJson(), new OpenOption[0]);
        }
        return 0;
    }
}

