/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.jbang.core.commands.action;

import java.io.IOException;
import java.io.LineNumberReader;
import java.lang.invoke.CallSite;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import org.apache.camel.catalog.impl.TimePatternConverter;
import org.apache.camel.dsl.jbang.core.commands.CamelJBangMain;
import org.apache.camel.dsl.jbang.core.commands.CommandHelper;
import org.apache.camel.dsl.jbang.core.commands.action.ActionBaseCommand;
import org.apache.camel.dsl.jbang.core.common.CommandLineHelper;
import org.apache.camel.dsl.jbang.core.common.ProcessHelper;
import org.apache.camel.util.StopWatch;
import org.apache.camel.util.StringHelper;
import org.apache.camel.util.json.JsonObject;
import org.fusesource.jansi.Ansi;
import org.fusesource.jansi.AnsiConsole;
import picocli.CommandLine;

@CommandLine.Command(name="log", description={"Tail logs from running Camel integrations"}, sortOptions=false, showDefaultValues=true)
public class CamelLogAction
extends ActionBaseCommand {
    private static final int NAME_MAX_WIDTH = 25;
    private static final int NAME_MIN_WIDTH = 10;
    private static final String TIMESTAMP_MAIN = "yyyy-MM-dd HH:mm:ss.SSS";
    private static final String TIMESTAMP_SB = "yyyy-MM-dd'T'HH:mm:ss.SSSXXX";
    private CommandHelper.ReadConsoleTask waitUserTask;
    @CommandLine.Parameters(description={"Name or pid of running Camel integration. (default selects all)"}, arity="0..1")
    String name = "*";
    @CommandLine.Option(names={"--logging-color"}, defaultValue="true", description={"Use colored logging"})
    boolean loggingColor = true;
    @CommandLine.Option(names={"--timestamp"}, defaultValue="true", description={"Print timestamp."})
    boolean timestamp = true;
    @CommandLine.Option(names={"--follow"}, defaultValue="true", description={"Keep following and outputting new log lines (press enter to exit)."})
    boolean follow = true;
    @CommandLine.Option(names={"--startup"}, defaultValue="false", description={"Only shows logs from the starting phase to make it quick to look at how Camel was started."})
    boolean startup;
    @CommandLine.Option(names={"--prefix"}, defaultValue="auto", completionCandidates=PrefixCompletionCandidates.class, description={"Print prefix with running Camel integration name. auto=only prefix when running multiple integrations. true=always prefix. false=prefix off."})
    String prefix = "auto";
    @CommandLine.Option(names={"--tail"}, defaultValue="-1", description={"The number of lines from the end of the logs to show. Use -1 to read from the beginning. Use 0 to read only new lines. Defaults to showing all logs from beginning."})
    int tail = -1;
    @CommandLine.Option(names={"--since"}, description={"Return logs newer than a relative duration like 5s, 2m, or 1h. The value is in seconds if no unit specified."})
    String since;
    @CommandLine.Option(names={"--find"}, description={"Find and highlight matching text (ignore case)."}, arity="0..*")
    String[] find;
    @CommandLine.Option(names={"--grep"}, description={"Filter logs to only output lines matching text (ignore case)."}, arity="0..*")
    String[] grep;
    String findAnsi;
    private int nameMaxWidth;
    private boolean prefixShown;
    private final Map<String, Ansi.Color> colors = new HashMap<String, Ansi.Color>();

    public CamelLogAction(CamelJBangMain main) {
        super(main);
    }

    @Override
    public Integer doCall() throws Exception {
        LinkedHashMap<Long, Row> rows = new LinkedHashMap<Long, Row>();
        this.updatePids(rows);
        if (!rows.isEmpty()) {
            String f;
            int i;
            if (this.find != null) {
                this.findAnsi = Ansi.ansi().fg(Ansi.Color.BLACK).bg(Ansi.Color.YELLOW).a("$0").reset().toString();
                for (i = 0; i < this.find.length; ++i) {
                    f = this.find[i];
                    this.find[i] = f = Pattern.quote(f);
                }
            }
            if (this.grep != null) {
                this.findAnsi = Ansi.ansi().fg(Ansi.Color.BLACK).bg(Ansi.Color.YELLOW).a("$0").reset().toString();
                for (i = 0; i < this.grep.length; ++i) {
                    f = this.grep[i];
                    this.grep[i] = f = Pattern.quote(f);
                }
            }
            Date limit = null;
            if (this.since != null) {
                long millis = StringHelper.isDigit((String)this.since) ? TimePatternConverter.toMilliSeconds((String)this.since) * 1000L : TimePatternConverter.toMilliSeconds((String)this.since);
                limit = new Date(System.currentTimeMillis() - millis);
            }
            if (this.startup) {
                this.follow = false;
                this.tailStartupLogFiles(rows);
                this.dumpLogFiles(rows, 0);
            } else if (this.tail != 0) {
                this.tailLogFiles(rows, this.tail, limit);
                this.dumpLogFiles(rows, this.tail);
            }
        }
        if (this.follow) {
            boolean waitMessage = true;
            AtomicBoolean running = new AtomicBoolean(true);
            Thread t = new Thread(() -> {
                this.waitUserTask = new CommandHelper.ReadConsoleTask(() -> running.set(false));
                this.waitUserTask.run();
            }, "WaitForUser");
            t.start();
            StopWatch watch = new StopWatch();
            do {
                int lines;
                if (rows.isEmpty()) {
                    if (waitMessage) {
                        this.printer().println("Waiting for logs ...");
                        waitMessage = false;
                    }
                    Thread.sleep(500L);
                    this.updatePids(rows);
                    continue;
                }
                waitMessage = true;
                if (watch.taken() > 500L) {
                    this.updatePids(rows);
                    watch.restart();
                }
                if ((lines = this.readLogFiles(rows)) > 0) {
                    this.dumpLogFiles(rows, 0);
                    continue;
                }
                Thread.sleep(100L);
            } while (running.get());
        }
        return 0;
    }

    private void updatePids(Map<Long, Row> rows) {
        List<Long> pids = this.findPids(this.name);
        ProcessHandle.allProcesses().filter(ph -> pids.contains(ph.pid())).forEach(ph -> {
            JsonObject root = this.loadStatus(ph.pid());
            if (root != null) {
                int len;
                Row row = new Row();
                row.pid = Long.toString(ph.pid());
                JsonObject context = (JsonObject)root.get((Object)"context");
                if (context == null) {
                    return;
                }
                row.name = context.getString("name");
                if ("CamelJBang".equals(row.name)) {
                    row.name = ProcessHelper.extractName(root, ph);
                }
                if ((len = row.name.length()) < 10) {
                    len = 10;
                }
                if (len > 25) {
                    len = 25;
                }
                if (len > this.nameMaxWidth) {
                    this.nameMaxWidth = len;
                }
                if (!rows.containsKey(ph.pid())) {
                    rows.put(ph.pid(), row);
                }
            }
        });
        HashSet<Long> remove = new HashSet<Long>();
        for (long pid : rows.keySet()) {
            if (pids.contains(pid)) continue;
            remove.add(pid);
        }
        for (long pid : remove) {
            rows.remove(pid);
        }
    }

    private int readLogFiles(Map<Long, Row> rows) throws Exception {
        int lines = 0;
        for (Row row : rows.values()) {
            String line;
            Path file;
            if (row.reader == null && Files.exists(file = CamelLogAction.logFile(row.pid), new LinkOption[0])) {
                row.reader = new LineNumberReader(Files.newBufferedReader(file));
                if (this.tail == 0) {
                    long size = Files.size(file);
                    row.reader.skip(size);
                }
            }
            if (row.reader == null) continue;
            do {
                try {
                    line = row.reader.readLine();
                    if (line == null) continue;
                    line = this.alignTimestamp(line);
                    boolean valid = true;
                    if (this.grep != null) {
                        valid = this.isValidGrep(line);
                    }
                    if (!valid) continue;
                    ++lines;
                    if (row.fifo == null || row.fifo instanceof ArrayBlockingQueue) {
                        row.fifo = new ArrayDeque<String>();
                    }
                    row.fifo.offer(line);
                }
                catch (IOException e) {
                    line = null;
                }
            } while (line != null);
        }
        return lines;
    }

    private void dumpLogFiles(Map<Long, Row> rows, int tail) {
        int pos;
        HashSet<String> names = new HashSet<String>();
        List<CallSite> lines = new ArrayList();
        for (Row row : rows.values()) {
            Queue<String> queue = row.fifo;
            if (queue == null) continue;
            for (String l3 : queue) {
                names.add(row.name);
                lines.add((CallSite)((Object)(row.name + "| " + l3)));
            }
            row.fifo.clear();
        }
        if (names.size() > 1) {
            SimpleDateFormat sdf = new SimpleDateFormat(TIMESTAMP_MAIN);
            lines.sort((l1, l2) -> {
                l1 = this.unescapeAnsi((String)l1);
                l2 = this.unescapeAnsi((String)l2);
                String n1 = StringHelper.before((String)l1, (String)"| ");
                String t1 = StringHelper.after((String)l1, (String)"| ");
                t1 = StringHelper.before((String)t1, (String)"  ");
                String n2 = StringHelper.before((String)l2, (String)"| ");
                String t2 = StringHelper.after((String)l2, (String)"| ");
                t2 = StringHelper.before((String)t2, (String)"  ");
                if (t1 != null) {
                    try {
                        sdf.parse(t1);
                    }
                    catch (ParseException e) {
                        t1 = null;
                    }
                }
                if (t2 != null) {
                    try {
                        sdf.parse(t2);
                    }
                    catch (ParseException e) {
                        t2 = null;
                    }
                }
                if (t1 == null && t2 == null) {
                    return 0;
                }
                if (t1 == null) {
                    return -1;
                }
                if (t2 == null) {
                    return 1;
                }
                return t1.compareTo(t2);
            });
        }
        if (tail > 0 && (pos = lines.size() - tail) > 0) {
            lines = lines.subList(pos, lines.size());
        }
        lines.forEach(l -> {
            String name = StringHelper.before((String)l, (String)"| ");
            String line = StringHelper.after((String)l, (String)"| ");
            this.printLine(name, rows.size(), line);
        });
    }

    protected void printLine(String name, int pids, String line) {
        if (!this.prefixShown && ("false".equals(this.prefix) || "auto".equals(this.prefix) && pids <= 1)) {
            name = null;
        }
        boolean bl = this.prefixShown = name != null;
        if (!this.timestamp) {
            int pos = line.indexOf(32);
            if ((pos = line.indexOf(32, pos + 1)) != -1) {
                line = line.substring(pos + 1);
            }
        }
        if (this.loggingColor) {
            if (name != null) {
                Ansi.Color color = this.colors.get(name);
                if (color == null) {
                    int idx = this.colors.size() % 6 + 1;
                    color = Ansi.Color.values()[idx];
                    this.colors.put(name, color);
                }
                String n = String.format("%-" + this.nameMaxWidth + "s", name);
                AnsiConsole.out().print((Object)Ansi.ansi().fg(color).a(n).a("| ").reset());
            }
        } else {
            line = this.unescapeAnsi(line);
            if (name != null) {
                String n = String.format("%-" + this.nameMaxWidth + "s", name);
                this.printer().print(n);
                this.printer().print("| ");
            }
        }
        if (this.find != null || this.grep != null) {
            boolean dashes = line.contains(" --- ");
            String before = null;
            String after = line;
            if (dashes) {
                before = StringHelper.before((String)line, (String)"---");
                after = StringHelper.after((String)line, (String)"---", (String)line);
            }
            if (this.find != null) {
                for (String f : this.find) {
                    after = after.replaceAll("(?i)" + f, this.findAnsi);
                }
            }
            if (this.grep != null) {
                for (String g : this.grep) {
                    after = after.replaceAll("(?i)" + g, this.findAnsi);
                }
            }
            String string = line = before != null ? before + "---" + after : after;
        }
        if (this.loggingColor) {
            AnsiConsole.out().println(line);
        } else {
            this.printer().println(line);
        }
    }

    private static Path logFile(String pid) {
        String name = pid + ".log";
        Path parent = CommandLineHelper.getCamelDir();
        return parent.resolve(name);
    }

    private void tailStartupLogFiles(Map<Long, Row> rows) throws Exception {
        for (Row row : rows.values()) {
            String line;
            Path log = CamelLogAction.logFile(row.pid);
            if (!Files.exists(log, new LinkOption[0])) continue;
            row.fifo = new ArrayDeque<String>();
            row.reader = new LineNumberReader(Files.newBufferedReader(log));
            do {
                boolean found;
                if ((line = row.reader.readLine()) == null) continue;
                row.fifo.offer(line);
                boolean bl = found = line.contains("AbstractCamelContext") && line.contains("Apache Camel ") && line.contains(" started in ") && line.contains("(build:");
                if (!found) continue;
                line = null;
            } while (line != null);
        }
    }

    private void tailLogFiles(Map<Long, Row> rows, int tail, Date limit) throws Exception {
        for (Row row : rows.values()) {
            String line;
            Path log = CamelLogAction.logFile(row.pid);
            if (!Files.exists(log, new LinkOption[0])) continue;
            row.reader = new LineNumberReader(Files.newBufferedReader(log));
            row.fifo = tail <= 0 ? new ArrayDeque<String>() : new ArrayBlockingQueue<String>(tail);
            do {
                if ((line = row.reader.readLine()) == null) continue;
                boolean valid = this.isValidSince(limit, line = this.alignTimestamp(line));
                if (valid && this.grep != null) {
                    valid = this.isValidGrep(line);
                }
                if (!valid) continue;
                while (!row.fifo.offer(line)) {
                    row.fifo.poll();
                }
            } while (line != null);
        }
    }

    private String alignTimestamp(String line) {
        Object ts = StringHelper.before((String)line, (String)"  ");
        if (ts != null && ((String)ts).contains("T")) {
            SimpleDateFormat sdf = new SimpleDateFormat(TIMESTAMP_SB);
            try {
                sdf.parse(this.unescapeAnsi((String)ts));
                int dot = ((String)ts).indexOf(46);
                if (dot != -1) {
                    int pos1 = dot + 3;
                    int pos2 = dot + 9;
                    if (pos2 < ((String)ts).length()) {
                        ts = ((String)ts).substring(0, pos1) + ((String)ts).substring(pos2);
                        String after = StringHelper.after((String)line, (String)"  ");
                        ts = ((String)ts).replace('T', ' ');
                        return (String)ts + "  " + after;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return line;
    }

    private boolean isValidSince(Date limit, String line) {
        if (limit == null) {
            return true;
        }
        String ts = StringHelper.before((String)(line = this.unescapeAnsi(line)), (String)"  ");
        if (ts != null && !ts.isBlank()) {
            SimpleDateFormat sdf = new SimpleDateFormat(TIMESTAMP_MAIN);
            try {
                Date row = sdf.parse(ts);
                return row.compareTo(limit) >= 0;
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return false;
    }

    private boolean isValidGrep(String line) {
        if (this.grep == null) {
            return true;
        }
        line = this.unescapeAnsi(line);
        String after = StringHelper.after((String)line, (String)"---", (String)line);
        for (String g : this.grep) {
            boolean m = Pattern.compile("(?i)" + g).matcher(after).find();
            if (!m) continue;
            return true;
        }
        return false;
    }

    private String unescapeAnsi(String line) {
        StringBuilder sb = new StringBuilder();
        boolean escaping = false;
        char[] arr = line.toCharArray();
        for (int i = 0; i < arr.length; ++i) {
            char ch2;
            char ch = arr[i];
            if (escaping) {
                if (ch != 'm') continue;
                escaping = false;
                continue;
            }
            char c = ch2 = i < arr.length - 1 ? arr[i + 1] : (char)'\u0000';
            if (ch == '\u001b' && ch2 == '[') {
                escaping = true;
                continue;
            }
            sb.append(ch);
        }
        return sb.toString();
    }

    private static class Row {
        String pid;
        String name;
        Queue<String> fifo;
        LineNumberReader reader;

        private Row() {
        }
    }

    public static class PrefixCompletionCandidates
    implements Iterable<String> {
        @Override
        public Iterator<String> iterator() {
            return List.of("auto", "true", "false").iterator();
        }
    }
}

