/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.jbang.core.commands.action;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.apache.camel.dsl.jbang.core.commands.CamelCommand;
import org.apache.camel.dsl.jbang.core.commands.CamelJBangMain;
import org.apache.camel.dsl.jbang.core.common.PathUtils;
import org.apache.camel.dsl.jbang.core.common.ProcessHelper;
import org.apache.camel.support.PatternHelper;
import org.apache.camel.util.FileUtil;
import org.apache.camel.util.StopWatch;
import org.apache.camel.util.json.JsonObject;
import org.apache.camel.util.json.Jsoner;

abstract class ActionBaseCommand
extends CamelCommand {
    public ActionBaseCommand(CamelJBangMain main) {
        super(main);
    }

    protected static JsonObject getJsonObject(Path outputFile) {
        StopWatch watch = new StopWatch();
        while (watch.taken() < 5000L) {
            File f = outputFile.toFile();
            try {
                Thread.sleep(100L);
                if (!Files.exists(outputFile, new LinkOption[0]) || f.length() <= 0L) continue;
                String text = Files.readString(outputFile);
                return (JsonObject)Jsoner.deserialize((String)text);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (Exception exception) {
            }
        }
        return null;
    }

    List<Long> findPids(String name) {
        ArrayList<Long> pids = new ArrayList<Long>();
        if (((String)name).matches("\\d+")) {
            return List.of(Long.valueOf(Long.parseLong((String)name)));
        }
        if (((String)name).endsWith("!")) {
            name = ((String)name).substring(0, ((String)name).length() - 1);
        } else if (!((String)name).endsWith("*")) {
            name = (String)name + "*";
        }
        long cur = ProcessHandle.current().pid();
        Object pattern = name;
        ProcessHandle.allProcesses().filter(ph -> ph.pid() != cur).forEach(arg_0 -> this.lambda$findPids$1((String)pattern, pids, arg_0));
        return pids;
    }

    static long extractSince(ProcessHandle ph) {
        long since = 0L;
        if (ph != null && ph.info().startInstant().isPresent()) {
            since = ph.info().startInstant().get().toEpochMilli();
        }
        return since;
    }

    JsonObject loadStatus(long pid) {
        try {
            Path f = this.getStatusFile(Long.toString(pid));
            if (f != null && Files.exists(f, new LinkOption[0])) {
                String text = Files.readString(f);
                return (JsonObject)Jsoner.deserialize((String)text);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    protected Path prepareAction(String pid, String action, Consumer<JsonObject> configureAction) {
        Path outputFile = this.getOutputFile(pid);
        PathUtils.deleteFile(outputFile);
        JsonObject root = new JsonObject();
        root.put((Object)"action", (Object)action);
        if (configureAction != null) {
            configureAction.accept(root);
        }
        Path file = this.getActionFile(pid);
        PathUtils.writeTextSafely(root.toJson(), file);
        return outputFile;
    }

    private /* synthetic */ void lambda$findPids$1(String pattern, List pids, ProcessHandle ph) {
        JsonObject root = this.loadStatus(ph.pid());
        if (root != null) {
            String pName = ProcessHelper.extractName(root, ph);
            if ((pName = FileUtil.onlyName((String)pName)) != null && !pName.isEmpty() && PatternHelper.matchPattern((String)pName, (String)pattern)) {
                pids.add(ph.pid());
            } else {
                JsonObject context = (JsonObject)root.get((Object)"context");
                if (context != null) {
                    pName = context.getString("name");
                    if ("CamelJBang".equals(pName)) {
                        pName = null;
                    }
                    if (pName != null && !pName.isEmpty() && PatternHelper.matchPattern((String)pName, (String)pattern)) {
                        pids.add(ph.pid());
                    }
                }
            }
        }
    }
}

