/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.jbang.core.commands;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.apache.camel.dsl.jbang.core.commands.CamelJBangMain;
import org.apache.camel.dsl.jbang.core.commands.Export;
import org.apache.camel.dsl.jbang.core.commands.ExportCamelMain;
import org.apache.camel.dsl.jbang.core.commands.ExportQuarkus;
import org.apache.camel.dsl.jbang.core.commands.ExportSpringBoot;
import org.apache.camel.dsl.jbang.core.common.PathUtils;
import org.apache.camel.dsl.jbang.core.common.RuntimeType;
import org.apache.camel.dsl.jbang.core.common.RuntimeUtil;
import org.apache.camel.util.CamelCaseOrderedProperties;
import org.apache.camel.util.FileUtil;
import picocli.CommandLine;

@CommandLine.Command(name="sbom", description={"Generate a CycloneDX or SPDX SBOM for a specific project"}, sortOptions=false, showDefaultValues=true)
public class SBOMGenerator
extends Export {
    protected static final String EXPORT_DIR = ".camel-jbang/export";
    protected static final String CYCLONEDX_FORMAT = "cyclonedx";
    protected static final String SPDX_FORMAT = "spdx";
    protected static final String SBOM_JSON_FORMAT = "json";
    protected static final String SBOM_XML_FORMAT = "xml";
    @CommandLine.Option(names={"--output-directory"}, description={"Directory where the SBOM will be saved"}, defaultValue=".")
    protected String outputDirectory = ".";
    @CommandLine.Option(names={"--output-name"}, description={"Output name of the SBOM file"}, defaultValue="sbom")
    protected String outputName = "sbom";
    @CommandLine.Option(names={"--cyclonedx-plugin-version"}, description={"The CycloneDX Maven Plugin version"}, defaultValue="2.9.1")
    protected String cyclonedxPluginVersion = "2.9.1";
    @CommandLine.Option(names={"--spdx-plugin-version"}, description={"The SPDX Maven Plugin version"}, defaultValue="0.7.4")
    protected String spdxPluginVersion = "0.7.4";
    @CommandLine.Option(names={"--sbom-format"}, description={"The SBOM format, possible values are cyclonedx or spdx"}, defaultValue="cyclonedx")
    protected String sbomFormat = "cyclonedx";
    @CommandLine.Option(names={"--sbom-output-format"}, description={"The SBOM output format, possible values are json or xml"}, defaultValue="json")
    protected String sbomOutputFormat = "json";

    public SBOMGenerator(CamelJBangMain main) {
        super(main);
    }

    @Override
    public Integer doCall() throws Exception {
        this.quiet = true;
        return super.doCall();
    }

    @Override
    protected Integer export() throws Exception {
        Integer answer = this.doExport();
        if (answer == 0) {
            Path buildDir = Paths.get(EXPORT_DIR, new String[0]);
            String mvnProgramCall = FileUtil.isWindows() ? "cmd /c mvn" : "mvn";
            if (this.sbomFormat.equalsIgnoreCase(CYCLONEDX_FORMAT)) {
                Object outputDirectoryParameter = "-DoutputDirectory=";
                outputDirectoryParameter = Paths.get(this.outputDirectory, new String[0]).isAbsolute() ? (String)outputDirectoryParameter + this.outputDirectory : (String)outputDirectoryParameter + "../../" + this.outputDirectory;
                Process p = Runtime.getRuntime().exec(mvnProgramCall + " org.cyclonedx:cyclonedx-maven-plugin:" + this.cyclonedxPluginVersion + ":makeAggregateBom " + (String)outputDirectoryParameter + " -DoutputName=" + this.outputName + " -DoutputFormat=" + this.sbomOutputFormat, null, buildDir.toFile());
                boolean done = p.waitFor(60L, TimeUnit.SECONDS);
                if (!done) {
                    answer = 1;
                }
                if (p.exitValue() != 0) {
                    answer = p.exitValue();
                }
            } else if (this.sbomFormat.equalsIgnoreCase(SPDX_FORMAT)) {
                Object outputDirectoryParameter = null;
                String outputFormat = null;
                outputDirectoryParameter = Paths.get(this.outputDirectory, new String[0]).isAbsolute() ? this.outputDirectory : "../../" + this.outputDirectory;
                if (this.sbomOutputFormat.equalsIgnoreCase(SBOM_JSON_FORMAT)) {
                    outputFormat = "JSON";
                } else if (this.sbomOutputFormat.equalsIgnoreCase(SBOM_XML_FORMAT)) {
                    outputFormat = "RDF/XML";
                }
                Process p = Runtime.getRuntime().exec(mvnProgramCall + " org.spdx:spdx-maven-plugin:" + this.spdxPluginVersion + ":createSPDX -DspdxFileName=" + Paths.get((String)outputDirectoryParameter, this.outputName + "." + this.sbomOutputFormat).toString() + " -DoutputFormat=" + outputFormat, null, buildDir.toFile());
                boolean done = p.waitFor(60L, TimeUnit.SECONDS);
                if (!done) {
                    answer = 1;
                }
                if (p.exitValue() != 0) {
                    answer = p.exitValue();
                }
            }
            PathUtils.deleteDirectory(buildDir);
        }
        return answer;
    }

    @Override
    protected Integer doExport() throws Exception {
        Path profile = Paths.get("application.properties", new String[0]);
        if (Files.exists(profile, new LinkOption[0])) {
            CamelCaseOrderedProperties prop = new CamelCaseOrderedProperties();
            RuntimeUtil.loadProperties((Properties)prop, profile);
            if (this.runtime == null && prop.containsKey("camel.jbang.runtime")) {
                this.runtime = RuntimeType.fromValue(prop.getProperty("camel.jbang.runtime"));
            }
            if (this.gav == null) {
                this.gav = prop.getProperty("camel.jbang.gav");
            }
            this.javaVersion = prop.getProperty("camel.jbang.javaVersion", this.javaVersion);
            this.camelVersion = prop.getProperty("camel.jbang.camelVersion", this.camelVersion);
            this.kameletsVersion = prop.getProperty("camel.jbang.kameletsVersion", this.kameletsVersion);
            this.localKameletDir = prop.getProperty("camel.jbang.localKameletDir", this.localKameletDir);
            this.quarkusGroupId = prop.getProperty("camel.jbang.quarkusGroupId", this.quarkusGroupId);
            this.quarkusArtifactId = prop.getProperty("camel.jbang.quarkusArtifactId", this.quarkusArtifactId);
            this.quarkusVersion = prop.getProperty("camel.jbang.quarkusVersion", this.quarkusVersion);
            this.springBootVersion = prop.getProperty("camel.jbang.springBootVersion", this.springBootVersion);
        }
        this.exportDir = EXPORT_DIR;
        if (this.gav == null) {
            this.gav = "org.example.project:camel-jbang-export:1.0";
        }
        if (this.runtime == null) {
            this.runtime = RuntimeType.main;
        }
        switch (this.runtime) {
            case springBoot: {
                return this.export(new ExportSpringBoot(this.getMain()));
            }
            case quarkus: {
                return this.export(new ExportQuarkus(this.getMain()));
            }
            case main: {
                return this.export(new ExportCamelMain(this.getMain()));
            }
        }
        this.printer().printErr("Unknown runtime: " + String.valueOf((Object)this.runtime));
        return 1;
    }
}

