/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.jbang.core.commands;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Field;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import org.apache.camel.catalog.CamelCatalog;
import org.apache.camel.catalog.DefaultCamelCatalog;
import org.apache.camel.util.ReflectionHelper;
import org.apache.camel.util.StringHelper;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;

public final class RunHelper {
    private RunHelper() {
    }

    public static String mavenArtifactId() {
        Path pomPath = Paths.get("pom.xml", new String[0]);
        if (Files.exists(pomPath, new LinkOption[0]) && Files.isRegularFile(pomPath, new LinkOption[0])) {
            String string;
            block9: {
                MavenXpp3Reader mavenReader = new MavenXpp3Reader();
                BufferedReader reader = Files.newBufferedReader(pomPath);
                try {
                    Model model = mavenReader.read((Reader)reader);
                    model.setPomFile(pomPath.toFile());
                    string = model.getArtifactId();
                    if (reader == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (reader != null) {
                            try {
                                ((Reader)reader).close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                ((Reader)reader).close();
            }
            return string;
        }
        return null;
    }

    public static List<String> scanMavenDependenciesFromPom() {
        ArrayList<String> answer = new ArrayList<String>();
        Path pomPath = Paths.get("pom.xml", new String[0]);
        if (Files.exists(pomPath, new LinkOption[0]) && Files.isRegularFile(pomPath, new LinkOption[0])) {
            DefaultCamelCatalog catalog = new DefaultCamelCatalog();
            MavenXpp3Reader mavenReader = new MavenXpp3Reader();
            try (BufferedReader reader = Files.newBufferedReader(pomPath);){
                Model model = mavenReader.read((Reader)reader);
                model.setPomFile(pomPath.toFile());
                for (Dependency d : model.getDependencies()) {
                    String a;
                    String gav;
                    boolean accept;
                    String g = d.getGroupId();
                    String scope = d.getScope();
                    boolean bl = accept = scope == null || "compile".equals(scope);
                    if (accept && !g.startsWith("org.apache.camel")) {
                        String v = d.getVersion();
                        if (v != null && v.startsWith("${") && v.endsWith("}")) {
                            v = v.substring(2, v.length() - 1);
                            v = RunHelper.findMavenProperty(pomPath, v);
                        }
                        if (v == null || answer.contains(gav = "mvn:" + g + ":" + d.getArtifactId() + ":" + v)) continue;
                        answer.add(gav);
                        continue;
                    }
                    if (!accept || !g.startsWith("org.apache.camel") || !RunHelper.isInCamelCatalog((CamelCatalog)catalog, a = d.getArtifactId())) continue;
                    if (a.endsWith("-starter")) {
                        a = StringHelper.before((String)a, (String)"-starter");
                    }
                    if (a.startsWith("camel-quarkus-")) {
                        a = StringHelper.after((String)a, (String)"camel-quarkus");
                    }
                    if (a.startsWith("camel-")) {
                        a = StringHelper.after((String)a, (String)"camel-");
                    }
                    if (answer.contains(gav = "camel:" + a)) continue;
                    answer.add(gav);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return answer;
    }

    public static List<String> scanMavenOrGradleProject() {
        ArrayList<String> answer = new ArrayList<String>();
        Stream<Path> s = Stream.concat(RunHelper.walk(Path.of("src/main/java", new String[0])), RunHelper.walk(Path.of("src/main/resources", new String[0])));
        s.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).map(Path::toString).forEach(answer::add);
        return answer;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String findMavenProperty(Path pomPath, String placeholder) {
        if (!Files.exists(pomPath, new LinkOption[0])) return null;
        if (!Files.isRegularFile(pomPath, new LinkOption[0])) return null;
        MavenXpp3Reader mavenReader = new MavenXpp3Reader();
        try (BufferedReader reader = Files.newBufferedReader(pomPath);){
            Model model = mavenReader.read((Reader)reader);
            model.setPomFile(pomPath.toFile());
            String p = model.getProperties().getProperty(placeholder);
            if (p != null) {
                String string = p;
                return string;
            }
            if (model.getParent() == null) return null;
            p = model.getParent().getRelativePath();
            if (p == null) return null;
            Path parentPath = pomPath.getParent().resolve(p);
            String string = RunHelper.findMavenProperty(parentPath, placeholder);
            return string;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    @Deprecated
    public static String findMavenProperty(File f, String placeholder) {
        return RunHelper.findMavenProperty(f.toPath(), placeholder);
    }

    public static Stream<Path> walk(Path dir) {
        try {
            if (Files.isDirectory(dir, new LinkOption[0])) {
                return Files.walk(dir, new FileVisitOption[0]);
            }
            return Stream.empty();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean isInCamelCatalog(String artifactId) {
        return RunHelper.isInCamelCatalog((CamelCatalog)new DefaultCamelCatalog(), artifactId);
    }

    public static boolean isInCamelCatalog(CamelCatalog catalog, String artifactId) {
        String a;
        for (String n : catalog.findComponentNames()) {
            a = catalog.componentModel(n).getArtifactId();
            if (!artifactId.equals(a)) continue;
            return true;
        }
        for (String n : catalog.findLanguageNames()) {
            a = catalog.languageModel(n).getArtifactId();
            if (!artifactId.equals(a)) continue;
            return true;
        }
        for (String n : catalog.findDataFormatNames()) {
            a = catalog.dataFormatModel(n).getArtifactId();
            if (!artifactId.equals(a)) continue;
            return true;
        }
        for (String n : catalog.findOtherNames()) {
            a = catalog.otherModel(n).getArtifactId();
            if (!artifactId.equals(a)) continue;
            return true;
        }
        return false;
    }

    public static void doWithFields(Class<?> clazz, ReflectionHelper.FieldCallback fc) throws IllegalArgumentException {
        Field[] fields;
        for (Field field : fields = clazz.getDeclaredFields()) {
            try {
                fc.doWith(field);
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
    }
}

