/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.jbang.core.commands;

import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.Comparator;
import java.util.Date;
import java.util.Properties;
import org.apache.camel.dsl.jbang.core.commands.CamelJBangMain;
import org.apache.camel.dsl.jbang.core.commands.ExportBaseCommand;
import org.apache.camel.dsl.jbang.core.commands.ExportCamelMain;
import org.apache.camel.dsl.jbang.core.commands.ExportQuarkus;
import org.apache.camel.dsl.jbang.core.commands.ExportSpringBoot;
import org.apache.camel.dsl.jbang.core.common.RuntimeType;
import org.apache.camel.dsl.jbang.core.common.RuntimeUtil;
import org.apache.camel.dsl.jbang.core.common.SourceScheme;
import org.apache.camel.tooling.maven.MavenGav;
import org.apache.camel.util.CamelCaseOrderedProperties;
import org.apache.camel.util.FileUtil;
import org.apache.camel.util.IOHelper;
import picocli.CommandLine;

@CommandLine.Command(name="export", description={"Export to other runtimes (Camel Main, Spring Boot, or Quarkus)"}, sortOptions=false, showDefaultValues=true)
public class Export
extends ExportBaseCommand {
    public Export(CamelJBangMain main) {
        super(main);
    }

    @Override
    public boolean disarrangeLogging() {
        return false;
    }

    @Override
    protected Integer export() throws Exception {
        int answer = this.doExport();
        if (answer == 0 && !this.quiet) {
            this.printer().println("Project export successful!");
        }
        return answer;
    }

    protected Integer doExport() throws Exception {
        this.doLoadAndInitProfileProperties(Paths.get("application.properties", new String[0]));
        if (this.profile != null) {
            this.doLoadAndInitProfileProperties(Paths.get("application-" + this.profile + ".properties", new String[0]));
        }
        if (this.runtime == null) {
            this.printer().printErr("The runtime option must be specified");
            return 1;
        }
        if (this.gav == null) {
            String pn = this.getProjectName();
            if (pn == null) {
                this.printer().printErr("Failed to resolve project name: Please provide --name, --gav or source file");
                return 1;
            }
            this.gav = "org.example.project:%s:%s".formatted(pn, this.getVersion());
        }
        try {
            this.verifyExportFiles();
        }
        catch (FileNotFoundException ex) {
            this.printer().println(ex.getMessage());
            return 1;
        }
        switch (this.runtime) {
            case springBoot: {
                return this.export(new ExportSpringBoot(this.getMain()));
            }
            case quarkus: {
                return this.export(new ExportQuarkus(this.getMain()));
            }
            case main: {
                return this.export(new ExportCamelMain(this.getMain()));
            }
        }
        this.printer().printErr("Unknown runtime: " + String.valueOf((Object)this.runtime));
        return 1;
    }

    private void verifyExportFiles() throws FileNotFoundException {
        for (String fn : this.files) {
            if (fn.indexOf(58) >= 0 && !fn.startsWith("file:")) continue;
            if (fn.startsWith("file:") && (fn = fn.substring(5)).startsWith("//")) {
                fn = fn.substring(2);
            }
            if (fn.endsWith("/*")) {
                fn = fn.substring(0, fn.length() - 2);
            }
            if (Files.exists(Paths.get(fn, new String[0]), new LinkOption[0])) continue;
            throw new FileNotFoundException("Path does not exist: " + fn);
        }
    }

    private void doLoadAndInitProfileProperties(Path path) throws Exception {
        if (Files.exists(path, new LinkOption[0])) {
            CamelCaseOrderedProperties props = new CamelCaseOrderedProperties();
            RuntimeUtil.loadProperties((Properties)props, path);
            String rt = props.getProperty("camel.jbang.runtime");
            if (rt != null) {
                this.runtime = RuntimeType.fromValue(rt);
            }
            this.gav = props.getProperty("camel.jbang.gav", this.gav);
            this.javaVersion = props.getProperty("camel.jbang.javaVersion", this.javaVersion);
            this.camelVersion = props.getProperty("camel.jbang.camelVersion", this.camelVersion);
            this.kameletsVersion = props.getProperty("camel.jbang.kameletsVersion", this.kameletsVersion);
            this.localKameletDir = props.getProperty("camel.jbang.localKameletDir", this.localKameletDir);
            this.quarkusGroupId = props.getProperty("camel.jbang.quarkusGroupId", this.quarkusGroupId);
            this.quarkusArtifactId = props.getProperty("camel.jbang.quarkusArtifactId", this.quarkusArtifactId);
            this.quarkusVersion = props.getProperty("camel.jbang.quarkusVersion", this.quarkusVersion);
            this.camelSpringBootVersion = props.getProperty("camel.jbang.camelSpringBootVersion", this.camelSpringBootVersion);
            this.springBootVersion = props.getProperty("camel.jbang.springBootVersion", this.springBootVersion);
            this.mavenWrapper = "true".equals(props.getProperty("camel.jbang.mavenWrapper", this.mavenWrapper ? "true" : "false"));
            this.gradleWrapper = "true".equals(props.getProperty("camel.jbang.gradleWrapper", this.gradleWrapper ? "true" : "false"));
            this.exportDir = props.getProperty("camel.jbang.exportDir", this.exportDir);
            this.buildTool = props.getProperty("camel.jbang.buildTool", this.buildTool);
            this.openapi = props.getProperty("camel.jbang.openApi", this.openapi);
            this.repositories = props.getProperty("camel.jbang.repos", this.repositories);
            this.mavenSettings = props.getProperty("camel.jbang.maven-settings", this.mavenSettings);
            this.mavenSettingsSecurity = props.getProperty("camel.jbang.maven-settings-security", this.mavenSettingsSecurity);
            this.mavenCentralEnabled = "true".equals(props.getProperty("camel.jbang.maven-central-enabled", this.mavenCentralEnabled ? "true" : "false"));
            this.mavenApacheSnapshotEnabled = "true".equals(props.getProperty("camel.jbang.maven-apache-snapshot-enabled", this.mavenApacheSnapshotEnabled ? "true" : "false"));
            this.excludes = RuntimeUtil.getCommaSeparatedPropertyAsList((Properties)props, "camel.jbang.excludes", this.excludes);
        }
    }

    protected Integer export(ExportBaseCommand cmd) throws Exception {
        cmd.files = this.files;
        cmd.repositories = this.repositories;
        cmd.dependencies = this.dependencies;
        cmd.runtime = this.runtime;
        cmd.name = this.name;
        cmd.port = this.port;
        cmd.managementPort = this.managementPort;
        cmd.gav = this.gav;
        cmd.mavenSettings = this.mavenSettings;
        cmd.mavenSettingsSecurity = this.mavenSettingsSecurity;
        cmd.mavenCentralEnabled = this.mavenCentralEnabled;
        cmd.mavenApacheSnapshotEnabled = this.mavenApacheSnapshotEnabled;
        cmd.exportDir = this.exportDir;
        cmd.cleanExportDir = this.cleanExportDir;
        cmd.fresh = this.fresh;
        cmd.download = this.download;
        cmd.packageScanJars = this.packageScanJars;
        cmd.javaVersion = this.javaVersion;
        cmd.camelVersion = this.camelVersion;
        cmd.kameletsVersion = this.kameletsVersion;
        cmd.profile = this.profile;
        cmd.localKameletDir = this.localKameletDir;
        cmd.logging = this.logging;
        cmd.loggingLevel = this.loggingLevel;
        cmd.mainClassname = this.mainClassname;
        cmd.camelSpringBootVersion = this.camelSpringBootVersion;
        cmd.quarkusGroupId = this.quarkusGroupId;
        cmd.quarkusArtifactId = this.quarkusArtifactId;
        cmd.quarkusVersion = this.quarkusVersion;
        cmd.springBootVersion = this.springBootVersion;
        cmd.mavenWrapper = this.mavenWrapper;
        cmd.gradleWrapper = this.gradleWrapper;
        cmd.buildTool = this.buildTool;
        cmd.quiet = this.quiet;
        cmd.buildProperties = this.buildProperties;
        cmd.openapi = this.openapi;
        cmd.packageName = this.packageName;
        cmd.excludes = this.excludes;
        cmd.ignoreLoadingError = this.ignoreLoadingError;
        cmd.lazyBean = this.lazyBean;
        cmd.verbose = this.verbose;
        cmd.applicationProperties = this.applicationProperties;
        return cmd.export();
    }

    protected String getProjectName() {
        String[] ids;
        if (this.name != null) {
            return this.name;
        }
        if (this.gav != null && (ids = this.gav.split(":")).length > 1) {
            return ids[1];
        }
        if (!this.files.isEmpty()) {
            return FileUtil.onlyName((String)SourceScheme.onlyName((String)this.files.get(0)));
        }
        return null;
    }

    protected String getVersion() {
        String[] ids;
        if (this.gav != null && (ids = this.gav.split(":")).length > 2) {
            return ids[2];
        }
        return "1.0-SNAPSHOT";
    }

    public Comparator<MavenGav> mavenGavComparator() {
        return new Comparator<MavenGav>(){

            @Override
            public int compare(MavenGav o1, MavenGav o2) {
                int r2;
                int r1 = this.rankGroupId(o1);
                if (r1 > (r2 = this.rankGroupId(o2))) {
                    return -1;
                }
                if (r2 > r1) {
                    return 1;
                }
                return o1.toString().compareTo(o2.toString());
            }

            int rankGroupId(MavenGav o1) {
                String g1 = o1.getGroupId();
                if (g1 == null) {
                    return 0;
                }
                switch (g1) {
                    case "org.springframework.boot": {
                        return 30;
                    }
                    case "io.quarkus": {
                        return 30;
                    }
                    case "org.apache.camel.quarkus": {
                        String a1 = o1.getArtifactId();
                        if ("camel-quarkus-core".equals(a1)) {
                            return 21;
                        }
                        return 20;
                    }
                    case "org.apache.camel.springboot": {
                        String a1 = o1.getArtifactId();
                        if ("camel-spring-boot-starter".equals(a1)) {
                            return 21;
                        }
                        if ("camel-spring-boot-engine-starter".equals(a1)) {
                            return 22;
                        }
                        return 20;
                    }
                    case "org.apache.camel": {
                        String a1 = o1.getArtifactId();
                        if ("camel-main".equals(a1)) {
                            return 11;
                        }
                        return 10;
                    }
                    case "org.apache.camel.kamelets": {
                        return 5;
                    }
                }
                return 0;
            }
        };
    }

    protected String getBuildMavenProjectDate() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        return sdf.format(new Date());
    }

    protected void copyDockerFiles(String buildDir) throws Exception {
        Path docker = Path.of(buildDir, new String[0]).resolve("src/main/docker");
        Files.createDirectories(docker, new FileAttribute[0]);
        String[] ids = this.gav.split(":");
        InputStream is = ExportCamelMain.class.getClassLoader().getResourceAsStream("templates/Dockerfile.tmpl");
        String context = IOHelper.loadText((InputStream)is);
        IOHelper.close((Closeable)is);
        String appJar = ids[1] + "-" + ids[2] + ".jar";
        context = context.replaceAll("\\{\\{ \\.AppJar }}", appJar);
        Files.writeString(docker.resolve("Dockerfile"), (CharSequence)context, new OpenOption[0]);
    }

    protected void copyReadme(String buildDir, String appJar) throws Exception {
        String[] ids = this.gav.split(":");
        InputStream is = ExportCamelMain.class.getClassLoader().getResourceAsStream("templates/readme.md.tmpl");
        String context = IOHelper.loadText((InputStream)is);
        IOHelper.close((Closeable)is);
        context = context.replaceAll("\\{\\{ \\.ArtifactId }}", ids[1]);
        context = context.replaceAll("\\{\\{ \\.Version }}", ids[2]);
        context = context.replaceAll("\\{\\{ \\.AppRuntimeJar }}", appJar);
        Files.writeString(Path.of(buildDir, new String[0]).resolve("readme.md"), (CharSequence)context, new OpenOption[0]);
    }
}

