/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.jbang.core.commands;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.LinkedHashMap;
import java.util.StringJoiner;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.camel.catalog.CamelCatalog;
import org.apache.camel.dsl.jbang.core.commands.CamelCommand;
import org.apache.camel.dsl.jbang.core.commands.CamelJBangMain;
import org.apache.camel.dsl.jbang.core.common.CatalogLoader;
import org.apache.camel.dsl.jbang.core.common.XmlHelper;
import org.apache.camel.util.json.Jsoner;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import picocli.CommandLine;

@CommandLine.Command(name="runtime", description={"Display Camel runtime and version for given Maven project"}, sortOptions=false, showDefaultValues=true)
public class DependencyRuntime
extends CamelCommand {
    protected static final String EXPORT_DIR = ".camel-jbang/export";
    @CommandLine.Option(names={"--json"}, description={"Output in JSON Format"})
    boolean jsonOutput;

    public DependencyRuntime(CamelJBangMain main) {
        super(main);
    }

    @Override
    public Integer doCall() throws Exception {
        Path pom = Paths.get(".", new String[0]).resolve("pom.xml");
        if (Files.exists(pom, new LinkOption[0])) {
            CamelCatalog catalog;
            DocumentBuilderFactory dbf = XmlHelper.createDocumentBuilderFactory();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document dom = db.parse(Files.newInputStream(pom, new OpenOption[0]));
            NodeList nl = dom.getElementsByTagName("dependency");
            String camelVersion = null;
            String camelQuarkusVersion = null;
            String springBootVersion = null;
            String quarkusVersion = null;
            String quarkusGroupId = "io.quarkus.platform";
            for (int i = 0; i < nl.getLength(); ++i) {
                boolean accept;
                Element node = (Element)nl.item(i);
                String p = node.getParentNode().getNodeName();
                String p2 = node.getParentNode().getParentNode().getNodeName();
                boolean bl = accept = ("dependencyManagement".equals(p2) || "project".equals(p2)) && p.equals("dependencies");
                if (!accept) continue;
                String g = node.getElementsByTagName("groupId").item(0).getTextContent();
                String a = node.getElementsByTagName("artifactId").item(0).getTextContent();
                String v = null;
                NodeList vl = node.getElementsByTagName("version");
                if (vl.getLength() > 0) {
                    v = vl.item(0).getTextContent();
                }
                if ("org.apache.camel".equals(g) && "camel-bom".equals(a)) {
                    camelVersion = v;
                    continue;
                }
                if ("org.apache.camel.springboot".equals(g) && "camel-spring-boot-bom".equals(a)) {
                    camelVersion = v;
                    continue;
                }
                if ("org.springframework.boot".equals(g) && "spring-boot-dependencies".equals(a)) {
                    springBootVersion = v;
                    continue;
                }
                if (("${quarkus.platform.group-id}".equals(g) || "io.quarkus.platform".equals(g)) && ("${quarkus.platform.artifact-id}".equals(a) || "quarkus-bom".equals(a))) {
                    if ("${quarkus.platform.version}".equals(v)) {
                        quarkusVersion = dom.getElementsByTagName("quarkus.platform.version").item(0).getTextContent();
                        continue;
                    }
                    quarkusVersion = v;
                    continue;
                }
                if (!"${quarkus.platform.group-id}".equals(g)) continue;
                quarkusGroupId = dom.getElementsByTagName("quarkus.platform.group-id").item(0).getTextContent();
            }
            String repos = null;
            StringJoiner sj = new StringJoiner(",");
            nl = dom.getElementsByTagName("repository");
            for (int i = 0; i < nl.getLength(); ++i) {
                Element node = (Element)nl.item(i);
                String p = node.getParentNode().getNodeName();
                boolean accept = "repositories".equals(p);
                if (!accept) continue;
                String url = node.getElementsByTagName("url").item(0).getTextContent();
                sj.add(url);
            }
            if (sj.length() > 0) {
                repos = sj.toString();
            }
            if (quarkusVersion != null && camelVersion == null && (catalog = CatalogLoader.loadQuarkusCatalog(repos, quarkusVersion, quarkusGroupId)) != null) {
                camelQuarkusVersion = catalog.languageModel("constant").getVersion();
                camelVersion = CatalogLoader.resolveCamelVersionFromQuarkus(repos, camelQuarkusVersion);
            }
            String runtime = "camel-main";
            if (springBootVersion != null) {
                runtime = "camel-spring-boot";
            } else if (quarkusVersion != null) {
                runtime = "camel-quarkus";
            }
            if (this.jsonOutput) {
                LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
                map.put("runtime", runtime);
                if (camelVersion != null) {
                    map.put("camelVersion", camelVersion);
                }
                if (camelQuarkusVersion != null) {
                    map.put("camelQuarkusVersion", camelQuarkusVersion);
                }
                if (springBootVersion != null) {
                    map.put("springBootVersion", springBootVersion);
                }
                if (quarkusVersion != null) {
                    map.put("quarkusVersion", quarkusVersion);
                }
                this.printer().println(Jsoner.serialize(map));
            } else {
                this.printer().println("Runtime: " + runtime);
                if (camelVersion != null) {
                    this.printer().println("Camel Version: " + camelVersion);
                }
                if (camelQuarkusVersion != null) {
                    this.printer().println("Camel Quarkus Version: " + camelQuarkusVersion);
                }
                if (springBootVersion != null) {
                    this.printer().println("Spring Boot Version: " + springBootVersion);
                } else if (quarkusVersion != null) {
                    this.printer().println("Quarkus Version: " + quarkusVersion);
                }
            }
        }
        return 0;
    }
}

