/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.jbang.core.commands;

import java.io.BufferedReader;
import java.io.Console;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.camel.dsl.jbang.core.commands.CamelJBangMain;
import org.apache.camel.dsl.jbang.core.commands.Run;
import org.apache.camel.dsl.jbang.core.commands.RunHelper;
import org.apache.camel.dsl.jbang.core.commands.action.MessageTableHelper;
import org.apache.camel.dsl.jbang.core.common.CamelCommandHelper;
import org.apache.camel.dsl.jbang.core.common.CommandLineHelper;
import org.apache.camel.dsl.jbang.core.common.PathUtils;
import org.apache.camel.dsl.jbang.core.common.VersionHelper;
import org.apache.camel.main.KameletMain;
import org.apache.camel.util.FileUtil;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.StringHelper;
import org.apache.camel.util.TimeUtils;
import org.apache.camel.util.URISupport;
import org.apache.camel.util.concurrent.ThreadHelper;
import org.apache.camel.util.json.JsonArray;
import org.apache.camel.util.json.JsonObject;
import org.apache.camel.util.json.Jsoner;
import org.fusesource.jansi.Ansi;
import org.fusesource.jansi.AnsiConsole;
import picocli.CommandLine;

@CommandLine.Command(name="debug", description={"Debug local Camel integration"}, sortOptions=false, showDefaultValues=true)
public class Debug
extends Run {
    @CommandLine.Option(names={"--breakpoint"}, description={"To set breakpoint at the given node id (Multiple ids can be separated by comma). If no breakpoint is set, then the first route is automatic selected."})
    String breakpoint;
    @CommandLine.Option(names={"--output"}, description={"File to store the current message body (will override). This allows for manual inspecting the message later."})
    String output;
    @CommandLine.Option(names={"--stop-on-exit"}, defaultValue="true", description={"Whether to stop the running Camel on exit"})
    boolean stopOnExit = true;
    @CommandLine.Option(names={"--log-lines"}, defaultValue="10", description={"Number of log lines to display on top of screen"})
    int logLines = 10;
    @CommandLine.Option(names={"--timestamp"}, defaultValue="true", description={"Print timestamp."})
    boolean timestamp = true;
    @CommandLine.Option(names={"--ago"}, description={"Use ago instead of yyyy-MM-dd HH:mm:ss in timestamp."})
    boolean ago;
    @CommandLine.Option(names={"--mask"}, description={"Whether to mask endpoint URIs to avoid printing sensitive information such as password or access keys"})
    boolean mask;
    @CommandLine.Option(names={"--source"}, description={"Prefer to display source filename/code instead of IDs"})
    boolean source;
    @CommandLine.Option(names={"--show-exchange-properties"}, defaultValue="false", description={"Show exchange properties in debug messages"})
    boolean showExchangeProperties;
    @CommandLine.Option(names={"--show-exchange-variables"}, defaultValue="true", description={"Show exchange variables in debug messages"})
    boolean showExchangeVariables = true;
    @CommandLine.Option(names={"--show-headers"}, defaultValue="true", description={"Show message headers in debug messages"})
    boolean showHeaders = true;
    @CommandLine.Option(names={"--show-body"}, defaultValue="true", description={"Show message body in debug messages"})
    boolean showBody = true;
    @CommandLine.Option(names={"--show-exception"}, defaultValue="true", description={"Show exception and stacktrace for failed messages"})
    boolean showException = true;
    @CommandLine.Option(names={"--pretty"}, description={"Pretty print message body when using JSon or XML format"})
    boolean pretty;
    private MessageTableHelper tableHelper;
    private InputStream spawnOutput;
    private InputStream spawnError;
    private final List<String> logBuffer = new ArrayList<String>(100);
    private final AtomicBoolean logUpdated = new AtomicBoolean();
    private SuspendedRow suspendedRow = new SuspendedRow();
    private final AtomicBoolean waitForUser = new AtomicBoolean();
    private final AtomicLong debugCounter = new AtomicLong();

    public Debug(CamelJBangMain main) {
        super(main);
    }

    @Override
    public Integer doCall() throws Exception {
        Integer exit;
        if (!this.exportRun) {
            this.printConfigurationValues("Debugging integration with the following configuration:");
        }
        if ((exit = this.runDebug()) != null && exit != 0) {
            return exit;
        }
        if (this.stopOnExit) {
            this.installHangupInterceptor();
        }
        this.tableHelper = new MessageTableHelper();
        this.tableHelper.setPretty(this.pretty);
        this.tableHelper.setLoggingColor(this.loggingColor);
        this.tableHelper.setShowExchangeProperties(this.showExchangeProperties);
        this.tableHelper.setShowExchangeVariables(this.showExchangeVariables);
        AtomicBoolean quit = new AtomicBoolean();
        Console c = System.console();
        Thread t = new Thread(() -> this.doReadLog(quit), "ReadLog");
        t.start();
        Thread t2 = new Thread(() -> this.doRead(c, quit), "ReadCommand");
        t2.start();
        do {
            if ((exit = Integer.valueOf(this.doWatch())) == 0) {
                Thread.sleep(100L);
                continue;
            }
            if (exit != -1) continue;
            for (String line : this.logBuffer) {
                this.printer().println(line);
            }
            String text = IOHelper.loadText((InputStream)this.spawnError);
            this.printer().println(text);
            return -1;
        } while (exit == 0 && !quit.get());
        return 0;
    }

    private void doReadLog(AtomicBoolean quit) {
        do {
            InputStreamReader isr = new InputStreamReader(this.spawnOutput);
            try {
                String line;
                BufferedReader reader = IOHelper.buffered((Reader)isr);
                while ((line = reader.readLine()) != null) {
                    while (this.logBuffer.size() >= 100) {
                        this.logBuffer.remove(0);
                    }
                    this.logBuffer.add(line);
                    this.logUpdated.set(true);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        } while (!quit.get());
    }

    private void doRead(Console c, AtomicBoolean quit) {
        do {
            String line;
            if ((line = c.readLine()) == null) continue;
            if ("q".equalsIgnoreCase(line = line.trim()) || "quit".equalsIgnoreCase(line) || "exit".equalsIgnoreCase(line)) {
                quit.set(true);
            } else {
                if (this.suspendedRow != null && this.suspendedRow.last) {
                    this.logUpdated.set(true);
                }
                String cmd = "step";
                if (line.equalsIgnoreCase("o") || line.equalsIgnoreCase("over")) {
                    cmd = "stepover";
                }
                this.sendDebugCommand(this.spawnPid, cmd, null);
            }
            this.waitForUser.set(false);
        } while (!quit.get());
    }

    @Override
    protected int runDebug(KameletMain main) throws Exception {
        ArrayList<String> cmds = new ArrayList<String>(this.spec.commandLine().getParseResult().originalArgs());
        cmds.remove(0);
        cmds.add(0, "run");
        cmds.remove("--background=true");
        cmds.remove("--background");
        cmds.remove("--background-wait=true");
        cmds.remove("--background-wait=false");
        cmds.remove("--background-wait");
        this.removeDebugOnlyOptions(cmds);
        cmds.add("--prop=camel.debug.enabled=true");
        if (this.breakpoint == null) {
            cmds.add("--prop=camel.debug.breakpoints=_all_routes_");
        } else {
            cmds.add("--prop=camel.debug.breakpoints=" + this.breakpoint);
        }
        cmds.add("--prop=camel.debug.loggingLevel=DEBUG");
        cmds.add("--prop=camel.debug.singleStepIncludeStartEnd=true");
        Debug.addCamelCommand(cmds);
        ProcessBuilder pb = new ProcessBuilder(new String[0]);
        pb.command(cmds);
        Process p = pb.start();
        this.spawnOutput = p.getInputStream();
        this.spawnError = p.getErrorStream();
        this.spawnPid = p.pid();
        this.printer().println("Debugging Camel integration: " + this.name + " with PID: " + p.pid());
        return 0;
    }

    private void removeDebugOnlyOptions(List<String> cmds) {
        RunHelper.doWithFields(Debug.class, fc -> cmds.removeIf(c -> {
            String n1 = "--" + fc.getName();
            String n2 = "--" + StringHelper.camelCaseToDash((String)fc.getName());
            return c.startsWith(n1) || c.startsWith(n2);
        }));
    }

    protected int doWatch() {
        if (this.spawnPid == 0L) {
            return -1;
        }
        ProcessHandle ph = ProcessHandle.of(this.spawnPid).orElse(null);
        if (ph == null || !ph.isAlive()) {
            return -1;
        }
        if (this.waitForUser.get()) {
            return 0;
        }
        StringWriter sw = new StringWriter();
        if (this.logLines > 0) {
            int start;
            for (int i = start = Math.max(this.logBuffer.size() - this.logLines, 0); i < start + this.logLines; ++i) {
                String line = "";
                if (i < this.logBuffer.size()) {
                    line = this.logBuffer.get(i);
                }
                sw.write(line);
                sw.write(System.lineSeparator());
            }
        }
        this.printDebugStatus(this.spawnPid, sw);
        return 0;
    }

    private void sendDebugCommand(long pid, String command, String breakpoint) {
        Path outputFile = this.getOutputFile(Long.toString(pid));
        PathUtils.deleteFile(outputFile);
        JsonObject root = new JsonObject();
        root.put((Object)"action", (Object)"debug");
        if (command != null) {
            root.put((Object)"command", (Object)command);
        }
        if (breakpoint != null) {
            root.put((Object)"breakpoint", (Object)breakpoint);
        }
        Path f = this.getActionFile(Long.toString(pid));
        try {
            String text = root.toJson();
            Files.writeString(f, (CharSequence)text, new OpenOption[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static boolean isStepOverSupported(String version) {
        if ("4.9.0".equals(version)) {
            return false;
        }
        return version == null || VersionHelper.isGE(version, "4.8.3");
    }

    private void printDebugStatus(long pid, StringWriter buffer) {
        JsonObject jo = this.loadDebug(pid);
        if (jo != null) {
            Object arr;
            ArrayList<SuspendedRow> rows = new ArrayList<SuspendedRow>();
            long cnt = jo.getLongOrDefault("debugCounter", 0L);
            String version = jo.getString("version");
            if (cnt > this.debugCounter.get() && (arr = (JsonArray)jo.getCollection("suspended")) != null) {
                if (arr.size() > 1) {
                    this.printer().println("WARN: Multiple suspended breakpoints is not supported (You can use --breakpoint option to specify a starting breakpoint)");
                    return;
                }
                Iterator iterator = arr.iterator();
                while (iterator.hasNext()) {
                    List lines;
                    Long ts;
                    JsonObject es;
                    Object o = iterator.next();
                    SuspendedRow row = new SuspendedRow();
                    row.pid = String.valueOf(pid);
                    row.version = version;
                    jo = (JsonObject)o;
                    row.uid = jo.getLong("uid");
                    row.first = jo.getBoolean("first");
                    row.last = jo.getBoolean("last");
                    row.location = jo.getString("location");
                    row.routeId = jo.getString("routeId");
                    row.nodeId = jo.getString("nodeId");
                    String uri = jo.getString("endpointUri");
                    if (uri != null) {
                        row.endpoint = new JsonObject();
                        if (this.mask) {
                            uri = URISupport.sanitizeUri((String)uri);
                        }
                        row.endpoint.put((Object)"endpoint", (Object)uri);
                    }
                    if ((es = (JsonObject)jo.getMap("endpointService")) != null) {
                        row.endpointService = es;
                    }
                    if ((ts = jo.getLong("timestamp")) != null) {
                        row.timestamp = ts;
                    }
                    row.elapsed = jo.getLong("elapsed");
                    row.failed = jo.getBoolean("failed");
                    row.done = jo.getBoolean("done");
                    row.threadName = jo.getString("threadName");
                    row.message = (JsonObject)jo.getMap("message");
                    row.exception = (JsonObject)jo.getMap("exception");
                    row.exchangeId = row.message.getString("exchangeId");
                    row.exchangePattern = row.message.getString("exchangePattern");
                    row.message.remove((Object)"exchangeId");
                    row.message.remove((Object)"exchangePattern");
                    if (!this.showExchangeVariables) {
                        row.message.remove((Object)"exchangeVariables");
                    }
                    if (!this.showExchangeProperties) {
                        row.message.remove((Object)"exchangeProperties");
                    }
                    if (!this.showHeaders) {
                        row.message.remove((Object)"headers");
                    }
                    if (!this.showBody) {
                        row.message.remove((Object)"body");
                    }
                    if (!this.showException) {
                        row.exception = null;
                    }
                    if ((lines = (List)jo.getCollection("code")) != null) {
                        for (JsonObject line : lines) {
                            Code code = new Code();
                            code.line = line.getInteger("line");
                            code.match = line.getBooleanOrDefault("match", false);
                            code.code = line.getString("code");
                            row.code.add(code);
                        }
                    }
                    if ((lines = (List)jo.getCollection("history")) != null) {
                        for (JsonObject line : lines) {
                            boolean accept = line.getBooleanOrDefault("acceptDebugger", true);
                            if (!accept) continue;
                            History history = new History();
                            history.routeId = line.getString("routeId");
                            history.nodeId = line.getString("nodeId");
                            history.elapsed = line.getLongOrDefault("elapsed", 0L);
                            history.location = line.getString("location");
                            history.line = line.getIntegerOrDefault("line", -1);
                            history.code = line.getString("code");
                            row.history.add(history);
                        }
                    }
                    rows.add(row);
                }
            }
            if (rows.isEmpty() && !this.logUpdated.get()) {
                return;
            }
            this.logUpdated.set(false);
            this.clearScreen();
            this.printer().println(buffer.toString());
            for (SuspendedRow row : rows) {
                this.printSourceAndHistory(row);
                this.printSuspendedRow(row);
                this.suspendedRow = row;
                this.debugCounter.set(cnt);
                this.waitForUser.set(true);
            }
            if (this.waitForUser.get()) {
                String b;
                JsonObject j;
                if (this.output != null && this.suspendedRow != null && (j = this.suspendedRow.message) != null && (j = (JsonObject)j.getMap("body")) != null && (b = j.getString("value")) != null) {
                    b = CamelCommandHelper.valueAsStringPretty(b, false);
                    try {
                        Path f = Path.of(this.output, new String[0]);
                        Files.writeString(f, (CharSequence)b, new OpenOption[0]);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                String msg = Debug.isStepOverSupported(version) ? "    Breakpoint suspended (i = step into (default), o = step over). Press ENTER to continue." : "    Breakpoint suspended. Press ENTER to continue.";
                if (this.loggingColor) {
                    AnsiConsole.out().println((Object)Ansi.ansi().a(Ansi.Attribute.INTENSITY_BOLD).a(msg).reset());
                } else {
                    this.printer().println(msg);
                }
                this.printer().println();
            }
        }
    }

    private void printSourceAndHistory(SuspendedRow row) {
        ArrayList<Panel> panel = new ArrayList<Panel>();
        if (!row.code.isEmpty()) {
            int i;
            Object loc = StringHelper.beforeLast((String)row.location, (String)":", (String)row.location);
            loc = loc != null && ((String)loc).length() < 72 ? (String)loc + " ".repeat(72 - ((String)loc).length()) : "";
            panel.add(Panel.withCode("Source: " + (String)loc).andHistory("History"));
            panel.add(Panel.withCode("-".repeat(80)).andHistory("-".repeat(90)));
            for (i = 0; i < row.code.size(); ++i) {
                Object msg;
                Code code = row.code.get(i);
                String c = Jsoner.unescape((String)code.code);
                String arrow = "    ";
                if (code.match) {
                    arrow = row.first ? "*-->" : (row.last ? "<--*" : "--->");
                }
                if (((String)(msg = String.format("%4d: %s %s", code.line, arrow, c))).length() > 80) {
                    msg = ((String)msg).substring(0, 80);
                }
                int length = ((String)msg).length();
                if (this.loggingColor && code.match) {
                    Ansi.Color col = Ansi.Color.BLUE;
                    if (row.failed && row.last) {
                        col = Ansi.Color.RED;
                    } else if (row.last) {
                        col = Ansi.Color.GREEN;
                    }
                    if (length < 80) {
                        String extra = " ".repeat(80 - length);
                        msg = (String)msg + extra;
                        length = 80;
                    }
                    msg = Ansi.ansi().bg(col).a(Ansi.Attribute.INTENSITY_BOLD).a((String)msg).reset().toString();
                } else if (length < 80) {
                    String extra = " ".repeat(80 - length);
                    msg = (String)msg + extra;
                    length = 80;
                }
                panel.add(Panel.withCode((String)msg, length));
            }
            for (i = row.code.size(); i < 11; ++i) {
                panel.add(Panel.withCode(" ".repeat(80)));
            }
        }
        if (!row.history.isEmpty()) {
            if (row.history.size() > panel.size() - 4) {
                int pos = row.history.size() - (panel.size() - 4);
                if (row.history.size() > pos) {
                    row.history = row.history.subList(pos, row.history.size());
                }
            }
            for (int i = 2; panel.size() > 2 && i < 11; ++i) {
                Object ids;
                Panel p = (Panel)panel.get(i);
                if (row.history.size() <= i - 2) continue;
                History h = row.history.get(i - 2);
                boolean top = false;
                if (row.version != null && VersionHelper.isGE(row.version, "4.7")) {
                    top = h == row.history.get(row.history.size() - 1);
                }
                if (((String)(ids = this.source ? Debug.locationAndLine(h.location, h.line) : h.routeId + "/" + h.nodeId)).length() > 30) {
                    ids = ((String)ids).substring(((String)ids).length() - 30);
                }
                ids = String.format("%-30.30s", ids);
                if (this.loggingColor) {
                    ids = Ansi.ansi().fgCyan().a((String)ids).reset().toString();
                }
                long e = i == 2 ? 0L : h.elapsed;
                String elapsed = "(" + e + "ms)";
                String c = "";
                if (h.code != null) {
                    c = Jsoner.unescape((String)h.code);
                    c = c.trim();
                }
                String fids = String.format("%-30.30s", ids);
                String msg = top && !row.last ? String.format("%10.10s %s %4d:   %s", "--->", fids, h.line, c) : String.format("%10.10s %s %4d:   %s", elapsed, fids, h.line, c);
                int len = msg.length();
                if (this.loggingColor) {
                    fids = String.format("%-30.30s", ids);
                    fids = Ansi.ansi().fgCyan().a(fids).reset().toString();
                    msg = top && !row.last ? String.format("%10.10s %s %4d:   %s", "--->", fids, h.line, c) : String.format("%10.10s %s %4d:   %s", elapsed, fids, h.line, c);
                }
                p.history = msg;
                p.historyLength = len;
            }
        }
        for (Panel p : panel) {
            String c = p.code;
            String h = p.history;
            int len = p.historyLength;
            if (len > 90) {
                h = h.substring(0, 90);
            }
            String line = c + "    " + h;
            this.printer().println(line);
        }
    }

    private void printSuspendedRow(SuspendedRow row) {
        if (this.timestamp) {
            String ts;
            if (this.ago) {
                ts = String.format("%12s", TimeUtils.printSince((long)row.timestamp) + " ago");
            } else {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
                ts = sdf.format(new Date(row.timestamp));
            }
            if (this.loggingColor) {
                AnsiConsole.out().print((Object)Ansi.ansi().fgBrightDefault().a(Ansi.Attribute.INTENSITY_FAINT).a(ts).reset());
            } else {
                this.printer().print(ts);
            }
            this.printer().print("  ");
        }
        String p = String.format("%5.5s", row.pid);
        if (this.loggingColor) {
            AnsiConsole.out().print((Object)Ansi.ansi().fgMagenta().a(p).reset());
            AnsiConsole.out().print((Object)Ansi.ansi().fgBrightDefault().a(Ansi.Attribute.INTENSITY_FAINT).a(" --- ").reset());
        } else {
            this.printer().print(p);
            this.printer().print(" --- ");
        }
        String tn = row.threadName;
        if (tn.length() > 25) {
            tn = tn.substring(tn.length() - 25);
        }
        tn = String.format("[%25.25s]", tn);
        if (this.loggingColor) {
            AnsiConsole.out().print((Object)Ansi.ansi().fgBrightDefault().a(Ansi.Attribute.INTENSITY_FAINT).a(tn).reset());
        } else {
            this.printer().print(tn);
        }
        this.printer().print(" ");
        Object ids = this.source ? Debug.locationAndLine(row.location, -1) : row.routeId + "/" + this.getId(row);
        if (((String)ids).length() > 40) {
            ids = ((String)ids).substring(((String)ids).length() - 40);
        }
        ids = String.format("%40.40s", ids);
        if (this.loggingColor) {
            AnsiConsole.out().print((Object)Ansi.ansi().fgCyan().a((String)ids).reset());
        } else {
            this.printer().print((String)ids);
        }
        this.printer().print(" : ");
        String u = String.format("%5.5s", row.uid);
        if (this.loggingColor) {
            AnsiConsole.out().print((Object)Ansi.ansi().fgMagenta().a(u).reset());
        } else {
            this.printer().print(u);
        }
        this.printer().print(" - ");
        this.printer().print(this.getStatus(row));
        String e = this.getElapsed(row);
        if (e != null) {
            if (this.loggingColor) {
                AnsiConsole.out().print((Object)Ansi.ansi().fgBrightDefault().a(" (" + e + ")").reset());
            } else {
                this.printer().print("(" + e + ")");
            }
        }
        this.printer().println();
        this.printer().println(this.getDataAsTable(row));
        this.printer().println();
    }

    private static String locationAndLine(String loc, int line) {
        loc = FileUtil.stripPath((String)loc);
        return line == -1 ? loc : loc + ":" + line;
    }

    private void clearScreen() {
        AnsiConsole.out().print((Object)Ansi.ansi().eraseScreen().cursor(1, 1));
    }

    private void handleHangup() {
        Path pidPath;
        if (this.spawnPid > 0L && Files.exists(pidPath = CommandLineHelper.getCamelDir().resolve(Long.toString(this.spawnPid)), new LinkOption[0])) {
            this.printer().println("Shutting down Camel integration (PID: " + this.spawnPid + ")");
            PathUtils.deleteFile(pidPath);
        }
    }

    private void installHangupInterceptor() {
        Thread task = new Thread(this::handleHangup);
        task.setName(ThreadHelper.resolveThreadName(null, (String)"CamelHangupInterceptor"));
        Runtime.getRuntime().addShutdownHook(task);
    }

    JsonObject loadDebug(long pid) {
        try {
            Path p = this.getDebugFile(Long.toString(pid));
            if (p != null && Files.exists(p, new LinkOption[0])) {
                String text = Files.readString(p);
                return (JsonObject)Jsoner.deserialize((String)text);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private String getDataAsTable(SuspendedRow r) {
        return this.tableHelper.getDataAsTable(r.exchangeId, r.exchangePattern, r.endpoint, r.endpointService, r.message, r.exception);
    }

    private String getStatus(SuspendedRow r) {
        String s;
        boolean remote;
        boolean bl = remote = r.endpoint != null && r.endpoint.getBooleanOrDefault("remote", false) != false;
        if (r.first) {
            String s2 = "Created";
            if (this.loggingColor) {
                return Ansi.ansi().fg(Ansi.Color.GREEN).a(s2).reset().toString();
            }
            return s2;
        }
        if (r.last) {
            String done;
            String string = done = r.exception != null ? "Completed (exception)" : "Completed (success)";
            if (this.loggingColor) {
                return Ansi.ansi().fg(r.failed ? Ansi.Color.RED : Ansi.Color.GREEN).a(done).reset().toString();
            }
            return done;
        }
        if (!r.done) {
            if (this.loggingColor) {
                return Ansi.ansi().fg(Ansi.Color.BLUE).a("Breakpoint").reset().toString();
            }
            return "Breakpoint";
        }
        if (r.failed) {
            String fail;
            String string = fail = r.exception != null ? "Exception" : "Failed";
            if (this.loggingColor) {
                return Ansi.ansi().fg(Ansi.Color.RED).a(fail).reset().toString();
            }
            return fail;
        }
        String string = s = remote ? "Sent" : "Processed";
        if (this.loggingColor) {
            return Ansi.ansi().fg(Ansi.Color.GREEN).a(s).reset().toString();
        }
        return s;
    }

    private String getId(SuspendedRow r) {
        if (r.first) {
            return "*-->";
        }
        if (r.last) {
            return "*<--";
        }
        return r.nodeId;
    }

    private String getElapsed(SuspendedRow r) {
        if (!r.first) {
            return TimeUtils.printDuration((long)r.elapsed, (boolean)true);
        }
        return null;
    }

    private static class SuspendedRow {
        String pid;
        String version;
        boolean first;
        boolean last;
        long uid;
        String exchangeId;
        String exchangePattern;
        String threadName;
        String location;
        String routeId;
        String nodeId;
        long timestamp;
        long elapsed;
        boolean done;
        boolean failed;
        JsonObject endpoint;
        JsonObject endpointService;
        JsonObject message;
        JsonObject exception;
        List<Code> code = new ArrayList<Code>();
        List<History> history = new ArrayList<History>();

        private SuspendedRow() {
        }
    }

    private static class Code {
        int line;
        String code;
        boolean match;

        private Code() {
        }
    }

    private static class History {
        String routeId;
        String nodeId;
        long elapsed;
        String location;
        int line;
        String code;

        private History() {
        }
    }

    private static class Panel {
        String code = "";
        String history = "";
        int codeLength;
        int historyLength;

        private Panel() {
        }

        static Panel withCode(String code) {
            return Panel.withCode(code, code.length());
        }

        static Panel withCode(String code, int length) {
            Panel p = new Panel();
            p.code = code;
            p.codeLength = length;
            return p;
        }

        Panel andHistory(String history) {
            return this.andHistory(history, history.length());
        }

        Panel andHistory(String history, int length) {
            this.history = history;
            this.historyLength = length;
            return this;
        }
    }
}

