/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.jbang.core.commands;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.stream.Stream;
import org.apache.camel.dsl.jbang.core.common.PathUtils;
import org.apache.camel.dsl.jbang.core.common.Printer;

public final class CommandHelper {
    private static final ThreadLocal<Printer> printerAssociation = new ThreadLocal();

    private CommandHelper() {
    }

    public static Printer getPrinter() {
        return printerAssociation.get();
    }

    public static void setPrinter(Printer out) {
        printerAssociation.set(out);
    }

    public static void cleanExportDir(String dir) {
        CommandHelper.cleanExportDir(dir, true);
    }

    public static void cleanExportDir(String dir, boolean keepHidden) {
        Path targetPath = Paths.get(dir, new String[0]);
        if (!Files.exists(targetPath, new LinkOption[0])) {
            return;
        }
        try (Stream<Path> paths = Files.list(targetPath);){
            paths.forEach(path -> {
                try {
                    boolean isHidden = Files.isHidden(path);
                    if (!(!Files.isDirectory(path, new LinkOption[0]) || keepHidden && isHidden)) {
                        PathUtils.deleteDirectory(path);
                    } else if (!(!Files.isRegularFile(path, new LinkOption[0]) || keepHidden && isHidden)) {
                        Files.deleteIfExists(path);
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            });
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static class ReadConsoleTask
    implements Runnable {
        private final Runnable listener;

        public ReadConsoleTask(Runnable listener) {
            this.listener = listener;
        }

        @Override
        public void run() {
            System.console().readLine();
            this.listener.run();
        }
    }
}

