/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.jbang.core.commands;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Properties;
import java.util.Stack;
import java.util.concurrent.Callable;
import org.apache.camel.dsl.jbang.core.commands.CamelJBangMain;
import org.apache.camel.dsl.jbang.core.commands.CommandHelper;
import org.apache.camel.dsl.jbang.core.common.CommandLineHelper;
import org.apache.camel.dsl.jbang.core.common.Printer;
import org.apache.camel.dsl.jbang.core.common.RuntimeUtil;
import org.apache.camel.util.StringHelper;
import picocli.CommandLine;

public abstract class CamelCommand
implements Callable<Integer> {
    @CommandLine.Spec
    CommandLine.Model.CommandSpec spec;
    private final CamelJBangMain main;
    @CommandLine.Option(names={"-h", "--help"}, usageHelp=true, description={"Display the help and sub-commands"})
    private boolean helpRequested = false;

    public CamelCommand(CamelJBangMain main) {
        this.main = main;
    }

    public CamelJBangMain getMain() {
        return this.main;
    }

    protected void configureLoggingOff() throws Exception {
        RuntimeUtil.configureLog("off", false, false, false, false, null, null);
    }

    protected boolean disarrangeLogging() {
        return true;
    }

    @Override
    public Integer call() throws Exception {
        if (this.disarrangeLogging()) {
            this.configureLoggingOff();
        }
        this.replacePlaceholders();
        return this.doCall();
    }

    private void replacePlaceholders() throws Exception {
        if (this.spec != null) {
            for (CommandLine.Model.ArgSpec argSpec : this.spec.args()) {
                CommandLine.IDefaultValueProvider provider = this.spec.defaultValueProvider();
                String defaultValue = provider != null ? provider.defaultValue(argSpec) : null;
                if (defaultValue == null || !(argSpec instanceof CommandLine.Model.OptionSpec)) continue;
                CommandLine.Model.OptionSpec optionSpec = (CommandLine.Model.OptionSpec)argSpec;
                for (String name : optionSpec.names()) {
                    String placeholder = "#" + StringHelper.after((String)name, (String)"--");
                    Object v = argSpec.getValue();
                    if (v == null || !v.toString().contains(placeholder)) continue;
                    argSpec.setValue((Object)v.toString().replace(placeholder, defaultValue));
                }
            }
        }
    }

    public abstract Integer doCall() throws Exception;

    public Path getStatusFile(String pid) {
        return CommandLineHelper.getCamelDir().resolve(pid + "-status.json");
    }

    public Path getActionFile(String pid) {
        return CommandLineHelper.getCamelDir().resolve(pid + "-action.json");
    }

    public Path getOutputFile(String pid) {
        return CommandLineHelper.getCamelDir().resolve(pid + "-output.json");
    }

    public Path getTraceFile(String pid) {
        return CommandLineHelper.getCamelDir().resolve(pid + "-trace.json");
    }

    public Path getReceiveFile(String pid) {
        return CommandLineHelper.getCamelDir().resolve(pid + "-receive.json");
    }

    public Path getDebugFile(String pid) {
        return CommandLineHelper.getCamelDir().resolve(pid + "-debug.json");
    }

    public Path getRunBackgroundLogFile(String uuid) {
        return CommandLineHelper.getCamelDir().resolve(uuid + "-run.log");
    }

    protected Printer printer() {
        Printer out = this.getMain().getOut();
        CommandHelper.setPrinter(out);
        return out;
    }

    protected void printConfigurationValues(String header) {
        if (this.spec != null) {
            Properties configProperties = new Properties();
            CommandLineHelper.loadProperties(configProperties::putAll);
            ArrayList lines = new ArrayList();
            this.spec.options().forEach(opt -> {
                if (Arrays.stream(opt.names()).anyMatch(name -> configProperties.containsKey(name.substring(2)))) {
                    lines.add(String.format("    %s=%s", opt.longestName(), opt.getValue().toString()));
                }
            });
            if (!lines.isEmpty()) {
                this.printer().println(header);
                lines.forEach(this.printer()::println);
            }
        }
    }

    protected static abstract class ParameterConsumer<T>
    implements CommandLine.IParameterConsumer {
        protected ParameterConsumer() {
        }

        public void consumeParameters(Stack<String> args, CommandLine.Model.ArgSpec argSpec, CommandLine.Model.CommandSpec cmdSpec) {
            if (this.failIfEmptyArgs() && args.isEmpty()) {
                throw new CommandLine.ParameterException(cmdSpec.commandLine(), "Error: missing required parameter");
            }
            Object cmd = cmdSpec.userObject();
            this.doConsumeParameters(args, cmd);
        }

        protected abstract void doConsumeParameters(Stack<String> var1, T var2);

        protected boolean failIfEmptyArgs() {
            return true;
        }
    }
}

