/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.jbang.core.common;

import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.xml.pretty.XmlPrettyPrinter;
import org.fusesource.jansi.Ansi;

public final class XmlHelper {
    private XmlHelper() {
    }

    public static String prettyPrint(String xml, int spaces) throws Exception {
        return XmlPrettyPrinter.pettyPrint((String)xml, (int)spaces);
    }

    public static String colorPrint(String xml, int spaces, boolean pretty) throws Exception {
        return XmlPrettyPrinter.colorPrint((String)xml, (int)spaces, (boolean)pretty, (XmlPrettyPrinter.ColorPrintElement)new XmlPrettyPrinter.ColorPrintElement(){

            public String color(int type, String value) {
                String s;
                String string = s = value != null ? value : "null";
                if (type == 1) {
                    s = Ansi.ansi().fgBrightDefault().a(Ansi.Attribute.INTENSITY_FAINT).a(s).reset().toString();
                } else if (type == 2) {
                    s = Ansi.ansi().fgBright(Ansi.Color.BLUE).a(s).reset().toString();
                } else if (type == 7) {
                    s = Ansi.ansi().fgDefault().a(s).reset().toString();
                } else if (type == 3) {
                    s = Ansi.ansi().fg(Ansi.Color.MAGENTA).a(s).reset().toString();
                } else if (type == 4 || type == 6) {
                    s = Ansi.ansi().fg(Ansi.Color.GREEN).a(s).reset().toString();
                }
                return s;
            }
        });
    }

    public static DocumentBuilderFactory createDocumentBuilderFactory() {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setIgnoringElementContentWhitespace(true);
        factory.setIgnoringComments(true);
        try {
            factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", Boolean.TRUE);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            // empty catch block
        }
        try {
            factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            // empty catch block
        }
        try {
            factory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            // empty catch block
        }
        try {
            Class smClass = ObjectHelper.loadClass((String)"org.apache.xerces.util.SecurityManager");
            if (smClass != null) {
                Object sm = smClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                factory.setAttribute("http://apache.org/xml/properties/security-manager", sm);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return factory;
    }
}

