/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.jbang.core.common;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import org.apache.camel.dsl.jbang.core.common.CommandLineHelper;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.StringHelper;

public final class VersionHelper {
    private VersionHelper() {
    }

    public static String getJBangVersion() {
        try {
            File file;
            String homeDir = System.getenv("JBANG_HOME");
            String path = "/";
            if (homeDir == null || homeDir.isBlank()) {
                path = ".jbang/cache/";
                homeDir = CommandLineHelper.getHomeDir();
            }
            if ((file = new File(homeDir, path + "version.txt")).exists() && file.isFile()) {
                FileInputStream fis = new FileInputStream(file);
                String text = IOHelper.loadText((InputStream)fis);
                IOHelper.close((Closeable)fis);
                text = text.trim();
                return text;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static boolean isGE(String source, String target) {
        return VersionHelper.compare(source, target) >= 0;
    }

    public static boolean isLE(String source, String target) {
        return VersionHelper.compare(source, target) <= 0;
    }

    public static boolean isBetween(String source, String inclusive, String exclusive) {
        return VersionHelper.compare(source, inclusive) >= 0 && VersionHelper.compare(source, exclusive) < 0;
    }

    public static int compare(String source, String target) {
        Object s3;
        if (source == null || target == null || source.isBlank() || target.isBlank()) {
            return 0;
        }
        Object s1 = StringHelper.before((String)source, (String)".");
        Object s2 = StringHelper.after((String)source, (String)".");
        if (s1 == null) {
            s1 = StringHelper.before((String)source, (String)",");
            s2 = StringHelper.after((String)source, (String)",");
        }
        Object t1 = StringHelper.before((String)target, (String)".");
        Object t2 = StringHelper.after((String)target, (String)".");
        if (t1 == null) {
            t1 = StringHelper.before((String)target, (String)",");
            t2 = StringHelper.after((String)target, (String)",");
        }
        if ((s3 = StringHelper.after((String)s2, (String)".")) != null) {
            s2 = StringHelper.before((String)s2, (String)".");
        } else {
            s3 = "";
        }
        Object t3 = StringHelper.after((String)t2, (String)".");
        if (t3 != null) {
            t2 = StringHelper.before((String)t2, (String)".");
        } else {
            t3 = "";
        }
        if (s1 == null) {
            s1 = source;
        }
        if (s2 == null) {
            s2 = "";
        }
        if (t1 == null) {
            t1 = target;
        }
        if (t2 == null) {
            t2 = "";
        }
        if (((String)s1).length() < 2) {
            s1 = "0" + (String)s1;
        }
        if (((String)s2).length() < 2) {
            s2 = "0" + (String)s2;
        }
        if (((String)s2).length() < 2) {
            s2 = "0" + (String)s2;
        }
        if (((String)s3).length() < 2) {
            s3 = "0" + (String)s3;
        }
        if (((String)t1).length() < 2) {
            t1 = "0" + (String)t1;
        }
        if (((String)t2).length() < 2) {
            t2 = "0" + (String)t2;
        }
        if (((String)t3).length() < 2) {
            t3 = "0" + (String)t3;
        }
        String s = (String)s1 + (String)s2 + (String)s3;
        String t = (String)t1 + (String)t2 + (String)t3;
        return s.compareTo(t);
    }

    public static String extractCamelVersion() {
        return org.apache.camel.main.util.VersionHelper.extractCamelVersion();
    }

    public static String extractKameletsVersion() {
        return org.apache.camel.main.util.VersionHelper.extractKameletsVersion();
    }

    public static void setCamelVersion(String version) {
        org.apache.camel.main.util.VersionHelper.setCamelVersion((String)version);
    }
}

