/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.jbang.core.common;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.StringJoiner;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.OrderedProperties;
import org.apache.camel.util.StringHelper;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.config.Configurator;

public final class RuntimeUtil {
    private static final AtomicBoolean INIT_DONE = new AtomicBoolean();

    private RuntimeUtil() {
    }

    public static void configureLog(String level, boolean color, boolean json, boolean script, boolean export, String loggingConfigPath, List<String> loggingCategories) throws Exception {
        if (INIT_DONE.compareAndSet(false, true)) {
            long pid = ProcessHandle.current().pid();
            System.setProperty("pid", Long.toString(pid));
            if (loggingConfigPath != null) {
                Configurator.initialize((String)"CamelJBang", (String)("file://" + String.valueOf(Path.of(loggingConfigPath, new String[0]).toAbsolutePath())));
            } else if (loggingCategories != null && !loggingCategories.isEmpty()) {
                String name = "log4j2-no-color.properties";
                if (export) {
                    name = "log4j2-export.properties";
                } else if (script) {
                    name = "log4j2-script.properties";
                } else if (json) {
                    name = "log4j2-json.properties";
                } else if (color) {
                    name = "log4j2.properties";
                }
                InputStream is = RuntimeUtil.class.getClassLoader().getResourceAsStream(name);
                Object content = IOHelper.loadText((InputStream)is);
                IOHelper.close((Closeable)is);
                StringJoiner sj = new StringJoiner(System.lineSeparator());
                int i = 0;
                for (String lc : loggingCategories) {
                    String prefix = "custom" + i++;
                    String catName = StringHelper.before((String)lc, (String)"=", (String)"").trim();
                    String catLevel = StringHelper.after((String)lc, (String)"=", (String)"").trim();
                    if (catName.isEmpty() || catLevel.isEmpty()) continue;
                    sj.add("logger." + prefix + ".name=" + catName);
                    sj.add("logger." + prefix + ".level=" + catLevel);
                    if (!export && !script) {
                        sj.add("logger." + prefix + ".appenderRef.$1.ref=out");
                    }
                    sj.add("logger." + prefix + ".appenderRef.$2.ref=file");
                }
                content = (String)content + System.lineSeparator() + String.valueOf(sj);
                name = ".camel-jbang/log4j2.properties";
                Files.writeString(Paths.get(name, new String[0]), (CharSequence)content, new OpenOption[0]);
                Configurator.initialize((String)"CamelJBang", (String)Path.of(name, new String[0]).toAbsolutePath().toUri().toString());
            } else if (export) {
                Configurator.initialize((String)"CamelJBang", (String)"log4j2-export.properties");
            } else if (script) {
                Configurator.initialize((String)"CamelJBang", (String)"log4j2-script.properties");
            } else if (json) {
                Configurator.initialize((String)"CamelJBang", (String)"log4j2-json.properties");
            } else if (color) {
                Configurator.initialize((String)"CamelJBang", (String)"log4j2.properties");
            } else {
                Configurator.initialize((String)"CamelJBang", (String)"log4j2-no-color.properties");
            }
        }
        RuntimeUtil.setRootLoggingLevel(level);
    }

    public static void setRootLoggingLevel(String level) {
        if (level != null) {
            switch (level = level.toLowerCase()) {
                case "off": {
                    Configurator.setRootLevel((Level)Level.OFF);
                    break;
                }
                case "trace": {
                    Configurator.setRootLevel((Level)Level.TRACE);
                    break;
                }
                case "debug": {
                    Configurator.setRootLevel((Level)Level.DEBUG);
                    break;
                }
                case "info": {
                    Configurator.setRootLevel((Level)Level.INFO);
                    break;
                }
                case "warn": {
                    Configurator.setRootLevel((Level)Level.WARN);
                    break;
                }
                case "error": {
                    Configurator.setRootLevel((Level)Level.ERROR);
                    break;
                }
                case "fatal": {
                    Configurator.setRootLevel((Level)Level.FATAL);
                    break;
                }
                default: {
                    Configurator.setRootLevel((Level)Level.INFO);
                }
            }
        }
    }

    public static void loadProperties(Properties properties, File file) throws IOException {
        if (file.exists()) {
            try (FileInputStream fileInputStream = new FileInputStream(file);){
                properties.load(fileInputStream);
            }
        }
    }

    public static List<String> loadPropertiesLines(File file) throws IOException {
        if (!file.exists()) {
            return new ArrayList<String>();
        }
        ArrayList<String> lines = new ArrayList<String>();
        for (String line : Files.readAllLines(file.toPath())) {
            OrderedProperties prop = new OrderedProperties();
            prop.load(new StringReader(line));
            for (String key : prop.stringPropertyNames()) {
                String value = prop.getProperty(key);
                if (value == null) continue;
                lines.add(key + "=" + value);
            }
        }
        return lines;
    }

    public static List<String> getCommaSeparatedPropertyAsList(Properties props, String key, List<String> defaultValue) {
        String value = props.getProperty(key);
        return Optional.ofNullable(value).map(val -> Arrays.asList(val.split(","))).filter(tok -> !tok.isEmpty()).orElse(defaultValue);
    }

    public static String getDependencies(Properties properties) {
        String deps;
        String string = deps = properties != null ? properties.getProperty("camel.jbang.dependencies") : null;
        if (deps != null) {
            if (!(deps = deps.trim()).isEmpty() && deps.charAt(0) == ',') {
                deps = deps.substring(1);
            }
            if (!deps.isEmpty() && deps.charAt(deps.length() - 1) == ',') {
                deps = deps.substring(0, deps.lastIndexOf(","));
            }
        } else {
            deps = "";
        }
        return deps;
    }

    public static String[] getDependenciesAsArray(Properties properties) {
        String deps = RuntimeUtil.getDependencies(properties);
        return deps.isEmpty() ? new String[]{} : deps.split(",");
    }

    public static String getPid() {
        return String.valueOf(ProcessHandle.current().pid());
    }
}

