/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.jbang.core.common;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Supplier;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.catalog.DefaultCamelCatalog;
import org.apache.camel.dsl.jbang.core.commands.CamelJBangMain;
import org.apache.camel.dsl.jbang.core.common.CommandLineHelper;
import org.apache.camel.dsl.jbang.core.common.Plugin;
import org.apache.camel.dsl.jbang.core.common.PluginType;
import org.apache.camel.dsl.jbang.core.common.VersionHelper;
import org.apache.camel.impl.engine.DefaultClassResolver;
import org.apache.camel.impl.engine.DefaultFactoryFinder;
import org.apache.camel.main.download.DependencyDownloaderClassLoader;
import org.apache.camel.main.download.MavenDependencyDownloader;
import org.apache.camel.spi.ClassResolver;
import org.apache.camel.spi.FactoryFinder;
import org.apache.camel.support.ObjectHelper;
import org.apache.camel.tooling.maven.MavenGav;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.json.JsonObject;
import org.apache.camel.util.json.Jsoner;
import picocli.CommandLine;

public final class PluginHelper {
    public static final String PLUGIN_CONFIG = ".camel-jbang-plugins.json";
    private static final FactoryFinder FACTORY_FINDER = new DefaultFactoryFinder((ClassResolver)new DefaultClassResolver(), "META-INF/services/org/apache/camel/camel-jbang-plugin/");

    private PluginHelper() {
    }

    public static void addPlugins(CommandLine commandLine, CamelJBangMain main, String ... args) {
        String target;
        JsonObject config = PluginHelper.getPluginConfig();
        String string = target = args != null && args.length > 0 ? args[0] : null;
        if (config != null) {
            DefaultCamelCatalog catalog = new DefaultCamelCatalog();
            String version = catalog.getCatalogVersion();
            JsonObject plugins = (JsonObject)config.getMap("plugins");
            for (String pluginKey : plugins.keySet()) {
                Optional<Plugin> plugin;
                JsonObject properties = (JsonObject)plugins.getMap(pluginKey);
                String name = properties.getOrDefault((Object)"name", (Object)pluginKey).toString();
                String command = properties.getOrDefault((Object)"command", (Object)name).toString();
                String firstVersion = properties.getOrDefault((Object)"firstVersion", (Object)"").toString();
                if (target != null && !target.equals(command)) continue;
                if (!version.isBlank() && !firstVersion.isBlank()) {
                    PluginHelper.versionCheck(main, version, firstVersion, command);
                }
                if ((plugin = FACTORY_FINDER.newInstance("camel-jbang-plugin-" + command, Plugin.class)).isEmpty()) {
                    MavenGav mavenGav = PluginHelper.dependencyAsMavenGav(properties);
                    String group = PluginHelper.extractGroup(mavenGav, "org.apache.camel");
                    String depVersion = PluginHelper.extractVersion(mavenGav, version);
                    plugin = PluginHelper.downloadPlugin(command, main, depVersion, group);
                }
                if (plugin.isPresent()) {
                    ((Plugin)plugin.get()).customize(commandLine, main);
                    continue;
                }
                main.getOut().println("camel-jbang-plugin-" + command + " not found. Exit");
                main.quit(1);
            }
        }
    }

    private static MavenGav dependencyAsMavenGav(JsonObject properties) {
        Object dependency = properties.get((Object)"dependency");
        if (dependency == null) {
            return null;
        }
        return MavenGav.parseGav((String)dependency.toString());
    }

    private static void versionCheck(CamelJBangMain main, String version, String firstVersion, String command) {
        boolean accept;
        String source = version;
        if (source.endsWith("-SNAPSHOT")) {
            source = source.replace("-SNAPSHOT", "");
        }
        if (!(accept = VersionHelper.isGE(source, firstVersion))) {
            main.getOut().println("Cannot load plugin camel-jbang-plugin-" + command + " with version: " + version + " because plugin has first version: " + firstVersion + ". Exit");
            main.quit(1);
        }
    }

    private static Optional<Plugin> downloadPlugin(String command, CamelJBangMain main, String version, String group) {
        MavenDependencyDownloader downloader = new MavenDependencyDownloader();
        DependencyDownloaderClassLoader ddlcl = new DependencyDownloaderClassLoader(PluginHelper.class.getClassLoader());
        downloader.setClassLoader((ClassLoader)ddlcl);
        downloader.start();
        downloader.downloadDependencyWithParent("org.apache.camel:camel-jbang-parent:" + version, group, "camel-jbang-plugin-" + command, version);
        Optional<Plugin> instance = Optional.empty();
        InputStream in = null;
        String path = "META-INF/services/org/apache/camel/camel-jbang-plugin/camel-jbang-plugin-" + command;
        try {
            in = ddlcl.getResourceAsStream(path);
            if (in != null) {
                Properties prop = new Properties();
                prop.load(in);
                String pluginClassName = prop.getProperty("class");
                DefaultClassResolver resolver = new DefaultClassResolver();
                Class pluginClass = resolver.resolveClass(pluginClassName, (ClassLoader)ddlcl);
                instance = Optional.of((Plugin)Plugin.class.cast(ObjectHelper.newInstance((Class)pluginClass)));
            } else {
                String gav = String.join((CharSequence)":", group, "camel-jbang-plugin-" + command, version);
                main.getOut().printf(String.format("ERROR: Failed to read file %s in dependency %s%n", path, gav), new Object[0]);
            }
        }
        catch (IOException e) {
            throw new RuntimeCamelException(String.format("Failed to read the file %s.", path), (Throwable)e);
        }
        finally {
            downloader.stop();
            IOHelper.close((Closeable)in);
        }
        return instance;
    }

    public static JsonObject getOrCreatePluginConfig() {
        return Optional.ofNullable(PluginHelper.getPluginConfig()).orElseGet(PluginHelper::createPluginConfig);
    }

    private static JsonObject getPluginConfig() {
        block7: {
            JsonObject jsonObject;
            File f = new File(CommandLineHelper.getHomeDir(), PLUGIN_CONFIG);
            if (!f.exists()) break block7;
            FileInputStream fis = new FileInputStream(f);
            try {
                String text = IOHelper.loadText((InputStream)fis);
                jsonObject = (JsonObject)Jsoner.deserialize((String)text);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        fis.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            fis.close();
            return jsonObject;
        }
        return null;
    }

    public static JsonObject createPluginConfig() {
        File f = new File(CommandLineHelper.getHomeDir(), PLUGIN_CONFIG);
        JsonObject config = Jsoner.deserialize((String)"{ \"plugins\": {} }", (JsonObject)new JsonObject());
        try {
            Files.writeString(f.toPath(), (CharSequence)config.toJson(), StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);
        }
        catch (IOException e) {
            throw new RuntimeCamelException("Failed to create plugin configuration", (Throwable)e);
        }
        return config;
    }

    public static void savePluginConfig(JsonObject plugins) {
        File f = new File(CommandLineHelper.getHomeDir(), PLUGIN_CONFIG);
        try {
            Files.writeString(f.toPath(), (CharSequence)plugins.toJson(), StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);
        }
        catch (IOException e) {
            throw new RuntimeCamelException("Failed to save plugin configuration", (Throwable)e);
        }
    }

    public static void enable(PluginType pluginType) {
        JsonObject pluginConfig = PluginHelper.getOrCreatePluginConfig();
        JsonObject plugins = (JsonObject)pluginConfig.getMap("plugins");
        JsonObject kubePlugin = new JsonObject();
        kubePlugin.put((Object)"name", (Object)pluginType.getName());
        kubePlugin.put((Object)"command", (Object)pluginType.getCommand());
        kubePlugin.put((Object)"description", (Object)pluginType.getDescription());
        kubePlugin.put((Object)"firstVersion", (Object)pluginType.getFirstVersion());
        plugins.put((Object)pluginType.getName(), (Object)kubePlugin);
        PluginHelper.savePluginConfig(pluginConfig);
    }

    private static String doExtractInfo(MavenGav gav, String defaultInfo, Supplier<String> supplier) {
        String info;
        if (gav != null && (info = supplier.get()) != null) {
            return info;
        }
        return defaultInfo;
    }

    private static String extractGroup(MavenGav gav, String defaultGroup) {
        return PluginHelper.doExtractInfo(gav, defaultGroup, gav != null ? () -> ((MavenGav)gav).getGroupId() : () -> "");
    }

    private static String extractVersion(MavenGav gav, String defaultVersion) {
        return PluginHelper.doExtractInfo(gav, defaultVersion, gav != null ? () -> ((MavenGav)gav).getVersion() : () -> "");
    }
}

