/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.jbang.core.common;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.StringJoiner;
import org.apache.camel.util.AntPathMatcher;
import org.apache.camel.util.FileUtil;

public final class GitHubHelper {
    private GitHubHelper() {
    }

    public static String asGithubSingleUrl(String url) {
        url = url.substring(19);
        url = url.replaceFirst("/", ":");
        url = url.replaceFirst("/", ":");
        url = url.replaceFirst("tree/", "");
        url = url.replaceFirst("blob/", "");
        url = url.replaceFirst("/", ":");
        return "github:" + url;
    }

    public static void fetchGithubUrls(String url, StringJoiner all) throws Exception {
        GitHubHelper.doFetchGithubUrls(url, null, null, null, all);
    }

    public static void fetchGithubUrls(String url, StringJoiner routes, StringJoiner kamelets, StringJoiner properties) throws Exception {
        GitHubHelper.doFetchGithubUrls(url, routes, kamelets, properties, null);
    }

    private static void doFetchGithubUrls(String url, StringJoiner routes, StringJoiner kamelets, StringJoiner properties, StringJoiner all) throws Exception {
        String[] parts = ((String)(url = ((String)url).substring(19))).split("/");
        if (parts.length < 5) {
            return;
        }
        String org = parts[0];
        String repo = parts[1];
        String action = parts[2];
        String branch = parts[3];
        String wildcard = null;
        StringJoiner sj = new StringJoiner("/");
        for (int i = 4; i < parts.length; ++i) {
            if (i == parts.length - 1 && parts[i].contains("*")) {
                wildcard = parts[i];
                break;
            }
            sj.add(parts[i]);
        }
        String path = sj.toString();
        if ("tree".equals(action)) {
            url = "https://api.github.com/repos/" + org + "/" + repo + "/contents/" + path;
            if (!"main".equals(branch) && !"master".equals(branch)) {
                url = (String)url + "?ref=" + branch;
            }
        }
        GitHubHelper.resolveGithubAsRawFiles((String)url, wildcard, routes, kamelets, properties, all);
    }

    private static void resolveGithubAsRawFiles(String url, String wildcard, StringJoiner routes, StringJoiner kamelets, StringJoiner properties, StringJoiner all) throws Exception {
        HttpClient hc = HttpClient.newHttpClient();
        HttpResponse<String> res = hc.send(HttpRequest.newBuilder(new URI(url)).timeout(Duration.ofSeconds(20L)).build(), HttpResponse.BodyHandlers.ofString());
        if (res.statusCode() == 200) {
            ObjectMapper mapper = new ObjectMapper();
            JsonNode root = mapper.readTree(res.body());
            for (JsonNode c : root) {
                String u;
                String htmlUrl;
                String name = c.get("name").asText();
                String ext = FileUtil.onlyExt((String)name, (boolean)false);
                boolean match = wildcard == null || AntPathMatcher.INSTANCE.match(wildcard, name, false);
                if (!match) continue;
                if (kamelets != null && "kamelet.yaml".equalsIgnoreCase(ext)) {
                    htmlUrl = c.get("html_url").asText();
                    u = GitHubHelper.asGithubSingleUrl(htmlUrl);
                    kamelets.add(u);
                    continue;
                }
                if (properties != null && "properties".equalsIgnoreCase(ext)) {
                    htmlUrl = c.get("html_url").asText();
                    u = GitHubHelper.asGithubSingleUrl(htmlUrl);
                    properties.add(u);
                    continue;
                }
                if (routes != null) {
                    if (!"java".equalsIgnoreCase(ext) && !"xml".equalsIgnoreCase(ext) && !"yaml".equalsIgnoreCase(ext) && !"camel.yaml".equalsIgnoreCase(ext)) continue;
                    htmlUrl = c.get("html_url").asText();
                    u = GitHubHelper.asGithubSingleUrl(htmlUrl);
                    routes.add(u);
                    continue;
                }
                if (all == null) continue;
                htmlUrl = c.get("html_url").asText();
                u = GitHubHelper.asGithubSingleUrl(htmlUrl);
                all.add(u);
            }
        }
    }
}

