/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.jbang.core.common;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import java.util.function.Consumer;
import org.apache.camel.dsl.jbang.core.common.Printer;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.OrderedProperties;
import picocli.CommandLine;

public final class CommandLineHelper {
    private static volatile String homeDir = System.getProperty("user.home");
    public static final String USER_CONFIG = ".camel-jbang-user.properties";
    public static final String CAMEL_DIR = ".camel";
    public static final String CAMEL_JBANG_WORK_DIR = ".camel-jbang";

    private CommandLineHelper() {
    }

    public static void augmentWithUserConfiguration(CommandLine commandLine, String ... args) {
        File file = CommandLineHelper.getUserPropertyFile();
        if (file.isFile() && file.exists()) {
            commandLine.setDefaultValueProvider((CommandLine.IDefaultValueProvider)new CamelUserConfigDefaultValueProvider(file));
        }
    }

    public static void createPropertyFile() throws IOException {
        File file = CommandLineHelper.getUserPropertyFile();
        if (!file.exists()) {
            file.createNewFile();
        }
    }

    public static void loadProperties(Consumer<Properties> consumer) {
        File file = CommandLineHelper.getUserPropertyFile();
        if (file.isFile() && file.exists()) {
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(file);
                OrderedProperties prop = new OrderedProperties();
                prop.load(fis);
                consumer.accept((Properties)prop);
            }
            catch (Exception e) {
                try {
                    throw new RuntimeException("Cannot load user configuration: " + String.valueOf(file));
                }
                catch (Throwable throwable) {
                    IOHelper.close(fis);
                    throw throwable;
                }
            }
            IOHelper.close((Closeable)fis);
        }
    }

    public static void storeProperties(Properties properties, Printer printer) {
        block8: {
            File file = CommandLineHelper.getUserPropertyFile();
            if (file.isFile() && file.exists()) {
                try (FileOutputStream fos = new FileOutputStream(file);){
                    properties.store(fos, null);
                    break block8;
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
            }
            printer.println(".camel-jbang-user.properties does not exist");
        }
    }

    private static File getUserPropertyFile() {
        return new File(homeDir, USER_CONFIG);
    }

    public static String getHomeDir() {
        return homeDir;
    }

    public static void useHomeDir(String homeDir) {
        CommandLineHelper.homeDir = homeDir;
    }

    public static File getCamelDir() {
        return new File(homeDir, CAMEL_DIR);
    }

    public static File getWorkDir() {
        return new File(CAMEL_JBANG_WORK_DIR);
    }

    private static class CamelUserConfigDefaultValueProvider
    extends CommandLine.PropertiesDefaultProvider {
        public CamelUserConfigDefaultValueProvider(File file) {
            super(file);
        }
    }
}

