/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.jbang.core.commands.version;

import org.apache.camel.dsl.jbang.core.commands.CamelCommand;
import org.apache.camel.dsl.jbang.core.commands.CamelJBangMain;
import org.apache.camel.dsl.jbang.core.common.CommandLineHelper;
import org.apache.camel.dsl.jbang.core.common.RuntimeCompletionCandidates;
import org.apache.camel.dsl.jbang.core.common.RuntimeType;
import org.apache.camel.dsl.jbang.core.common.RuntimeTypeConverter;
import picocli.CommandLine;

@CommandLine.Command(name="set", description={"Set/change current Camel version"}, sortOptions=false, showDefaultValues=true)
public class VersionSet
extends CamelCommand {
    @CommandLine.Parameters(description={"Camel version"}, arity="0..1")
    String version;
    @CommandLine.Option(names={"--runtime"}, completionCandidates=RuntimeCompletionCandidates.class, converter={RuntimeTypeConverter.class}, description={"Runtime (${COMPLETION-CANDIDATES})"})
    RuntimeType runtime;
    @CommandLine.Option(names={"--repo", "--repos"}, description={"Maven repository for downloading the dependencies"})
    String repo;
    @CommandLine.Option(names={"--reset"}, description={"Reset by removing any custom version settings"})
    boolean reset;

    public VersionSet(CamelJBangMain main) {
        super(main);
    }

    @Override
    public Integer doCall() throws Exception {
        CommandLineHelper.createPropertyFile();
        CommandLineHelper.loadProperties(properties -> {
            if (this.reset) {
                properties.remove("camel-version");
                properties.remove("repos");
                properties.remove("runtime");
            } else {
                if (this.version != null) {
                    properties.put("camel-version", this.version);
                }
                if (this.repo != null) {
                    properties.put("repos", this.repo);
                }
                if (this.runtime != null) {
                    properties.put("runtime", this.runtime.runtime());
                }
            }
            CommandLineHelper.storeProperties(properties, this.printer());
        });
        return 0;
    }
}

