/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.jbang.core.commands.version;

import org.apache.camel.catalog.DefaultCamelCatalog;
import org.apache.camel.dsl.jbang.core.commands.CamelCommand;
import org.apache.camel.dsl.jbang.core.commands.CamelJBangMain;
import org.apache.camel.dsl.jbang.core.common.CommandLineHelper;
import org.apache.camel.dsl.jbang.core.common.VersionHelper;
import picocli.CommandLine;

@CommandLine.Command(name="get", description={"Displays current Camel version"}, sortOptions=false, showDefaultValues=true)
public class VersionGet
extends CamelCommand {
    public VersionGet(CamelJBangMain main) {
        super(main);
    }

    @Override
    public Integer doCall() throws Exception {
        String jv = VersionHelper.getJBangVersion();
        if (jv != null) {
            this.printer().println("JBang version: " + jv);
        }
        DefaultCamelCatalog catalog = new DefaultCamelCatalog();
        String v = catalog.getCatalogVersion();
        this.printer().println("Camel JBang version: " + v);
        CommandLineHelper.loadProperties(properties -> {
            String uv = properties.getProperty("camel-version");
            String kv = properties.getProperty("kamelets-version");
            String repos = properties.getProperty("repos");
            String runtime = properties.getProperty("runtime");
            if (uv != null || repos != null || runtime != null) {
                this.printer().println("User configuration:");
                if (uv != null) {
                    this.printer().println("    camel-version = " + uv);
                }
                if (kv != null) {
                    this.printer().println("    kamelets-version = " + kv);
                }
                if (runtime != null) {
                    this.printer().println("    runtime = " + runtime);
                }
                if (repos != null) {
                    this.printer().println("    repos = " + repos);
                }
            }
        });
        return 0;
    }
}

