/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.jbang.core.commands.process;

import java.io.File;
import java.util.List;
import org.apache.camel.dsl.jbang.core.commands.CamelJBangMain;
import org.apache.camel.dsl.jbang.core.commands.process.ProcessBaseCommand;
import org.apache.camel.dsl.jbang.core.common.CommandLineHelper;
import org.apache.camel.util.FileUtil;
import picocli.CommandLine;

@CommandLine.Command(name="stop", description={"Shuts down running Camel integrations"}, sortOptions=false, showDefaultValues=true)
public class StopProcess
extends ProcessBaseCommand {
    @CommandLine.Parameters(description={"Name or pid of running Camel integration(s)"}, arity="0..1")
    String name = "*";
    @CommandLine.Option(names={"--kill"}, description={"To force killing the process (SIGKILL)"})
    boolean kill;

    public StopProcess(CamelJBangMain main) {
        super(main);
    }

    @Override
    public Integer doCall() throws Exception {
        List<Long> pids = this.findPids(this.name);
        for (Long pid : pids) {
            File pidFile = new File(CommandLineHelper.getCamelDir(), Long.toString(pid));
            if (!pidFile.exists()) continue;
            this.printer().println("Shutting down Camel integration (PID: " + pid + ")");
            FileUtil.deleteFile((File)pidFile);
        }
        for (Long pid : pids) {
            if (!this.kill) continue;
            ProcessHandle.of(pid).ifPresent(ph -> {
                this.printer().println("Killing Camel integration (PID: " + pid + ")");
                ph.destroyForcibly();
            });
        }
        return 0;
    }
}

