/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.jbang.core.commands.process;

import com.github.freva.asciitable.AsciiTable;
import com.github.freva.asciitable.Column;
import com.github.freva.asciitable.HorizontalAlign;
import com.github.freva.asciitable.OverflowBehaviour;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.camel.dsl.jbang.core.commands.CamelJBangMain;
import org.apache.camel.dsl.jbang.core.commands.process.ProcessBaseCommand;
import org.apache.camel.dsl.jbang.core.common.ProcessHelper;
import org.apache.camel.util.TimeUtils;
import org.apache.camel.util.json.JsonArray;
import org.apache.camel.util.json.JsonObject;
import picocli.CommandLine;

@CommandLine.Command(name="transformer", description={"Get list of data type transformers"}, sortOptions=false, showDefaultValues=true)
public class ListTransformer
extends ProcessBaseCommand {
    @CommandLine.Parameters(description={"Name or pid of running Camel integration"}, arity="0..1")
    String name = "*";
    @CommandLine.Option(names={"--sort"}, completionCandidates=PidNameAgeTotalCompletionCandidates.class, description={"Sort by pid, name, age or total"}, defaultValue="pid")
    String sort;

    public ListTransformer(CamelJBangMain main) {
        super(main);
    }

    @Override
    public Integer doCall() throws Exception {
        ArrayList<Row> rows = new ArrayList<Row>();
        List<Long> pids = this.findPids(this.name);
        ProcessHandle.allProcesses().filter(ph -> pids.contains(ph.pid())).forEach(ph -> {
            JsonObject root = this.loadStatus(ph.pid());
            if (root != null) {
                JsonObject context = (JsonObject)root.get((Object)"context");
                JsonObject jo = (JsonObject)root.get((Object)"transformers");
                if (context != null && jo != null) {
                    JsonArray array = (JsonArray)jo.get((Object)"transformers");
                    for (int i = 0; i < array.size(); ++i) {
                        JsonObject o = (JsonObject)array.get(i);
                        Row row = new Row();
                        row.name = context.getString("name");
                        if ("CamelJBang".equals(row.name)) {
                            row.name = ProcessHelper.extractName(root, ph);
                        }
                        row.pid = Long.toString(ph.pid());
                        row.dataTypeName = o.getString("name");
                        row.dataTypeFrom = o.getString("from");
                        row.dataTypeTo = o.getString("to");
                        row.uptime = ListTransformer.extractSince(ph);
                        row.age = TimeUtils.printSince((long)row.uptime);
                        rows.add(row);
                    }
                }
            }
        });
        rows.sort(this::sortRow);
        if (!rows.isEmpty()) {
            this.printTable(rows);
        }
        return 0;
    }

    protected void printTable(List<Row> rows) {
        this.printer().println(AsciiTable.getTable((Character[])AsciiTable.NO_BORDERS, rows, Arrays.asList(new Column().header("PID").headerAlign(HorizontalAlign.CENTER).with(r -> r.pid), new Column().header("NAME").dataAlign(HorizontalAlign.LEFT).maxWidth(30, OverflowBehaviour.ELLIPSIS_RIGHT).with(r -> r.name), new Column().header("AGE").headerAlign(HorizontalAlign.CENTER).with(r -> r.age), new Column().header("DATA-TYPE").dataAlign(HorizontalAlign.LEFT).with(r -> r.dataTypeName), new Column().header("FROM").dataAlign(HorizontalAlign.LEFT).with(r -> r.dataTypeFrom), new Column().header("TO").dataAlign(HorizontalAlign.LEFT).with(r -> r.dataTypeTo))));
    }

    protected int sortRow(Row o1, Row o2) {
        String s = this.sort;
        int negate = 1;
        if (s.startsWith("-")) {
            s = s.substring(1);
            negate = -1;
        }
        switch (s) {
            case "pid": {
                return Long.compare(Long.parseLong(o1.pid), Long.parseLong(o2.pid)) * negate;
            }
            case "name": {
                return o1.name.compareToIgnoreCase(o2.name) * negate;
            }
            case "age": {
                return Long.compare(o1.uptime, o2.uptime) * negate;
            }
        }
        return 0;
    }

    static class Row {
        String pid;
        String name;
        long uptime;
        String age;
        String dataTypeName;
        String dataTypeFrom;
        String dataTypeTo;

        Row() {
        }
    }

    public static class PidNameAgeTotalCompletionCandidates
    implements Iterable<String> {
        @Override
        public Iterator<String> iterator() {
            return List.of("pid", "name", "age", "total").iterator();
        }
    }
}

