/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.jbang.core.commands.process;

import com.github.freva.asciitable.AsciiTable;
import com.github.freva.asciitable.Column;
import com.github.freva.asciitable.HorizontalAlign;
import com.github.freva.asciitable.OverflowBehaviour;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.camel.dsl.jbang.core.commands.CamelJBangMain;
import org.apache.camel.dsl.jbang.core.commands.process.ProcessWatchCommand;
import org.apache.camel.dsl.jbang.core.common.CamelCommandHelper;
import org.apache.camel.dsl.jbang.core.common.PidNameAgeCompletionCandidates;
import org.apache.camel.dsl.jbang.core.common.ProcessHelper;
import org.apache.camel.util.TimeUtils;
import org.apache.camel.util.json.JsonObject;
import org.apache.camel.util.json.Jsoner;
import picocli.CommandLine;

@CommandLine.Command(name="ps", description={"List running Camel integrations"}, sortOptions=false, showDefaultValues=true)
public class ListProcess
extends ProcessWatchCommand {
    @CommandLine.Option(names={"--sort"}, completionCandidates=PidNameAgeCompletionCandidates.class, description={"Sort by pid, name or age"}, defaultValue="pid")
    String sort;
    @CommandLine.Option(names={"--pid"}, description={"List only pid in the output"})
    boolean pid;
    @CommandLine.Option(names={"--json"}, description={"Output in JSON Format"})
    boolean jsonOutput;

    public ListProcess(CamelJBangMain main) {
        super(main);
    }

    @Override
    protected Integer doProcessWatchCall() throws Exception {
        ArrayList rows = new ArrayList();
        List<Long> pids = this.findPids("*");
        ProcessHandle.allProcesses().filter(ph -> pids.contains(ph.pid())).forEach(ph -> {
            JsonObject root = this.loadStatus(ph.pid());
            if (root != null) {
                Row row = new Row();
                row.pid = Long.toString(ph.pid());
                row.uptime = ListProcess.extractSince(ph);
                row.ago = TimeUtils.printSince((long)row.uptime);
                JsonObject context = (JsonObject)root.get((Object)"context");
                if (context == null) {
                    return;
                }
                row.name = context.getString("name");
                if ("CamelJBang".equals(row.name)) {
                    row.name = ProcessHelper.extractName(root, ph);
                }
                row.state = context.getInteger("phase");
                JsonObject hc = (JsonObject)root.get((Object)"healthChecks");
                boolean rdy = hc != null && hc.getBoolean("ready") != false;
                row.ready = rdy ? "1/1" : "0/1";
                Map stats = context.getMap("statistics");
                if (stats != null) {
                    row.total = stats.get("exchangesTotal").toString();
                    Object num = stats.get("remoteExchangesTotal");
                    if (num != null) {
                        row.totalRemote = num.toString();
                    }
                    row.failed = stats.get("exchangesFailed").toString();
                    num = stats.get("remoteExchangesFailed");
                    if (num != null) {
                        row.failedRemote = num.toString();
                    }
                    row.inflight = stats.get("exchangesInflight").toString();
                    num = stats.get("remoteExchangesInflight");
                    if (num != null) {
                        row.inflightRemote = num.toString();
                    }
                    if ((stats = (Map)stats.get("reload")) != null) {
                        stats = (Map)stats.get("lastError");
                    }
                    if (stats != null) {
                        row.reloadError = (String)stats.get("message");
                    }
                }
                rows.add(row);
            }
        });
        rows.sort(this::sortRow);
        if (!rows.isEmpty()) {
            if (this.pid) {
                if (this.jsonOutput) {
                    this.printer().println(Jsoner.serialize(rows.stream().map(row -> row.pid).collect(Collectors.toList())));
                } else {
                    rows.forEach(r -> this.printer().println(r.pid));
                }
            } else if (this.jsonOutput) {
                this.printer().println(Jsoner.serialize(rows.stream().map(row -> Map.of("pid", row.pid, "name", row.name, "ready", row.ready, "status", this.getStatus((Row)row), "age", row.ago, "total", this.getTotal((Row)row), "remote", this.getTotalRemote((Row)row), "fail", this.getFailed((Row)row), "inflight", this.getInflight((Row)row))).collect(Collectors.toList())));
            } else {
                this.printer().println(AsciiTable.getTable((Character[])AsciiTable.NO_BORDERS, rows, Arrays.asList(new Column().header("PID").headerAlign(HorizontalAlign.CENTER).with(r -> r.pid), new Column().header("NAME").dataAlign(HorizontalAlign.LEFT).maxWidth(40, OverflowBehaviour.ELLIPSIS_RIGHT).with(r -> r.name), new Column().header("READY").dataAlign(HorizontalAlign.CENTER).with(r -> r.ready), new Column().header("STATUS").headerAlign(HorizontalAlign.CENTER).with(this::getStatus), new Column().header("AGE").headerAlign(HorizontalAlign.CENTER).with(r -> r.ago), new Column().header("TOTAL").with(this::getTotal), new Column().header("REMOTE").with(this::getTotalRemote), new Column().header("FAIL").with(this::getFailed), new Column().header("INFLIGHT").with(this::getInflight), new Column().header("").headerAlign(HorizontalAlign.LEFT).dataAlign(HorizontalAlign.LEFT).maxWidth(70, OverflowBehaviour.NEWLINE).with(this::getDescription))));
            }
        }
        return 0;
    }

    private String getStatus(Row r) {
        if (r.reloadError != null) {
            return "Error";
        }
        return CamelCommandHelper.extractState(r.state);
    }

    private String getDescription(Row r) {
        if (r.reloadError != null) {
            return "Reload failed due to: " + r.reloadError;
        }
        return null;
    }

    private String getTotal(Row r) {
        return r.total;
    }

    private String getTotalRemote(Row r) {
        if (r.totalRemote != null) {
            return r.totalRemote;
        }
        return "";
    }

    private String getFailed(Row r) {
        if (r.failedRemote != null) {
            return r.failedRemote + "/" + r.failed;
        }
        return r.failed;
    }

    private String getInflight(Row r) {
        if (r.inflightRemote != null) {
            return r.inflightRemote + "/" + r.inflight;
        }
        return r.inflight;
    }

    protected int sortRow(Row o1, Row o2) {
        String s = this.sort;
        int negate = 1;
        if (s.startsWith("-")) {
            s = s.substring(1);
            negate = -1;
        }
        switch (s) {
            case "pid": {
                return Long.compare(Long.parseLong(o1.pid), Long.parseLong(o2.pid)) * negate;
            }
            case "name": {
                return o1.name.compareToIgnoreCase(o2.name) * negate;
            }
            case "age": {
                return Long.compare(o1.uptime, o2.uptime) * negate;
            }
        }
        return 0;
    }

    private static class Row {
        String pid;
        String name;
        String ready;
        int state;
        String ago;
        long uptime;
        String total;
        String totalRemote;
        String failed;
        String failedRemote;
        String inflight;
        String inflightRemote;
        String reloadError;

        private Row() {
        }
    }
}

