/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.jbang.core.commands.process;

import com.github.freva.asciitable.AsciiTable;
import com.github.freva.asciitable.Column;
import com.github.freva.asciitable.HorizontalAlign;
import com.github.freva.asciitable.OverflowBehaviour;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.camel.dsl.jbang.core.commands.CamelJBangMain;
import org.apache.camel.dsl.jbang.core.commands.process.ProcessWatchCommand;
import org.apache.camel.dsl.jbang.core.common.PidNameAgeCompletionCandidates;
import org.apache.camel.dsl.jbang.core.common.ProcessHelper;
import org.apache.camel.support.PatternHelper;
import org.apache.camel.util.TimeUtils;
import org.apache.camel.util.json.JsonArray;
import org.apache.camel.util.json.JsonObject;
import picocli.CommandLine;

@CommandLine.Command(name="consumer", description={"Get status of Camel consumers"}, sortOptions=false, showDefaultValues=true)
public class ListConsumer
extends ProcessWatchCommand {
    @CommandLine.Parameters(description={"Name or pid of running Camel integration"}, arity="0..1")
    String name = "*";
    @CommandLine.Option(names={"--sort"}, completionCandidates=PidNameAgeCompletionCandidates.class, description={"Sort by pid, name or age"}, defaultValue="pid")
    String sort;
    @CommandLine.Option(names={"--limit"}, description={"Filter consumers by limiting to the given number of rows"})
    int limit;
    @CommandLine.Option(names={"--filter"}, description={"Filter consumers by URI"})
    String filter;
    @CommandLine.Option(names={"--scheduled"}, description={"Filter consumer to only show scheduled based consumers"})
    boolean scheduled;
    @CommandLine.Option(names={"--short-uri"}, description={"List endpoint URI without query parameters (short)"})
    boolean shortUri;
    @CommandLine.Option(names={"--wide-uri"}, description={"List endpoint URI in full details"})
    boolean wideUri;

    public ListConsumer(CamelJBangMain main) {
        super(main);
    }

    @Override
    public Integer doProcessWatchCall() throws Exception {
        ArrayList<Row> rows = new ArrayList<Row>();
        if (this.filter != null && !this.filter.endsWith("*")) {
            this.filter = this.filter + "*";
        }
        List<Long> pids = this.findPids(this.name);
        ProcessHandle.allProcesses().filter(ph -> pids.contains(ph.pid())).forEach(ph -> {
            JsonObject root = this.loadStatus(ph.pid());
            if (root != null) {
                JsonObject context = (JsonObject)root.get((Object)"context");
                JsonObject jo = (JsonObject)root.get((Object)"consumers");
                if (context != null && jo != null) {
                    JsonArray array = (JsonArray)jo.get((Object)"consumers");
                    for (int i = 0; i < array.size(); ++i) {
                        JsonObject o = (JsonObject)array.get(i);
                        Row row = new Row();
                        row.name = context.getString("name");
                        if ("CamelJBang".equals(row.name)) {
                            row.name = ProcessHelper.extractName(root, ph);
                        }
                        row.pid = Long.toString(ph.pid());
                        row.id = o.getString("id");
                        row.uri = o.getString("uri");
                        row.state = o.getString("state");
                        row.className = o.getString("class");
                        row.hostedService = o.getBooleanOrDefault("hostedService", false);
                        row.scheduled = o.getBoolean("scheduled");
                        row.inflight = o.getInteger("inflight");
                        row.polling = o.getBoolean("polling");
                        row.totalCounter = o.getLong("totalCounter");
                        row.delay = o.getLong("delay");
                        row.period = o.getLong("period");
                        row.uptime = ListConsumer.extractSince(ph);
                        row.age = TimeUtils.printSince((long)row.uptime);
                        Map stats = o.getMap("statistics");
                        if (stats != null) {
                            long time;
                            Object last = stats.get("lastCreatedExchangeTimestamp");
                            if (last != null) {
                                time = Long.parseLong(last.toString());
                                row.sinceLastStarted = TimeUtils.printSince((long)time);
                            }
                            if ((last = stats.get("lastCompletedExchangeTimestamp")) != null) {
                                time = Long.parseLong(last.toString());
                                row.sinceLastCompleted = TimeUtils.printSince((long)time);
                            }
                            if ((last = stats.get("lastFailedExchangeTimestamp")) != null) {
                                time = Long.parseLong(last.toString());
                                row.sinceLastFailed = TimeUtils.printSince((long)time);
                            }
                        }
                        boolean add = true;
                        if (this.filter != null) {
                            String f = this.filter;
                            boolean negate = this.filter.startsWith("-");
                            if (negate) {
                                f = f.substring(1);
                            }
                            boolean match = PatternHelper.matchPattern((String)row.uri, (String)f);
                            if (negate) {
                                boolean bl = match = !match;
                            }
                            if (!match) {
                                add = false;
                            }
                        }
                        if (this.scheduled && !row.scheduled) {
                            add = false;
                        }
                        if (this.limit > 0 && rows.size() >= this.limit) {
                            add = false;
                        }
                        if (!add) continue;
                        rows.add(row);
                    }
                }
            }
        });
        rows.sort(this::sortRow);
        if (!rows.isEmpty()) {
            this.printTable(rows);
        }
        return 0;
    }

    protected void printTable(List<Row> rows) {
        this.printer().println(AsciiTable.getTable((Character[])AsciiTable.NO_BORDERS, rows, Arrays.asList(new Column().header("PID").headerAlign(HorizontalAlign.CENTER).with(r -> r.pid), new Column().header("NAME").dataAlign(HorizontalAlign.LEFT).maxWidth(30, OverflowBehaviour.ELLIPSIS_RIGHT).with(r -> r.name), new Column().header("AGE").headerAlign(HorizontalAlign.CENTER).with(r -> r.age), new Column().header("ID").dataAlign(HorizontalAlign.LEFT).maxWidth(20, OverflowBehaviour.ELLIPSIS_RIGHT).with(r -> r.id), new Column().header("STATE").headerAlign(HorizontalAlign.CENTER).with(this::getState), new Column().header("TYPE").dataAlign(HorizontalAlign.LEFT).maxWidth(20, OverflowBehaviour.ELLIPSIS_RIGHT).with(this::getType), new Column().header("INFLIGHT").with(r -> Integer.toString(r.inflight)), new Column().header("POLL").with(this::getTotal), new Column().header("PERIOD").visible(this.scheduled).with(this::getPeriod), new Column().header("SINCE-LAST").with(this::getSinceLast), new Column().header("URI").visible(!this.wideUri).dataAlign(HorizontalAlign.LEFT).maxWidth(90, OverflowBehaviour.ELLIPSIS_RIGHT).with(this::getUri), new Column().header("URI").visible(this.wideUri).dataAlign(HorizontalAlign.LEFT).maxWidth(140, OverflowBehaviour.NEWLINE).with(this::getUri))));
    }

    private String getUri(Row r) {
        int pos;
        String u = r.uri;
        if (this.shortUri && (pos = u.indexOf(63)) > 0) {
            u = u.substring(0, pos);
        }
        return u;
    }

    private String getState(Row r) {
        if (r.polling != null && r.polling.booleanValue()) {
            return "Polling";
        }
        return r.state;
    }

    private String getType(Row r) {
        String s = r.className;
        if (s.endsWith("Consumer")) {
            s = s.substring(0, s.length() - 8);
        }
        return s;
    }

    private String getTotal(Row r) {
        if (r.totalCounter != null) {
            return String.valueOf(r.totalCounter);
        }
        return "";
    }

    private String getPeriod(Row r) {
        if (r.period != null) {
            return String.valueOf(r.period);
        }
        if (r.delay != null) {
            return String.valueOf(r.delay);
        }
        return "";
    }

    protected String getSinceLast(Row r) {
        String s1 = r.sinceLastStarted != null ? r.sinceLastStarted : "-";
        String s2 = r.sinceLastCompleted != null ? r.sinceLastCompleted : "-";
        String s3 = r.sinceLastFailed != null ? r.sinceLastFailed : "-";
        return s1 + "/" + s2 + "/" + s3;
    }

    protected int sortRow(Row o1, Row o2) {
        String s = this.sort;
        int negate = 1;
        if (s.startsWith("-")) {
            s = s.substring(1);
            negate = -1;
        }
        switch (s) {
            case "pid": {
                return Long.compare(Long.parseLong(o1.pid), Long.parseLong(o2.pid)) * negate;
            }
            case "name": {
                return o1.name.compareToIgnoreCase(o2.name) * negate;
            }
            case "age": {
                return Long.compare(o1.uptime, o2.uptime) * negate;
            }
        }
        return 0;
    }

    static class Row {
        String pid;
        String name;
        long uptime;
        String age;
        String id;
        String uri;
        String state;
        String className;
        boolean hostedService;
        boolean scheduled;
        int inflight;
        Boolean polling;
        Long totalCounter;
        Long delay;
        Long period;
        String sinceLastStarted;
        String sinceLastCompleted;
        String sinceLastFailed;

        Row() {
        }
    }
}

