/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.jbang.core.commands.process;

import com.github.freva.asciitable.AsciiTable;
import com.github.freva.asciitable.Column;
import com.github.freva.asciitable.HorizontalAlign;
import com.github.freva.asciitable.OverflowBehaviour;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.camel.dsl.jbang.core.commands.CamelJBangMain;
import org.apache.camel.dsl.jbang.core.commands.process.ProcessWatchCommand;
import org.apache.camel.dsl.jbang.core.common.CamelCommandHelper;
import org.apache.camel.dsl.jbang.core.common.ProcessHelper;
import org.apache.camel.dsl.jbang.core.common.VersionHelper;
import org.apache.camel.util.TimeUtils;
import org.apache.camel.util.json.JsonObject;
import picocli.CommandLine;

@CommandLine.Command(name="context", description={"Top status of Camel integrations"}, sortOptions=false, showDefaultValues=true)
public class CamelContextTop
extends ProcessWatchCommand {
    @CommandLine.Parameters(description={"Name or pid of running Camel integration"}, arity="0..1")
    String name = "*";
    @CommandLine.Option(names={"--sort"}, completionCandidates=PidNameMemAgeCompletionCandidates.class, description={"Sort by pid, name, mem, or age"}, defaultValue="mem")
    String sort;

    public CamelContextTop(CamelJBangMain main) {
        super(main);
    }

    @Override
    public Integer doProcessWatchCall() throws Exception {
        ArrayList rows = new ArrayList();
        List<Long> pids = this.findPids(this.name);
        ProcessHandle.allProcesses().filter(ph -> pids.contains(ph.pid())).forEach(ph -> {
            JsonObject root = this.loadStatus(ph.pid());
            if (root != null) {
                JsonObject gc;
                JsonObject cl;
                JsonObject threads;
                JsonObject mem;
                Row row = new Row();
                rows.add(row);
                JsonObject context = (JsonObject)root.get((Object)"context");
                if (context == null) {
                    return;
                }
                row.name = context.getString("name");
                if ("CamelJBang".equals(row.name)) {
                    row.name = ProcessHelper.extractName(root, ph);
                }
                row.pid = Long.toString(ph.pid());
                row.uptime = CamelContextTop.extractSince(ph);
                row.ago = TimeUtils.printSince((long)row.uptime);
                JsonObject runtime = (JsonObject)root.get((Object)"runtime");
                row.platform = this.extractPlatform((ProcessHandle)ph, runtime);
                row.platformVersion = this.extractPlatformVersion(row.platform, runtime != null ? runtime.getString("platformVersion") : null);
                row.javaVersion = runtime != null ? runtime.getString("javaVersion") : null;
                row.state = context.getInteger("phase");
                row.camelVersion = context.getString("version");
                Map stats = context.getMap("statistics");
                if (stats != null) {
                    Object load;
                    Object thp = stats.get("exchangesThroughput");
                    if (thp != null) {
                        row.throughput = thp.toString();
                    }
                    if ((load = stats.get("load01")) != null) {
                        row.load01 = load.toString();
                    }
                    if ((load = stats.get("load05")) != null) {
                        row.load05 = load.toString();
                    }
                    if ((load = stats.get("load15")) != null) {
                        row.load15 = load.toString();
                    }
                }
                if ((mem = (JsonObject)root.get((Object)"memory")) != null) {
                    row.heapMemUsed = mem.getLong("heapMemoryUsed");
                    row.heapMemCommitted = mem.getLong("heapMemoryCommitted");
                    row.heapMemMax = mem.getLong("heapMemoryMax");
                    row.nonHeapMemUsed = mem.getLong("nonHeapMemoryUsed");
                    row.nonHeapMemCommitted = mem.getLong("nonHeapMemoryCommitted");
                }
                if ((threads = (JsonObject)root.get((Object)"threads")) != null) {
                    row.threadCount = threads.getInteger("threadCount");
                    row.peakThreadCount = threads.getInteger("peakThreadCount");
                }
                if ((cl = (JsonObject)root.get((Object)"classLoading")) != null) {
                    row.loadedClassCount = cl.getInteger("loadedClassCount");
                    row.totalLoadedClassCount = cl.getLong("totalLoadedClassCount");
                }
                if ((gc = (JsonObject)root.get((Object)"gc")) != null) {
                    row.gcCount = gc.getLong("collectionCount");
                    row.gcTime = gc.getLong("collectionTime");
                }
            }
        });
        rows.sort(this::sortRow);
        if (!rows.isEmpty()) {
            this.printer().println(AsciiTable.getTable((Character[])AsciiTable.NO_BORDERS, rows, Arrays.asList(new Column().header("PID").headerAlign(HorizontalAlign.CENTER).with(r -> r.pid), new Column().header("NAME").dataAlign(HorizontalAlign.LEFT).maxWidth(30, OverflowBehaviour.ELLIPSIS_RIGHT).with(r -> r.name), new Column().header("JAVA").dataAlign(HorizontalAlign.LEFT).with(this::getJavaVersion), new Column().header("CAMEL").dataAlign(HorizontalAlign.LEFT).with(r -> r.camelVersion), new Column().header("PLATFORM").dataAlign(HorizontalAlign.LEFT).with(this::getPlatform), new Column().header("STATUS").headerAlign(HorizontalAlign.CENTER).with(r -> CamelCommandHelper.extractState(r.state)), new Column().header("AGE").headerAlign(HorizontalAlign.CENTER).with(r -> r.ago), new Column().header("LOAD").headerAlign(HorizontalAlign.CENTER).dataAlign(HorizontalAlign.CENTER).with(this::getLoad), new Column().header("HEAP").headerAlign(HorizontalAlign.CENTER).with(this::getHeapMemory), new Column().header("NON-HEAP").headerAlign(HorizontalAlign.CENTER).with(this::getNonHeapMemory), new Column().header("GC").headerAlign(HorizontalAlign.CENTER).with(this::getGC), new Column().header("THREADS").headerAlign(HorizontalAlign.CENTER).with(this::getThreads))));
        }
        return 0;
    }

    private String extractPlatform(ProcessHandle ph, JsonObject runtime) {
        String cl;
        String answer;
        String string = answer = runtime != null ? runtime.getString("platform") : null;
        if ("Camel".equals(answer) && (cl = ph.info().commandLine().orElse("")).contains("main.CamelJBang run")) {
            answer = "JBang";
        }
        return answer;
    }

    private String extractPlatformVersion(String platform, String platformVersion) {
        if (platformVersion == null && "JBang".equals(platform)) {
            platformVersion = VersionHelper.getJBangVersion();
        }
        return platformVersion;
    }

    protected int sortRow(Row o1, Row o2) {
        String s = this.sort;
        int negate = 1;
        if (s.startsWith("-")) {
            s = s.substring(1);
            negate = -1;
        }
        switch (s) {
            case "pid": {
                return Long.compare(Long.parseLong(o1.pid), Long.parseLong(o2.pid)) * negate;
            }
            case "name": {
                return o1.name.compareToIgnoreCase(o2.name) * negate;
            }
            case "mem": {
                return Long.compare(o1.heapMemUsed, o2.heapMemUsed) * negate * -1;
            }
            case "age": {
                return Long.compare(o1.uptime, o2.uptime) * negate;
            }
        }
        return 0;
    }

    protected String getThroughput(Row r) {
        String s = r.throughput;
        if (s == null || s.isEmpty()) {
            s = "";
        }
        return s;
    }

    private String getPlatform(Row r) {
        if (r.platformVersion != null) {
            return r.platform + " v" + r.platformVersion;
        }
        return r.platform;
    }

    private String getHeapMemory(Row r) {
        return CamelContextTop.asMegaBytesOneDigit(r.heapMemUsed) + "/" + CamelContextTop.asMegaBytesOneDigit(r.heapMemCommitted) + "/" + CamelContextTop.asMegaBytesOneDigit(r.heapMemMax) + " MB";
    }

    private String getNonHeapMemory(Row r) {
        return CamelContextTop.asMegaBytesOneDigit(r.nonHeapMemUsed) + "/" + CamelContextTop.asMegaBytesOneDigit(r.nonHeapMemCommitted) + " MB";
    }

    private String getThreads(Row r) {
        return r.threadCount + "/" + r.peakThreadCount;
    }

    private String getGC(Row r) {
        if (r.gcTime <= 0L) {
            return "";
        }
        return String.format("%s (%d)", TimeUtils.printDuration((long)r.gcTime, (boolean)true), r.gcCount);
    }

    private String getJavaVersion(Row r) {
        String v = r.javaVersion;
        if (v == null) {
            v = "";
        }
        for (int i = 0; i < v.length(); ++i) {
            char ch = v.charAt(i);
            if (Character.isDigit(ch) || ch == '.') continue;
            return v.substring(0, i);
        }
        return v;
    }

    private String getLoad(Row r) {
        String s3;
        String s1 = r.load01 != null ? r.load01 : "-";
        String s2 = r.load05 != null ? r.load05 : "-";
        String string = s3 = r.load15 != null ? r.load15 : "-";
        if ("0.00".equals(s1)) {
            s1 = "-";
        }
        if ("0.00".equals(s2)) {
            s2 = "-";
        }
        if ("0.00".equals(s3)) {
            s3 = "-";
        }
        if (s1.equals("-") && s2.equals("-") && s3.equals("-")) {
            return "0/0/0";
        }
        return s1 + "/" + s2 + "/" + s3;
    }

    private static long asMegaBytesOneDigit(long bytes) {
        return bytes / 1000L / 1000L;
    }

    private static class Row {
        String pid;
        String platform;
        String platformVersion;
        String camelVersion;
        String javaVersion;
        String name;
        int state;
        String ago;
        long uptime;
        String throughput;
        String load01;
        String load05;
        String load15;
        long heapMemUsed;
        long heapMemCommitted;
        long heapMemMax;
        long nonHeapMemUsed;
        long nonHeapMemCommitted;
        int threadCount;
        int peakThreadCount;
        int loadedClassCount;
        long totalLoadedClassCount;
        long gcCount;
        long gcTime;

        private Row() {
        }
    }

    public static class PidNameMemAgeCompletionCandidates
    implements Iterable<String> {
        @Override
        public Iterator<String> iterator() {
            return List.of("pid", "name", "mem", "age").iterator();
        }
    }
}

