/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.jbang.core.commands.plugin;

import org.apache.camel.dsl.jbang.core.commands.CamelJBangMain;
import org.apache.camel.dsl.jbang.core.commands.plugin.PluginBaseCommand;
import org.apache.camel.util.json.JsonObject;
import picocli.CommandLine;

@CommandLine.Command(name="delete", description={"Removes a plugin."}, sortOptions=false, showDefaultValues=true)
public class PluginDelete
extends PluginBaseCommand {
    @CommandLine.Parameters(description={"The Camel plugin to remove."}, paramLabel="<plugin>")
    String name;

    public PluginDelete(CamelJBangMain main) {
        super(main);
    }

    @Override
    public Integer doCall() throws Exception {
        JsonObject pluginConfig = this.loadConfig();
        JsonObject plugins = (JsonObject)pluginConfig.getMap("plugins");
        Object plugin = plugins.remove((Object)this.name);
        if (plugin != null) {
            this.printer().printf("Plugin %s removed%n", this.name);
            this.saveConfig(pluginConfig);
        } else {
            this.printer().printf("Plugin %s not found in configuration%n", this.name);
        }
        return 0;
    }
}

