/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.jbang.core.commands.plugin;

import java.util.Optional;
import org.apache.camel.catalog.DefaultCamelCatalog;
import org.apache.camel.dsl.jbang.core.commands.CamelJBangMain;
import org.apache.camel.dsl.jbang.core.commands.plugin.PluginBaseCommand;
import org.apache.camel.dsl.jbang.core.common.PluginType;
import org.apache.camel.util.json.JsonObject;
import picocli.CommandLine;

@CommandLine.Command(name="add", description={"Add new plugin."}, sortOptions=false, showDefaultValues=true)
public class PluginAdd
extends PluginBaseCommand {
    @CommandLine.Parameters(description={"The Camel plugin to add."}, paramLabel="<name>")
    String name;
    @CommandLine.Option(names={"--command"}, description={"The command that the plugin uses."})
    String command;
    @CommandLine.Option(names={"--description"}, description={"A short description of the plugin."})
    String description;
    @CommandLine.Option(names={"--artifactId"}, description={"Maven artifactId."})
    String artifactId;
    @CommandLine.Option(names={"--groupId"}, defaultValue="org.apache.camel", description={"Maven groupId."})
    String groupId = "org.apache.camel";
    @CommandLine.Option(names={"--version"}, defaultValue="${camel-version}", description={"Maven artifact version."})
    String version;
    @CommandLine.Option(names={"--first-version"}, defaultValue="${camel-version}", description={"First version of this plugin."})
    String firstVersion;
    @CommandLine.Option(names={"--gav"}, description={"Maven group and artifact coordinates."})
    String gav;

    public PluginAdd(CamelJBangMain main) {
        super(main);
    }

    @Override
    public Integer doCall() throws Exception {
        JsonObject pluginConfig = this.loadConfig();
        JsonObject plugins = (JsonObject)pluginConfig.getMap("plugins");
        Optional<PluginType> camelPlugin = PluginType.findByName(this.name);
        if (camelPlugin.isPresent()) {
            if (this.command == null) {
                this.command = camelPlugin.get().getCommand();
            }
            if (this.description == null) {
                this.description = camelPlugin.get().getDescription();
            }
            if (this.firstVersion == null) {
                this.firstVersion = camelPlugin.get().getFirstVersion();
            }
        }
        if (this.command == null) {
            this.command = this.name;
        }
        if (this.firstVersion == null) {
            this.firstVersion = this.version;
        }
        JsonObject plugin = new JsonObject();
        plugin.put((Object)"name", (Object)this.name);
        plugin.put((Object)"command", (Object)this.command);
        if (this.firstVersion != null) {
            plugin.put((Object)"firstVersion", (Object)this.firstVersion);
        }
        plugin.put((Object)"description", (Object)(this.description != null ? this.description : "Plugin %s called with command %s".formatted(this.name, this.command)));
        if (this.gav == null && this.groupId != null && this.artifactId != null) {
            if (this.version == null) {
                DefaultCamelCatalog catalog = new DefaultCamelCatalog();
                this.version = catalog.getCatalogVersion();
            }
            this.gav = "%s:%s:%s".formatted(this.groupId, this.artifactId, this.version);
        }
        if (this.gav != null) {
            plugin.put((Object)"dependency", (Object)this.gav);
        }
        plugins.put((Object)this.name, (Object)plugin);
        this.saveConfig(pluginConfig);
        return 0;
    }
}

