/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.jbang.core.commands.infra;

import java.io.File;
import java.util.List;
import org.apache.camel.dsl.jbang.core.commands.CamelJBangMain;
import org.apache.camel.dsl.jbang.core.commands.infra.InfraBaseCommand;
import org.apache.camel.dsl.jbang.core.common.CommandLineHelper;
import org.apache.camel.util.FileUtil;
import picocli.CommandLine;

@CommandLine.Command(name="stop", description={"Stop an external service"})
public class InfraStop
extends InfraBaseCommand {
    @CommandLine.Parameters(description={"Service name"}, arity="1")
    private List<String> serviceName;

    public InfraStop(CamelJBangMain main) {
        super(main);
    }

    @Override
    public Integer doCall() throws Exception {
        String serviceToStop = this.serviceName.get(0);
        boolean serviceStopped = false;
        String pid = null;
        for (File pidFile : CommandLineHelper.getCamelDir().listFiles((dir, name) -> name.startsWith("infra-" + serviceToStop + "-"))) {
            String name2 = pidFile.getName();
            pid = name2.substring(name2.lastIndexOf("-") + 1, name2.lastIndexOf(46));
            FileUtil.deleteFile((File)pidFile);
            serviceStopped = true;
        }
        if (!serviceStopped) {
            this.printer().println("No Camel Infrastructure found with name " + serviceToStop + " found.");
            return -1;
        }
        this.printer().println("Shutting down service " + serviceToStop + " (PID: " + pid + ")");
        ProcessHandle.of(Long.valueOf(pid)).ifPresent(ProcessHandle::destroy);
        return 0;
    }
}

