/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.jbang.core.commands.infra;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Scanner;
import org.apache.camel.dsl.jbang.core.commands.CamelJBangMain;
import org.apache.camel.dsl.jbang.core.commands.infra.InfraBaseCommand;
import org.apache.camel.dsl.jbang.core.common.CommandLineHelper;
import org.apache.camel.dsl.jbang.core.common.RuntimeUtil;
import org.apache.camel.main.download.DependencyDownloaderClassLoader;
import org.apache.camel.main.download.MavenDependencyDownloader;
import org.apache.camel.tooling.maven.MavenArtifact;
import picocli.CommandLine;

@CommandLine.Command(name="run", description={"Run an external service"})
public class InfraRun
extends InfraBaseCommand {
    @CommandLine.Parameters(description={"Service name"}, arity="1")
    private List<String> serviceName;
    @CommandLine.Option(names={"--log"}, description={"Log container's output to console"})
    boolean logToStdout;

    public InfraRun(CamelJBangMain main) {
        super(main);
    }

    @Override
    public Integer doCall() throws Exception {
        if (this.serviceName == null || this.serviceName.isEmpty()) {
            return 0;
        }
        String service = this.serviceName.get(0);
        String serviceImplementation = this.serviceName.size() > 1 ? this.serviceName.get(1) : null;
        this.run(service, serviceImplementation);
        return 0;
    }

    private void run(String testService, String testServiceImplementation) throws Exception {
        List<InfraBaseCommand.TestInfraService> services = this.getMetadata();
        InfraBaseCommand.TestInfraService testInfraService = services.stream().filter(service -> {
            if (testServiceImplementation != null && !testServiceImplementation.isEmpty() && service.aliasImplementation() != null) {
                return service.alias().contains(testService) && service.aliasImplementation().contains(testServiceImplementation);
            }
            if (testServiceImplementation == null) {
                return service.alias().contains(testService) && (service.aliasImplementation() == null || service.aliasImplementation().isEmpty());
            }
            return false;
        }).findFirst().orElse(null);
        if (testInfraService == null) {
            String message = ", use the list command for the available services";
            if (testServiceImplementation != null) {
                this.printer().println("service " + testService + " with implementation " + testServiceImplementation + " not found" + message);
                return;
            }
            this.printer().println("service " + testService + " not found" + message);
        }
        DependencyDownloaderClassLoader cl = InfraRun.getDependencyDownloaderClassLoader(testInfraService);
        Thread.currentThread().setContextClassLoader((ClassLoader)cl);
        String serviceInterface = testInfraService.service();
        String serviceImpl = testInfraService.implementation();
        if (!this.jsonOutput) {
            Object prefix = "";
            if (testServiceImplementation != null && !testServiceImplementation.isEmpty()) {
                prefix = " with implementation " + testServiceImplementation;
            }
            this.printer().println("Starting service " + testService + (String)prefix);
        }
        Object actualService = cl.loadClass(serviceImpl).newInstance();
        boolean actualServiceIsAnInfrastructureService = false;
        for (Method method : actualService.getClass().getMethods()) {
            if (!method.getName().contains("initialize")) continue;
            actualServiceIsAnInfrastructureService = true;
            break;
        }
        if (!actualServiceIsAnInfrastructureService) {
            this.printer().println("Service " + serviceImpl + " is not an InfrastructureService");
            return;
        }
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            if (actualService != null) {
                try {
                    actualService.getClass().getMethod("shutdown", new Class[0]).invoke(actualService, new Object[0]);
                }
                catch (Exception e) {
                    this.printer().printErr(e);
                }
            }
        }));
        actualService.getClass().getMethod("initialize", new Class[0]).invoke(actualService, new Object[0]);
        Method[] serviceMethods = cl.loadClass(serviceInterface).getDeclaredMethods();
        HashMap<String, Object> properties = new HashMap<String, Object>();
        for (Method method : serviceMethods) {
            if (method.getParameterCount() != 0 || method.getName().contains("registerProperties")) continue;
            properties.put(method.getName(), method.invoke(actualService, new Object[0]));
        }
        String jsonProperties = this.jsonMapper.writeValueAsString(properties);
        this.printer().println(jsonProperties);
        String name = this.getLogFileName(testService, RuntimeUtil.getPid());
        File logFile = InfraRun.createFile(name);
        String jsonName = this.getJsonFileName(testService, RuntimeUtil.getPid());
        File jsonFile = InfraRun.createFile(jsonName);
        Files.write(jsonFile.toPath(), jsonProperties.getBytes(), new OpenOption[0]);
        if (Arrays.stream(actualService.getClass().getInterfaces()).filter(c -> c.getName().contains("ContainerService")).count() > 0L) {
            Object containerLogConsumer = cl.loadClass("org.apache.camel.test.infra.common.CamelLogConsumer").getConstructor(Path.class, Boolean.TYPE).newInstance(logFile.toPath(), this.logToStdout);
            actualService.getClass().getMethod("followLog", cl.loadClass("org.testcontainers.containers.output.BaseConsumer")).invoke(actualService, containerLogConsumer);
        }
        if (!this.jsonOutput) {
            this.printer().println("Press any key to stop the execution");
        }
        Scanner sc = new Scanner(System.in);
        while (!sc.hasNext()) {
        }
        actualService.getClass().getMethod("shutdown", new Class[0]).invoke(actualService, new Object[0]);
        sc.close();
    }

    private static File createFile(String name) throws IOException {
        File logFile = new File(CommandLineHelper.getCamelDir(), name);
        logFile.createNewFile();
        logFile.deleteOnExit();
        return logFile;
    }

    private static DependencyDownloaderClassLoader getDependencyDownloaderClassLoader(InfraBaseCommand.TestInfraService testInfraService) {
        DependencyDownloaderClassLoader cl = new DependencyDownloaderClassLoader(InfraRun.class.getClassLoader());
        MavenDependencyDownloader downloader = new MavenDependencyDownloader();
        downloader.setClassLoader((ClassLoader)cl);
        downloader.start();
        downloader.downloadDependency(testInfraService.groupId(), testInfraService.artifactId(), testInfraService.version(), true);
        MavenArtifact ma = downloader.downloadArtifact(testInfraService.groupId(), testInfraService.artifactId(), testInfraService.version());
        cl.addFile(ma.getFile());
        return cl;
    }

    public List<String> getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(List<String> serviceName) {
        this.serviceName = serviceName;
    }

    public boolean isLogToStdout() {
        return this.logToStdout;
    }

    public void setLogToStdout(boolean logToStdout) {
        this.logToStdout = logToStdout;
    }
}

