/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.jbang.core.commands.infra;

import java.io.File;
import java.util.HashSet;
import org.apache.camel.dsl.jbang.core.commands.CamelJBangMain;
import org.apache.camel.dsl.jbang.core.commands.infra.InfraBaseCommand;
import org.apache.camel.dsl.jbang.core.common.CommandLineHelper;
import picocli.CommandLine;

@CommandLine.Command(name="ps", description={"Displays running services"}, sortOptions=false, showDefaultValues=true)
public class InfraPs
extends InfraBaseCommand {
    public InfraPs(CamelJBangMain main) {
        super(main);
    }

    @Override
    public Integer doCall() throws Exception {
        HashSet<String> runningAliases = new HashSet<String>();
        for (File pidFile : CommandLineHelper.getCamelDir().listFiles((dir, name) -> name.startsWith("infra-"))) {
            String runningServiceName = pidFile.getName().split("-")[1];
            runningAliases.add(runningServiceName);
        }
        return this.listServices(rows -> {
            if (runningAliases.isEmpty()) {
                rows.clear();
            } else {
                rows.removeIf(row -> !runningAliases.contains(row.alias()));
            }
        });
    }
}

