/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.jbang.core.commands.infra;

import java.io.File;
import java.nio.file.Files;
import java.util.List;
import org.apache.camel.dsl.jbang.core.commands.CamelJBangMain;
import org.apache.camel.dsl.jbang.core.commands.infra.InfraBaseCommand;
import org.apache.camel.dsl.jbang.core.common.CommandLineHelper;
import picocli.CommandLine;

@CommandLine.Command(name="get", description={"Displays running service information"}, sortOptions=false, showDefaultValues=true)
public class InfraGet
extends InfraBaseCommand {
    @CommandLine.Parameters(description={"Service name"}, arity="1")
    private List<String> serviceName;

    public InfraGet(CamelJBangMain main) {
        super(main);
    }

    @Override
    public Integer doCall() throws Exception {
        String serviceToGet = this.serviceName.get(0);
        boolean found = false;
        int n = 0;
        File[] fileArray = CommandLineHelper.getCamelDir().listFiles((dir, name) -> name.startsWith("infra-" + serviceToGet + "-") && name.endsWith(".json"));
        int n2 = fileArray.length;
        if (n < n2) {
            File jsonFile = fileArray[n];
            this.printer().println(Files.readString(jsonFile.toPath()));
            found = true;
        }
        if (!found) {
            this.printer().println("No running service found with alias " + serviceToGet);
            return -1;
        }
        return 0;
    }
}

