/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.jbang.core.commands.action;

import com.github.freva.asciitable.AsciiTable;
import com.github.freva.asciitable.Column;
import com.github.freva.asciitable.HorizontalAlign;
import com.github.freva.asciitable.OverflowBehaviour;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.camel.dsl.jbang.core.commands.CamelJBangMain;
import org.apache.camel.dsl.jbang.core.commands.action.ActionWatchCommand;
import org.apache.camel.util.FileUtil;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.StringHelper;
import org.apache.camel.util.TimeUtils;
import org.apache.camel.util.json.JsonArray;
import org.apache.camel.util.json.JsonObject;
import picocli.CommandLine;

@CommandLine.Command(name="route-controller", description={"List status of route controller"}, sortOptions=false, showDefaultValues=true)
public class RouteControllerAction
extends ActionWatchCommand {
    @CommandLine.Parameters(description={"Name or pid of running Camel integration"}, arity="0..1")
    String name = "*";
    @CommandLine.Option(names={"--sort"}, completionCandidates=IdStateCompletionCandidates.class, description={"Sort by id, or state"}, defaultValue="id")
    String sort;
    @CommandLine.Option(names={"--header"}, description={"Include controller configuration details"}, defaultValue="true")
    boolean header;
    @CommandLine.Option(names={"--trace"}, description={"Include stack-traces in error messages"}, defaultValue="true")
    boolean trace;
    @CommandLine.Option(names={"--depth"}, description={"Max depth of stack-trace"}, defaultValue="1")
    int depth;
    private volatile long pid;

    public RouteControllerAction(CamelJBangMain main) {
        super(main);
    }

    @Override
    public Integer doWatchCall() throws Exception {
        boolean supervising;
        ArrayList<Row> rows = new ArrayList<Row>();
        List<Long> pids = this.findPids(this.name);
        if (pids.isEmpty()) {
            return 0;
        }
        if (pids.size() > 1) {
            this.printer().println("Name or pid " + this.name + " matches " + pids.size() + " running Camel integrations. Specify a name or PID that matches exactly one.");
            return 0;
        }
        if (this.trace && this.depth <= 1) {
            this.depth = Integer.MAX_VALUE;
        }
        this.pid = pids.get(0);
        File outputFile = this.getOutputFile(Long.toString(this.pid));
        FileUtil.deleteFile((File)outputFile);
        JsonObject root = new JsonObject();
        root.put((Object)"action", (Object)"route-controller");
        root.put((Object)"stacktrace", (Object)(this.trace ? "true" : "false"));
        File f = this.getActionFile(Long.toString(this.pid));
        try {
            IOHelper.writeText((String)root.toJson(), (File)f);
        }
        catch (Exception exception) {
            // empty catch block
        }
        JsonObject jo = this.waitForOutputFile(outputFile);
        if (jo != null) {
            supervising = "SupervisingRouteController".equals(jo.getString("controller"));
            JsonArray arr = (JsonArray)jo.get((Object)"routes");
            for (int i = 0; i < arr.size(); ++i) {
                JsonObject jt = (JsonObject)arr.get(i);
                Row row = new Row();
                row.routeId = jt.getString("routeId");
                row.uri = jt.getString("uri");
                row.status = jt.getString("status");
                if (supervising) {
                    row.attempts = jt.getLong("attempts");
                    long time = jt.getLong("lastAttempt");
                    if (time > 0L) {
                        row.lastAttempt = TimeUtils.printSince((long)time);
                    }
                    if ((time = jt.getLong("nextAttempt").longValue()) > 0L) {
                        row.nextAttempt = TimeUtils.printDuration((long)time);
                    }
                    if ((time = jt.getLong("elapsed").longValue()) > 0L) {
                        row.elapsed = TimeUtils.printDuration((long)time);
                    }
                    row.supervising = jt.getString("supervising");
                    row.error = jt.getString("error");
                    row.stackTrace = (List)jt.getCollection("stackTrace");
                }
                rows.add(row);
            }
        } else {
            this.printer().println("Response from running Camel with PID " + this.pid + " not received within 5 seconds");
            return 1;
        }
        rows.sort(this::sortRow);
        if (this.watch) {
            this.clearScreen();
        }
        if (!rows.isEmpty()) {
            if (supervising) {
                if (this.header) {
                    this.printer().println("Supervising Route Controller");
                    this.printer().printf("\tInitial Starting Routes: %b%n", jo.getBoolean("startingRoutes"));
                    this.printer().printf("\tUnhealthy Routes: %b%n", jo.getBoolean("unhealthyRoutes"));
                    this.printer().printf("\tRoutes Total: %s%n", jo.getInteger("totalRoutes"));
                    this.printer().printf("\tRoutes Started: %d%n", jo.getInteger("startedRoutes"));
                    this.printer().printf("\tRoutes Restarting: %d%n", jo.getInteger("restartingRoutes"));
                    this.printer().printf("\tRoutes Exhausted: %d%n", jo.getInteger("exhaustedRoutes"));
                    this.printer().printf("\tInitial Delay: %d%n", jo.getInteger("initialDelay"));
                    this.printer().printf("\tBackoff Delay: %d%n", jo.getInteger("backoffDelay"));
                    this.printer().printf("\tBackoff Max Delay: %d%n", jo.getInteger("backoffMaxDelay"));
                    this.printer().printf("\tBackoff Max Elapsed Time: %d%n", jo.getInteger("backoffMaxElapsedTime"));
                    this.printer().printf("\tBackoff Max Attempts: %d%n", jo.getInteger("backoffMaxAttempts"));
                    this.printer().printf("\tThread Pool Size: %d%n", jo.getInteger("threadPoolSize"));
                    this.printer().printf("\tUnhealthy On Restarting: %b%n", jo.getBoolean("unhealthyOnRestarting"));
                    this.printer().printf("\tUnhealthy On Exhaust: %b%n", jo.getBoolean("unhealthyOnExhausted"));
                    this.printer().println("\n");
                }
                this.dumpTable(rows, true);
            } else {
                if (this.header) {
                    this.printer().println("Default Route Controller");
                    this.printer().printf("\tStarting Routes: %b%n", jo.getBoolean("startingRoutes"));
                    this.printer().printf("\tRoutes Total: %s%n", jo.getInteger("totalRoutes"));
                    this.printer().println("\n");
                }
                this.dumpTable(rows, false);
            }
        }
        FileUtil.deleteFile((File)outputFile);
        return 0;
    }

    protected void dumpTable(List<Row> rows, boolean supervised) {
        this.printer().println(AsciiTable.getTable((Character[])AsciiTable.NO_BORDERS, rows, Arrays.asList(new Column().header("ID").dataAlign(HorizontalAlign.LEFT).maxWidth(25, OverflowBehaviour.ELLIPSIS_RIGHT).with(r -> r.routeId), new Column().header("URI").dataAlign(HorizontalAlign.LEFT).maxWidth(60, OverflowBehaviour.ELLIPSIS_RIGHT).with(r -> r.uri), new Column().header("STATE").headerAlign(HorizontalAlign.RIGHT).with(this::getSupervising), new Column().visible(supervised).header("ATTEMPT").headerAlign(HorizontalAlign.CENTER).dataAlign(HorizontalAlign.CENTER).with(this::getAttempts), new Column().visible(supervised).header("ELAPSED").headerAlign(HorizontalAlign.CENTER).with(this::getElapsed), new Column().visible(supervised).header("LAST-AGO").headerAlign(HorizontalAlign.CENTER).with(this::getLast), new Column().visible(supervised).header("ERROR-MESSAGE").headerAlign(HorizontalAlign.LEFT).dataAlign(HorizontalAlign.LEFT).maxWidth(80, OverflowBehaviour.ELLIPSIS_RIGHT).with(r -> r.error))));
        if (supervised && this.trace && !(rows = rows.stream().filter(r -> r.error != null && !r.error.isEmpty()).collect(Collectors.toList())).isEmpty()) {
            for (Row row : rows) {
                this.printer().println("\n");
                this.printer().println(StringHelper.fillChars((char)'-', (int)120));
                this.printer().println(StringHelper.padString((int)1, (int)55) + "STACK-TRACE");
                this.printer().println(StringHelper.fillChars((char)'-', (int)120));
                StringBuilder sb = new StringBuilder();
                sb.append(String.format("\tID: %s%n", row.routeId));
                sb.append(String.format("\tURI: %s%n", row.uri));
                sb.append(String.format("\tSTATE: %s%n", this.getSupervising(row)));
                for (int i = 0; i < this.depth && i < row.stackTrace.size(); ++i) {
                    sb.append(String.format("\t%s%n", row.stackTrace.get(i)));
                }
                this.printer().println(String.valueOf(sb));
            }
        }
    }

    protected int sortRow(Row o1, Row o2) {
        String s = this.sort;
        int negate = 1;
        if (s.startsWith("-")) {
            s = s.substring(1);
            negate = -1;
        }
        switch (s) {
            case "id": {
                return o1.routeId.compareToIgnoreCase(o2.routeId) * negate;
            }
            case "state": {
                return o1.status.compareToIgnoreCase(o2.status) * negate;
            }
        }
        return 0;
    }

    protected JsonObject waitForOutputFile(File outputFile) {
        return RouteControllerAction.getJsonObject(outputFile);
    }

    protected String getSupervising(Row r) {
        if (r.supervising != null) {
            if ("Active".equals(r.supervising)) {
                if (r.attempts <= 1L) {
                    return "Starting";
                }
                return "Restarting";
            }
            return r.supervising;
        }
        return r.status;
    }

    protected String getAttempts(Row r) {
        if (r.supervising != null) {
            return Long.toString(r.attempts);
        }
        return "";
    }

    protected String getLast(Row r) {
        if (r.lastAttempt != null && !r.lastAttempt.isEmpty()) {
            return r.lastAttempt;
        }
        return "";
    }

    protected String getElapsed(Row r) {
        if (r.elapsed != null && !r.elapsed.isEmpty()) {
            return r.elapsed;
        }
        return "";
    }

    private static class Row {
        String routeId;
        String status;
        String uri;
        long attempts;
        String lastAttempt;
        String nextAttempt;
        String elapsed;
        String supervising;
        String error;
        List<String> stackTrace;

        private Row() {
        }
    }

    public static class IdStateCompletionCandidates
    implements Iterable<String> {
        @Override
        public Iterator<String> iterator() {
            return List.of("id", "state").iterator();
        }
    }
}

