/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.jbang.core.commands.action;

import com.github.freva.asciitable.AsciiTable;
import com.github.freva.asciitable.Column;
import com.github.freva.asciitable.HorizontalAlign;
import com.github.freva.asciitable.OverflowBehaviour;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.camel.dsl.jbang.core.commands.CamelJBangMain;
import org.apache.camel.dsl.jbang.core.commands.action.ActionWatchCommand;
import org.apache.camel.support.PatternHelper;
import org.apache.camel.util.FileUtil;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.json.JsonArray;
import org.apache.camel.util.json.JsonObject;
import picocli.CommandLine;

@CommandLine.Command(name="thread-dump", description={"List threads in a running Camel integration"}, sortOptions=false, showDefaultValues=true)
public class CamelThreadDump
extends ActionWatchCommand {
    @CommandLine.Parameters(description={"Name or pid of running Camel integration"}, arity="0..1")
    String name = "*";
    @CommandLine.Option(names={"--sort"}, completionCandidates=IdNameStateCompletionCandidates.class, description={"Sort by id, name or state"}, defaultValue="id")
    String sort;
    @CommandLine.Option(names={"--filter"}, description={"Filter thread names (use all to include all threads)"}, defaultValue="Camel")
    String filter;
    @CommandLine.Option(names={"--trace"}, description={"Include stack-traces"}, defaultValue="false")
    boolean trace;
    @CommandLine.Option(names={"--depth"}, description={"Max depth of stack-trace"}, defaultValue="1")
    int depth;
    private volatile long pid;

    public CamelThreadDump(CamelJBangMain main) {
        super(main);
    }

    @Override
    public Integer doWatchCall() throws Exception {
        ArrayList<Row> rows = new ArrayList<Row>();
        List<Long> pids = this.findPids(this.name);
        if (pids.isEmpty()) {
            return 0;
        }
        if (pids.size() > 1) {
            this.printer().println("Name or pid " + this.name + " matches " + pids.size() + " running Camel integrations. Specify a name or PID that matches exactly one.");
            return 0;
        }
        if (this.trace && this.depth <= 1) {
            this.depth = Integer.MAX_VALUE;
        }
        this.pid = pids.get(0);
        File outputFile = this.getOutputFile(Long.toString(this.pid));
        FileUtil.deleteFile((File)outputFile);
        JsonObject root = new JsonObject();
        root.put((Object)"action", (Object)"thread-dump");
        File f = this.getActionFile(Long.toString(this.pid));
        try {
            IOHelper.writeText((String)root.toJson(), (File)f);
        }
        catch (Exception exception) {
            // empty catch block
        }
        JsonObject jo = this.waitForOutputFile(outputFile);
        if (jo != null) {
            JsonArray arr = (JsonArray)jo.get((Object)"threads");
            for (int i = 0; i < arr.size(); ++i) {
                boolean match;
                JsonObject jt = (JsonObject)arr.get(i);
                Row row = new Row();
                row.id = jt.getLong("id");
                row.name = jt.getString("name");
                boolean bl = match = "all".equals(this.filter) || row.name.contains(this.filter) || PatternHelper.matchPattern((String)row.name, (String)this.filter);
                if (!match) continue;
                row.state = jt.getString("state");
                row.waited = jt.getLong("waitedCount");
                row.waitedTime = jt.getLong("waitedTime");
                row.blocked = jt.getLong("blockedCount");
                row.blockedTime = jt.getLong("blockedTime");
                row.lock = jt.getString("lockName");
                row.stackTrace = (List)jt.getCollection("stackTrace");
                rows.add(row);
            }
        } else {
            this.printer().println("Response from running Camel with PID " + this.pid + " not received within 5 seconds");
            return 1;
        }
        rows.sort(this::sortRow);
        if (this.watch) {
            this.clearScreen();
        }
        if (!rows.isEmpty()) {
            int total = jo.getInteger("threadCount");
            int peak = jo.getInteger("peakThreadCount");
            this.printer().printf("PID: %s\tThreads: %d\tPeak: %d\t\tDisplay: %d/%d%n", this.pid, total, peak, rows.size(), total);
            if (this.depth == 1) {
                this.singleTable(rows);
            } else {
                this.tableAndStackTrace(rows);
            }
        }
        FileUtil.deleteFile((File)outputFile);
        return 0;
    }

    protected void singleTable(List<Row> rows) {
        this.printer().println(AsciiTable.getTable((Character[])AsciiTable.NO_BORDERS, rows, Arrays.asList(new Column().header("ID").headerAlign(HorizontalAlign.CENTER).with(r -> Long.toString(r.id)), new Column().header("NAME").dataAlign(HorizontalAlign.LEFT).maxWidth(60, OverflowBehaviour.ELLIPSIS_RIGHT).with(r -> r.name), new Column().header("STATE").headerAlign(HorizontalAlign.RIGHT).with(r -> r.state), new Column().header("BLOCK").with(this::getBlocked), new Column().header("WAIT").with(this::getWaited), new Column().header("STACKTRACE").headerAlign(HorizontalAlign.RIGHT).maxWidth(70, OverflowBehaviour.ELLIPSIS_LEFT).with(this::getStackTrace))));
    }

    protected void tableAndStackTrace(List<Row> rows) {
        for (Row row : rows) {
            this.printer().println(AsciiTable.getTable((Character[])AsciiTable.NO_BORDERS, List.of(row), Arrays.asList(new Column().header("ID").headerAlign(HorizontalAlign.CENTER).with(r -> Long.toString(r.id)), new Column().header("NAME").dataAlign(HorizontalAlign.LEFT).maxWidth(60, OverflowBehaviour.ELLIPSIS_RIGHT).with(r -> r.name), new Column().header("STATE").headerAlign(HorizontalAlign.RIGHT).with(r -> r.state), new Column().header("BLOCK").with(this::getBlocked), new Column().header("WAIT").with(this::getWaited))));
            for (int i = 0; i < this.depth && i < row.stackTrace.size(); ++i) {
                this.printer().println("\t" + row.stackTrace.get(i));
            }
        }
    }

    protected int sortRow(Row o1, Row o2) {
        String s = this.sort;
        int negate = 1;
        if (s.startsWith("-")) {
            s = s.substring(1);
            negate = -1;
        }
        switch (s) {
            case "id": {
                return Long.compare(o1.id, o2.id) * negate;
            }
            case "name": {
                return o1.name.compareToIgnoreCase(o2.name) * negate;
            }
            case "state": {
                return o1.state.compareToIgnoreCase(o2.state) * negate;
            }
        }
        return 0;
    }

    protected JsonObject waitForOutputFile(File outputFile) {
        return CamelThreadDump.getJsonObject(outputFile);
    }

    private String getBlocked(Row r) {
        if (r.blockedTime > 0L) {
            return r.blocked + "(" + r.blockedTime + "ms)";
        }
        return Long.toString(r.blocked);
    }

    private String getWaited(Row r) {
        if (r.waitedTime > 0L) {
            return r.waited + "(" + r.waitedTime + "ms)";
        }
        return Long.toString(r.waited);
    }

    private String getStackTrace(Row r) {
        if (r.stackTrace == null || r.stackTrace.isEmpty()) {
            return "";
        }
        return r.stackTrace.get(0);
    }

    private static class Row {
        long id;
        String name;
        String state;
        long waited;
        long waitedTime;
        long blocked;
        long blockedTime;
        String lock;
        List<String> stackTrace;

        private Row() {
        }
    }

    public static class IdNameStateCompletionCandidates
    implements Iterable<String> {
        @Override
        public Iterator<String> iterator() {
            return List.of("id", "name", "state").iterator();
        }
    }
}

