/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.jbang.core.commands.action;

import com.github.freva.asciitable.AsciiTable;
import com.github.freva.asciitable.Column;
import com.github.freva.asciitable.HorizontalAlign;
import com.github.freva.asciitable.OverflowBehaviour;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.camel.dsl.jbang.core.commands.CamelJBangMain;
import org.apache.camel.dsl.jbang.core.commands.action.ActionWatchCommand;
import org.apache.camel.util.FileUtil;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.StringHelper;
import org.apache.camel.util.json.JsonArray;
import org.apache.camel.util.json.JsonObject;
import picocli.CommandLine;

@CommandLine.Command(name="startup-recorder", description={"Display startup recording"}, sortOptions=false, showDefaultValues=true)
public class CamelStartupRecorderAction
extends ActionWatchCommand {
    @CommandLine.Parameters(description={"Name or pid of running Camel integration"}, arity="0..1")
    String name = "*";
    @CommandLine.Option(names={"--sort"}, completionCandidates=DurationTypeCompletionCandidates.class, description={"Sort by duration, or type"})
    String sort;
    private volatile long pid;

    public CamelStartupRecorderAction(CamelJBangMain main) {
        super(main);
    }

    @Override
    public Integer doWatchCall() throws Exception {
        ArrayList<Row> rows = new ArrayList<Row>();
        List<Long> pids = this.findPids(this.name);
        if (pids.isEmpty()) {
            return 0;
        }
        if (pids.size() > 1) {
            this.printer().println("Name or pid " + this.name + " matches " + pids.size() + " running Camel integrations. Specify a name or PID that matches exactly one.");
            return 0;
        }
        this.pid = pids.get(0);
        File outputFile = this.getOutputFile(Long.toString(this.pid));
        FileUtil.deleteFile((File)outputFile);
        JsonObject root = new JsonObject();
        root.put((Object)"action", (Object)"startup-recorder");
        File f = this.getActionFile(Long.toString(this.pid));
        try {
            IOHelper.writeText((String)root.toJson(), (File)f);
        }
        catch (Exception exception) {
            // empty catch block
        }
        JsonObject jo = this.waitForOutputFile(outputFile);
        if (jo != null) {
            JsonArray arr = (JsonArray)jo.get((Object)"steps");
            for (int i = 0; arr != null && i < arr.size(); ++i) {
                JsonObject o = (JsonObject)arr.get(i);
                Row row = new Row();
                row.id = o.getInteger("id");
                row.parentId = o.getInteger("parentId");
                row.level = o.getInteger("level");
                row.name = o.getString("name");
                row.type = o.getString("type");
                row.description = o.getString("description");
                row.duration = o.getLong("duration");
                rows.add(row);
            }
        }
        rows.sort(this::sortRow);
        if (!rows.isEmpty()) {
            this.printer().println(AsciiTable.getTable((Character[])AsciiTable.NO_BORDERS, rows, Arrays.asList(new Column().header("DURATION").dataAlign(HorizontalAlign.RIGHT).with(this::getDuration), new Column().header("TYPE").dataAlign(HorizontalAlign.LEFT).with(r -> r.type), new Column().header("STEP (END)").dataAlign(HorizontalAlign.LEFT).maxWidth(80, OverflowBehaviour.ELLIPSIS_RIGHT).with(this::getStep))));
        }
        FileUtil.deleteFile((File)outputFile);
        return 0;
    }

    private String getStep(Row r) {
        String pad = StringHelper.padString((int)r.level);
        String out = r.description;
        if (r.name != null && !r.name.equals("null")) {
            out = String.format("%s(%s)", r.description, r.name);
        }
        return pad + out;
    }

    private String getDuration(Row r) {
        if (r.duration > 0L) {
            return Long.toString(r.duration);
        }
        return "";
    }

    protected int sortRow(Row o1, Row o2) {
        String s = this.sort != null ? this.sort : "";
        int negate = 1;
        if (s.startsWith("-")) {
            s = s.substring(1);
            negate = -1;
        }
        switch (s) {
            case "duration": {
                return Long.compare(o1.duration, o2.duration) * negate;
            }
            case "type": {
                return o1.type.compareToIgnoreCase(o2.type) * negate;
            }
        }
        return 0;
    }

    protected JsonObject waitForOutputFile(File outputFile) {
        return CamelStartupRecorderAction.getJsonObject(outputFile);
    }

    private static class Row {
        int id;
        int parentId;
        int level;
        String name;
        String type;
        String description;
        long duration;

        private Row() {
        }
    }

    public static class DurationTypeCompletionCandidates
    implements Iterable<String> {
        @Override
        public Iterator<String> iterator() {
            return List.of("duration", "type").iterator();
        }
    }
}

