/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.jbang.core.commands.action;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.camel.dsl.jbang.core.commands.CamelJBangMain;
import org.apache.camel.dsl.jbang.core.commands.action.ActionWatchCommand;
import org.apache.camel.util.FileUtil;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.json.JsonArray;
import org.apache.camel.util.json.JsonObject;
import org.apache.camel.util.json.Jsoner;
import picocli.CommandLine;

@CommandLine.Command(name="source", description={"List top processors (source) in a running Camel integration"}, sortOptions=false, showDefaultValues=true)
public class CamelSourceTop
extends ActionWatchCommand {
    @CommandLine.Parameters(description={"Name or pid of running Camel integration"}, arity="0..1")
    String name = "*";
    @CommandLine.Option(names={"--limit"}, description={"Filter processors by limiting to the given number of rows"})
    int limit;
    @CommandLine.Option(names={"--filter-mean"}, description={"Filter processors that must be slower than the given time (ms)"})
    long mean;
    private volatile long pid;

    public CamelSourceTop(CamelJBangMain main) {
        super(main);
    }

    @Override
    public Integer doWatchCall() throws Exception {
        ArrayList<Row> rows = new ArrayList<Row>();
        List<Long> pids = this.findPids(this.name);
        if (pids.isEmpty()) {
            return 0;
        }
        if (pids.size() > 1) {
            this.printer().println("Name or pid " + this.name + " matches " + pids.size() + " running Camel integrations. Specify a name or PID that matches exactly one.");
            return 0;
        }
        this.pid = pids.get(0);
        File outputFile = this.getOutputFile(Long.toString(this.pid));
        FileUtil.deleteFile((File)outputFile);
        JsonObject root = new JsonObject();
        root.put((Object)"action", (Object)"top-processors");
        File f = this.getActionFile(Long.toString(this.pid));
        try {
            IOHelper.writeText((String)root.toJson(), (File)f);
        }
        catch (Exception exception) {
            // empty catch block
        }
        JsonObject jo = this.waitForOutputFile(outputFile);
        if (jo != null) {
            JsonArray arr = (JsonArray)jo.get((Object)"processors");
            for (int i = 0; i < arr.size(); ++i) {
                List lines;
                JsonObject o = (JsonObject)arr.get(i);
                Row row = new Row();
                row.id = o.getString("processorId");
                row.routeId = o.getString("routeId");
                row.location = o.getString("location");
                Map stats = o.getMap("statistics");
                if (stats != null) {
                    row.total = stats.get("exchangesTotal").toString();
                    row.mean = stats.get("meanProcessingTime").toString();
                    if ("-1".equals(row.mean)) {
                        row.mean = null;
                    }
                    row.max = stats.get("maxProcessingTime").toString();
                    row.min = stats.get("minProcessingTime").toString();
                    Object last = stats.get("lastProcessingTime");
                    if (last != null) {
                        row.last = last.toString();
                        if ("-1".equals(row.last)) {
                            row.last = null;
                        }
                    } else {
                        row.last = null;
                    }
                }
                if ((lines = (List)o.getCollection("code")) != null) {
                    for (JsonObject line : lines) {
                        Code code = new Code();
                        code.line = line.getInteger("line");
                        code.code = line.getString("code");
                        if (line.getBooleanOrDefault("match", false).booleanValue()) {
                            code.match = true;
                        }
                        row.code.add(code);
                    }
                }
                boolean add = true;
                if (this.mean > 0L && (row.mean == null || Long.parseLong(row.mean) < this.mean)) {
                    add = false;
                }
                if (this.limit > 0 && rows.size() >= this.limit) {
                    add = false;
                }
                if (!add) continue;
                rows.add(row);
            }
        } else {
            this.printer().println("Response from running Camel with PID " + this.pid + " not received within 5 seconds");
            return 1;
        }
        rows.sort(this::sortRow);
        if (this.watch) {
            this.clearScreen();
        }
        if (!rows.isEmpty()) {
            this.printSource(rows);
        }
        FileUtil.deleteFile((File)outputFile);
        return 0;
    }

    protected void printSource(List<Row> rows) {
        for (Row row : rows) {
            this.printer().printf("Route: %s\tSource: %s Total: %s Mean: %s Max: %s Min: %s Last: %s%n", row.routeId, row.location, row.total, row.mean != null ? row.mean : "", row.max, row.min, row.last != null ? row.last : "");
            for (int i = 0; i < row.code.size(); ++i) {
                Code code = row.code.get(i);
                String c = Jsoner.unescape((String)code.code);
                String arrow = code.match ? "-->" : "   ";
                this.printer().printf("%4d: %s %s%n", code.line, arrow, c);
            }
            this.printer().println();
        }
    }

    protected JsonObject waitForOutputFile(File outputFile) {
        return CamelSourceTop.getJsonObject(outputFile);
    }

    protected int sortRow(Row o1, Row o2) {
        long m1 = o1.mean != null ? Long.parseLong(o1.mean) : 0L;
        long m2 = o2.mean != null ? Long.parseLong(o2.mean) : 0L;
        return Long.compare(m2, m1);
    }

    private static class Row {
        String routeId;
        String id;
        String location;
        String total;
        String mean;
        String max;
        String min;
        String last;
        List<Code> code = new ArrayList<Code>();

        private Row() {
        }
    }

    private static class Code {
        int line;
        String code;
        boolean match;

        private Code() {
        }
    }
}

