/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.jbang.core.commands.action;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.apache.camel.dsl.jbang.core.commands.CamelJBangMain;
import org.apache.camel.dsl.jbang.core.commands.action.ActionBaseCommand;
import org.apache.camel.dsl.jbang.core.commands.action.MessageTableHelper;
import org.apache.camel.util.FileUtil;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.StopWatch;
import org.apache.camel.util.StringHelper;
import org.apache.camel.util.TimeUtils;
import org.apache.camel.util.json.JsonArray;
import org.apache.camel.util.json.JsonObject;
import org.apache.camel.util.json.Jsoner;
import org.fusesource.jansi.Ansi;
import org.fusesource.jansi.AnsiConsole;
import picocli.CommandLine;

@CommandLine.Command(name="send", description={"Send messages to endpoints via running Camel"}, sortOptions=false, showDefaultValues=true)
public class CamelSendAction
extends ActionBaseCommand {
    @CommandLine.Parameters(description={"Name or pid of running Camel integration"}, arity="0..1")
    String name = "*";
    @CommandLine.Option(names={"--endpoint"}, description={"Endpoint where to send the message (can be uri, pattern, or refer to a route id)"})
    String endpoint;
    @CommandLine.Option(names={"--poll"}, description={"Poll instead of sending a message. This can be used to receive latest message from a Kafka topic or JMS queue."})
    boolean poll;
    @CommandLine.Option(names={"--reply"}, description={"Whether to expect a reply message (InOut vs InOut messaging style)"})
    boolean reply;
    @CommandLine.Option(names={"--reply-file"}, description={"Saves reply message to the file with the given name (override if exists)"})
    String replyFile;
    @CommandLine.Option(names={"--body"}, description={"Message body to send (prefix with file: to refer to loading message body from file)"})
    String body;
    @CommandLine.Option(names={"--header"}, description={"Message header (key=value)"})
    List<String> headers;
    @CommandLine.Option(names={"--timeout"}, defaultValue="20000", description={"Timeout in millis waiting for message to be sent (and reply message if InOut messaging)"})
    long timeout = 20000L;
    @CommandLine.Option(names={"--show-exchange-properties"}, defaultValue="false", description={"Show exchange properties in traced messages"})
    boolean showExchangeProperties;
    @CommandLine.Option(names={"--show-headers"}, defaultValue="true", description={"Show message headers in traced messages"})
    boolean showHeaders = true;
    @CommandLine.Option(names={"--show-body"}, defaultValue="true", description={"Show message body in traced messages"})
    boolean showBody = true;
    @CommandLine.Option(names={"--show-exception"}, defaultValue="true", description={"Show exception and stacktrace for failed messages"})
    boolean showException = true;
    @CommandLine.Option(names={"--logging-color"}, defaultValue="true", description={"Use colored logging"})
    boolean loggingColor = true;
    @CommandLine.Option(names={"--pretty"}, description={"Pretty print message body when using JSon or XML format"})
    boolean pretty;
    private volatile long pid;
    private MessageTableHelper tableHelper;

    public CamelSendAction(CamelJBangMain main) {
        super(main);
    }

    @Override
    public Integer doCall() throws Exception {
        List<Long> pids = this.findPids(this.name);
        if (pids.isEmpty()) {
            return 0;
        }
        if (pids.size() > 1) {
            this.printer().println("Name or pid " + this.name + " matches " + pids.size() + " running Camel integrations. Specify a name or PID that matches exactly one.");
            return 0;
        }
        this.pid = pids.get(0);
        File outputFile = this.getOutputFile(Long.toString(this.pid));
        FileUtil.deleteFile((File)outputFile);
        JsonObject root = new JsonObject();
        root.put((Object)"action", (Object)"send");
        root.put((Object)"endpoint", (Object)this.endpoint);
        root.put((Object)"poll", (Object)this.poll);
        if (this.timeout < 5000L) {
            this.timeout = 5000L;
        }
        root.put((Object)"pollTimeout", (Object)this.timeout);
        String mep = this.reply || this.replyFile != null ? "InOut" : "InOnly";
        root.put((Object)"exchangePattern", (Object)mep);
        if (this.body != null) {
            root.put((Object)"body", (Object)this.body);
        }
        if (this.headers != null) {
            JsonArray arr = new JsonArray();
            for (String h : this.headers) {
                JsonObject jo = new JsonObject();
                if (!h.contains("=")) {
                    this.printer().println("Header must be in key=value format, was: " + h);
                    return 0;
                }
                jo.put((Object)"key", (Object)StringHelper.before((String)h, (String)"="));
                jo.put((Object)"value", (Object)StringHelper.after((String)h, (String)"="));
                arr.add((Object)jo);
            }
            root.put((Object)"headers", (Object)arr);
        }
        File f = this.getActionFile(Long.toString(this.pid));
        try {
            IOHelper.writeText((String)root.toJson(), (File)f);
        }
        catch (Exception exception) {
            // empty catch block
        }
        JsonObject jo = this.waitForOutputFile(outputFile);
        if (jo != null) {
            this.printStatusLine(jo);
            String exchangeId = jo.getString("exchangeId");
            JsonObject message = (JsonObject)jo.getMap("message");
            JsonObject cause = (JsonObject)jo.getMap("exception");
            if (message != null || cause != null) {
                if (this.replyFile != null) {
                    File target = new File(this.replyFile);
                    String json = jo.toJson();
                    if (this.pretty) {
                        json = Jsoner.prettyPrint((String)json, (int)2);
                    }
                    IOHelper.writeText((String)json, (File)target);
                }
                if (!this.showExchangeProperties && message != null) {
                    message.remove((Object)"exchangeProperties");
                }
                if (!this.showHeaders && message != null) {
                    message.remove((Object)"headers");
                }
                if (!this.showBody && message != null) {
                    message.remove((Object)"body");
                }
                if (!this.showException && cause != null) {
                    cause = null;
                }
                if (this.replyFile == null) {
                    this.tableHelper = new MessageTableHelper();
                    this.tableHelper.setPretty(this.pretty);
                    this.tableHelper.setLoggingColor(this.loggingColor);
                    this.tableHelper.setShowExchangeProperties(this.showExchangeProperties);
                    String table = this.tableHelper.getDataAsTable(exchangeId, mep, jo, null, message, cause);
                    this.printer().println(table);
                }
            }
        }
        FileUtil.deleteFile((File)outputFile);
        return 0;
    }

    private void printStatusLine(JsonObject jo) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        String ts = sdf.format(new Date(jo.getLong("timestamp")));
        if (this.loggingColor) {
            AnsiConsole.out().print((Object)Ansi.ansi().fgBrightDefault().a(Ansi.Attribute.INTENSITY_FAINT).a(ts).reset());
        } else {
            this.printer().print(ts);
        }
        this.printer().print("  ");
        String p = String.format("%5.5s", this.pid);
        if (this.loggingColor) {
            AnsiConsole.out().print((Object)Ansi.ansi().fgMagenta().a(p).reset());
            AnsiConsole.out().print((Object)Ansi.ansi().fgBrightDefault().a(Ansi.Attribute.INTENSITY_FAINT).a(" --- ").reset());
        } else {
            this.printer().print(p);
            this.printer().print(" --- ");
        }
        String ids = jo.getString("endpoint");
        if (ids.length() > 40) {
            ids = ids.substring(0, 40);
        }
        ids = String.format("%40.40s", ids);
        if (this.loggingColor) {
            AnsiConsole.out().print((Object)Ansi.ansi().fgCyan().a(ids).reset());
        } else {
            this.printer().print(ids);
        }
        this.printer().print(" : ");
        this.printer().print(this.getStatus(jo));
        String e = TimeUtils.printDuration((long)jo.getLong("elapsed"), (boolean)true);
        if (this.loggingColor) {
            AnsiConsole.out().print((Object)Ansi.ansi().fgBrightDefault().a(" (" + e + ")").reset());
        } else {
            this.printer().print("(" + e + ")");
        }
        this.printer().println();
    }

    private String getStatus(JsonObject r) {
        String status;
        boolean failed = "failed".equals(r.getString("status"));
        boolean timeout = "timeout".equals(r.getString("status"));
        boolean reply = r.containsKey((Object)"message");
        Ansi.Color c = Ansi.Color.GREEN;
        if (failed) {
            status = "Failed (exception)";
            c = Ansi.Color.RED;
        } else if (this.replyFile != null) {
            status = this.poll ? "Poll save to fill (success)" : "Reply save to file (success)";
        } else if (reply) {
            status = this.poll ? "Poll received (success)" : "Reply received (success)";
        } else if (timeout) {
            status = "Timeout";
            c = Ansi.Color.YELLOW;
        } else {
            status = this.poll ? "Poll (success)" : "Sent (success)";
        }
        if (this.loggingColor) {
            return Ansi.ansi().fg(c).a(status).reset().toString();
        }
        return status;
    }

    protected JsonObject waitForOutputFile(File outputFile) {
        StopWatch watch = new StopWatch();
        long wait = this.timeout + 10000L;
        while (watch.taken() < wait) {
            try {
                Thread.sleep(20L);
                if (!outputFile.exists()) continue;
                FileInputStream fis = new FileInputStream(outputFile);
                String text = IOHelper.loadText((InputStream)fis);
                IOHelper.close((Closeable)fis);
                return (JsonObject)Jsoner.deserialize((String)text);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (Exception exception) {
            }
        }
        return null;
    }
}

