/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.jbang.core.commands.action;

import com.github.freva.asciitable.AsciiTable;
import com.github.freva.asciitable.Column;
import com.github.freva.asciitable.HorizontalAlign;
import com.github.freva.asciitable.OverflowBehaviour;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.StringJoiner;
import org.apache.camel.dsl.jbang.core.commands.CamelJBangMain;
import org.apache.camel.dsl.jbang.core.commands.action.ActionBaseCommand;
import org.apache.camel.dsl.jbang.core.commands.action.MessageTableHelper;
import org.apache.camel.dsl.jbang.core.common.ProcessHelper;
import org.apache.camel.util.FileUtil;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.TimeUtils;
import org.apache.camel.util.URISupport;
import org.apache.camel.util.json.JsonArray;
import org.apache.camel.util.json.JsonObject;
import org.fusesource.jansi.Ansi;
import picocli.CommandLine;

@CommandLine.Command(name="browse", description={"Browse pending messages on endpoints"}, sortOptions=false, showDefaultValues=true)
public class CamelBrowseAction
extends ActionBaseCommand {
    @CommandLine.Parameters(description={"Name or pid of running Camel integration"}, arity="0..1")
    String name = "*";
    @CommandLine.Option(names={"--endpoint"}, description={"Endpoint to browse messages (can be uri, pattern, or refer to a route id)"})
    String endpoint;
    @CommandLine.Option(names={"--short-uri"}, description={"List endpoint URI without query parameters (short)"})
    boolean shortUri;
    @CommandLine.Option(names={"--wide-uri"}, description={"List endpoint URI in full details"})
    boolean wideUri;
    @CommandLine.Option(names={"--mask"}, description={"Whether to mask endpoint URIs to avoid printing sensitive information such as password or access keys"})
    boolean mask;
    @CommandLine.Option(names={"--dump"}, defaultValue="false", description={"Whether to include message dumps"})
    boolean dump;
    @CommandLine.Option(names={"--limit"}, defaultValue="100", description={"Limits the number of messages to dump per endpoint"})
    int limit;
    @CommandLine.Option(names={"--tail"}, description={"The number of messages from the end (latest) to dump"})
    int tail;
    @CommandLine.Option(names={"--fresh-size"}, defaultValue="false", description={"Whether to calculate fresh queue size information (performance overhead)"})
    boolean freshSize;
    @CommandLine.Option(names={"--sort"}, completionCandidates=UriSizeCompletionCandidates.class, description={"Sort by uri, or size"}, defaultValue="uri")
    String sort;
    @CommandLine.Option(names={"--show-headers"}, defaultValue="true", description={"Show message headers in browsed messages"})
    boolean showHeaders = true;
    @CommandLine.Option(names={"--show-body"}, defaultValue="true", description={"Show message body in browsed messages"})
    boolean showBody = true;
    @CommandLine.Option(names={"--only-body"}, defaultValue="false", description={"Show only message body in browsed messages"})
    boolean onlyBody;
    @CommandLine.Option(names={"--body-max-chars"}, description={"Maximum size of the message body to include in the dump"})
    int bodyMaxChars;
    @CommandLine.Option(names={"--logging-color"}, defaultValue="true", description={"Use colored logging"})
    boolean loggingColor = true;
    @CommandLine.Option(names={"--pretty"}, description={"Pretty print message body when using JSon or XML format"})
    boolean pretty;
    private volatile long pid;

    public CamelBrowseAction(CamelJBangMain main) {
        super(main);
    }

    @Override
    public Integer doCall() throws Exception {
        List<Long> pids = this.findPids(this.name);
        if (pids.isEmpty()) {
            return 0;
        }
        if (pids.size() > 1) {
            this.printer().println("Name or pid " + this.name + " matches " + pids.size() + " running Camel integrations. Specify a name or PID that matches exactly one.");
            return 0;
        }
        this.pid = pids.get(0);
        File outputFile = this.getOutputFile(Long.toString(this.pid));
        FileUtil.deleteFile((File)outputFile);
        JsonObject root = new JsonObject();
        root.put((Object)"action", (Object)"browse");
        root.put((Object)"filter", (Object)(this.endpoint == null ? "*" : this.endpoint));
        root.put((Object)"limit", (Object)this.limit);
        root.put((Object)"tail", (Object)this.tail);
        root.put((Object)"freshSize", (Object)this.freshSize);
        root.put((Object)"dump", (Object)this.dump);
        root.put((Object)"includeBody", (Object)this.showBody);
        if (this.bodyMaxChars > 0) {
            root.put((Object)"bodyMaxChars", (Object)this.bodyMaxChars);
        }
        File f = this.getActionFile(Long.toString(this.pid));
        try {
            IOHelper.writeText((String)root.toJson(), (File)f);
        }
        catch (Exception exception) {
            // empty catch block
        }
        ArrayList<Row> rows = new ArrayList<Row>();
        JsonObject jo = CamelBrowseAction.getJsonObject(outputFile);
        if (jo != null && (root = this.loadStatus(this.pid)) != null) {
            Row row = new Row();
            row.pid = Long.toString(this.pid);
            JsonObject context = (JsonObject)root.get((Object)"context");
            if (context == null) {
                return 0;
            }
            ProcessHandle ph = ProcessHandle.of(this.pid).orElse(null);
            row.name = context.getString("name");
            if ("CamelJBang".equals(row.name)) {
                row.name = ProcessHelper.extractName(root, ph);
            }
            row.uptime = CamelBrowseAction.extractSince(ph);
            row.ago = TimeUtils.printSince((long)row.uptime);
            JsonArray arr = (JsonArray)jo.getCollection("browse");
            for (int i = 0; arr != null && i < arr.size(); ++i) {
                JsonObject o = (JsonObject)arr.get(i);
                row.uri = o.getString("endpointUri");
                if (this.mask) {
                    row.uri = URISupport.sanitizeUri((String)row.uri);
                }
                row.queueSize = o.getInteger("queueSize");
                row.limit = o.getIntegerOrDefault("limit", 0);
                row.position = o.getIntegerOrDefault("position", 0);
                row.firstTimestamp = o.getLongOrDefault("firstTimestamp", 0L);
                row.lastTimestamp = o.getLongOrDefault("lastTimestamp", 0L);
                if (this.dump) {
                    row.messages = (List)o.getCollection("messages");
                }
                rows.add(row);
                row = row.copy();
            }
        }
        rows.sort(this::sortRow);
        if (this.dump) {
            this.dumpMessages(rows, this.onlyBody);
        } else {
            this.tableStatus(rows);
        }
        FileUtil.deleteFile((File)outputFile);
        return 0;
    }

    protected void dumpMessages(List<Row> rows, boolean onlyBody) {
        MessageTableHelper tableHelper = new MessageTableHelper();
        tableHelper.setPretty(this.pretty);
        tableHelper.setLoggingColor(this.loggingColor);
        tableHelper.setShowExchangeProperties(false);
        for (Row row : rows) {
            if (row.messages == null) continue;
            for (int i = 0; i < row.messages.size(); ++i) {
                JsonObject jo = row.messages.get(i);
                String exchangeId = jo.getString("exchangeId");
                JsonObject message = (JsonObject)jo.getMap("message");
                if (onlyBody) {
                    exchangeId = null;
                    message.remove((Object)"headers");
                    message.remove((Object)"messageType");
                } else {
                    if (!this.showHeaders && message != null) {
                        message.remove((Object)"headers");
                    }
                    if (!this.showBody && message != null) {
                        message.remove((Object)"body");
                    }
                }
                if (this.mask) {
                    row.uri = URISupport.sanitizeUri((String)row.uri);
                }
                JsonObject ep = new JsonObject();
                ep.put((Object)"endpoint", (Object)row.uri);
                String table = tableHelper.getDataAsTable(exchangeId, null, ep, null, message, null);
                String header = String.format("Browse Message: (%s/%s)", row.position + i + 1, row.position + row.messages.size());
                if (this.loggingColor) {
                    this.printer().println(Ansi.ansi().fgGreen().a(header).reset().toString());
                } else {
                    this.printer().println(header);
                }
                this.printer().println(table);
            }
        }
    }

    protected void tableStatus(List<Row> rows) {
        this.printer().println(AsciiTable.getTable((Character[])AsciiTable.NO_BORDERS, rows, Arrays.asList(new Column().header("PID").headerAlign(HorizontalAlign.CENTER).with(r -> r.pid), new Column().header("NAME").dataAlign(HorizontalAlign.LEFT).maxWidth(40, OverflowBehaviour.ELLIPSIS_RIGHT).with(r -> r.name), new Column().header("AGE").headerAlign(HorizontalAlign.CENTER).with(r -> r.ago), new Column().header("SIZE").headerAlign(HorizontalAlign.RIGHT).with(this::getQueueSize), new Column().header("SINCE").headerAlign(HorizontalAlign.CENTER).dataAlign(HorizontalAlign.LEFT).with(this::getMessageAgo), new Column().header("ENDPOINT").visible(!this.wideUri).dataAlign(HorizontalAlign.LEFT).maxWidth(90, OverflowBehaviour.ELLIPSIS_RIGHT).with(this::getEndpointUri), new Column().header("ENDPOINT").visible(this.wideUri).dataAlign(HorizontalAlign.LEFT).maxWidth(140, OverflowBehaviour.NEWLINE).with(r -> r.uri))));
    }

    protected int sortRow(Row o1, Row o2) {
        String s = this.sort;
        int negate = 1;
        if (s.startsWith("-")) {
            s = s.substring(1);
            negate = -1;
        }
        switch (s) {
            case "uri": {
                return o1.uri.compareToIgnoreCase(o2.uri) * negate;
            }
            case "size": {
                return Long.compare(o1.queueSize, o2.queueSize) * negate;
            }
        }
        return 0;
    }

    protected String getMessageAgo(Row r) {
        StringJoiner sj = new StringJoiner("/");
        if (r.firstTimestamp > 0L) {
            sj.add(TimeUtils.printSince((long)r.firstTimestamp));
        }
        if (r.lastTimestamp > 0L) {
            sj.add(TimeUtils.printSince((long)r.lastTimestamp));
        }
        return sj.toString();
    }

    protected String getQueueSize(Row r) {
        if (this.freshSize) {
            return "" + r.queueSize;
        }
        if (r.limit > 0 && r.queueSize >= r.limit) {
            return r.queueSize + "+";
        }
        return "" + r.queueSize;
    }

    protected String getEndpointUri(Row r) {
        int pos;
        String u = r.uri;
        if (this.shortUri && (pos = u.indexOf(63)) > 0) {
            u = u.substring(0, pos);
        }
        return u;
    }

    private static class Row
    implements Cloneable {
        String pid;
        String name;
        String ago;
        long uptime;
        String uri;
        int queueSize;
        int limit;
        int position;
        long firstTimestamp;
        long lastTimestamp;
        List<JsonObject> messages;

        private Row() {
        }

        Row copy() {
            try {
                return (Row)this.clone();
            }
            catch (CloneNotSupportedException e) {
                return null;
            }
        }
    }

    public static class UriSizeCompletionCandidates
    implements Iterable<String> {
        @Override
        public Iterator<String> iterator() {
            return List.of("uri", "size").iterator();
        }
    }
}

