/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.jbang.core.commands.action;

import com.github.freva.asciitable.AsciiTable;
import com.github.freva.asciitable.Column;
import com.github.freva.asciitable.HorizontalAlign;
import com.github.freva.asciitable.OverflowBehaviour;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.camel.dsl.jbang.core.commands.CamelJBangMain;
import org.apache.camel.dsl.jbang.core.commands.action.ActionBaseCommand;
import org.apache.camel.util.FileUtil;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.json.JsonArray;
import org.apache.camel.util.json.JsonObject;
import picocli.CommandLine;

@CommandLine.Command(name="bean", description={"List beans in a running Camel integration"}, sortOptions=false, showDefaultValues=true)
public class CamelBeanDump
extends ActionBaseCommand {
    @CommandLine.Parameters(description={"Name or pid of running Camel integration"}, arity="0..1")
    String name = "*";
    @CommandLine.Option(names={"--sort"}, completionCandidates=NameTypeCompletionCandidates.class, description={"Sort by name or type"}, defaultValue="name")
    String sort;
    @CommandLine.Option(names={"--filter"}, description={"Filter beans names (use all to include all beans)"}, defaultValue="all")
    String filter;
    @CommandLine.Option(names={"--properties"}, description={"Show bean properties"}, defaultValue="true")
    boolean properties;
    @CommandLine.Option(names={"--nulls"}, description={"Include null values"}, defaultValue="true")
    boolean nulls;
    @CommandLine.Option(names={"--internal"}, description={"Include internal Camel beans"}, defaultValue="false")
    boolean internal;
    @CommandLine.Option(names={"--dsl"}, description={"Include only beans from YAML or XML DSL"}, defaultValue="false")
    boolean dsl;
    private volatile long pid;

    public CamelBeanDump(CamelJBangMain main) {
        super(main);
    }

    @Override
    public Integer doCall() throws Exception {
        ArrayList<Row> rows = new ArrayList<Row>();
        List<Long> pids = this.findPids(this.name);
        if (pids.isEmpty()) {
            return 0;
        }
        if (pids.size() > 1) {
            this.printer().println("Name or pid " + this.name + " matches " + pids.size() + " running Camel integrations. Specify a name or PID that matches exactly one.");
            return 0;
        }
        this.pid = pids.get(0);
        File outputFile = this.getOutputFile(Long.toString(this.pid));
        FileUtil.deleteFile((File)outputFile);
        JsonObject root = new JsonObject();
        root.put((Object)"action", (Object)"bean");
        if (!"all".equals(this.filter)) {
            root.put((Object)"filter", (Object)this.filter);
        }
        root.put((Object)"properties", (Object)this.properties);
        root.put((Object)"nulls", (Object)this.nulls);
        root.put((Object)"internal", (Object)this.internal);
        File f = this.getActionFile(Long.toString(this.pid));
        try {
            IOHelper.writeText((String)root.toJson(), (File)f);
        }
        catch (Exception exception) {
            // empty catch block
        }
        JsonObject jo = this.waitForOutputFile(outputFile);
        if (jo != null) {
            JsonObject beans = this.dsl ? (JsonObject)jo.get((Object)"bean-models") : (JsonObject)jo.get((Object)"beans");
            for (String name : beans.keySet()) {
                JsonObject jt = (JsonObject)beans.get((Object)name);
                Row row = new Row();
                row.name = jt.getString("name");
                row.type = jt.getString("type");
                JsonArray arr = (JsonArray)jt.getCollection("properties");
                JsonArray arr2 = (JsonArray)jt.getCollection("modelProperties");
                if (arr != null) {
                    row.properties = new ArrayList<PropertyRow>();
                    for (int i = 0; i < arr.size(); ++i) {
                        JsonObject p2;
                        PropertyRow pr = new PropertyRow();
                        row.properties.add(pr);
                        JsonObject p = (JsonObject)arr.get(i);
                        pr.name = p.getString("name");
                        pr.type = p.getString("type");
                        pr.value = p.get((Object)"value");
                        if (arr2 == null || (p2 = (JsonObject)arr2.get(i)) == null) continue;
                        pr.configValue = p2.getString("value");
                    }
                }
                rows.add(row);
            }
        } else {
            this.printer().printErr("Response from running Camel with PID " + this.pid + " not received within 5 seconds");
            return 1;
        }
        rows.sort(this::sortRow);
        if (this.properties) {
            for (Row row : rows) {
                String line = "BEAN: " + row.name + " (" + row.type + "):";
                this.printer().println(line);
                this.printer().println("-".repeat(line.length()));
                if (row.properties != null) {
                    this.propertiesTable(row.properties);
                }
                this.printer().println();
            }
        } else {
            this.singleTable(rows);
        }
        FileUtil.deleteFile((File)outputFile);
        return 0;
    }

    protected void singleTable(List<Row> rows) {
        this.printer().println(AsciiTable.getTable((Character[])AsciiTable.NO_BORDERS, rows, Arrays.asList(new Column().header("NAME").dataAlign(HorizontalAlign.LEFT).maxWidth(60, OverflowBehaviour.ELLIPSIS_RIGHT).with(r -> r.name), new Column().header("TYPE").dataAlign(HorizontalAlign.LEFT).maxWidth(100, OverflowBehaviour.CLIP_LEFT).with(r -> r.type))));
    }

    protected void propertiesTable(List<PropertyRow> rows) {
        this.printer().println(AsciiTable.getTable((Character[])AsciiTable.NO_BORDERS, rows, Arrays.asList(new Column().header("PROPERTY").dataAlign(HorizontalAlign.LEFT).maxWidth(40, OverflowBehaviour.ELLIPSIS_RIGHT).with(r -> r.name), new Column().header("TYPE").dataAlign(HorizontalAlign.LEFT).maxWidth(40, OverflowBehaviour.ELLIPSIS_RIGHT).with(r -> r.type), new Column().header("CONFIGURATION").visible(this.dsl).dataAlign(HorizontalAlign.LEFT).maxWidth(80, OverflowBehaviour.NEWLINE).with(r -> r.configValue), new Column().header("VALUE").dataAlign(HorizontalAlign.LEFT).maxWidth(80, OverflowBehaviour.NEWLINE).with(this::getValue))));
    }

    private String getValue(PropertyRow r) {
        if (r.value != null) {
            return r.value.toString();
        }
        return "null";
    }

    protected int sortRow(Row o1, Row o2) {
        String s = this.sort;
        int negate = 1;
        if (s.startsWith("-")) {
            s = s.substring(1);
            negate = -1;
        }
        switch (s) {
            case "name": {
                return o1.name.compareToIgnoreCase(o2.name) * negate;
            }
        }
        return 0;
    }

    protected JsonObject waitForOutputFile(File outputFile) {
        return CamelBeanDump.getJsonObject(outputFile);
    }

    private static class Row {
        String name;
        String type;
        List<PropertyRow> properties;

        private Row() {
        }
    }

    private static class PropertyRow {
        String name;
        String type;
        Object value;
        String configValue;

        private PropertyRow() {
        }
    }

    public static class NameTypeCompletionCandidates
    implements Iterable<String> {
        @Override
        public Iterator<String> iterator() {
            return List.of("name", "type").iterator();
        }
    }
}

