/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.jbang.core.commands.action;

import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.camel.dsl.jbang.core.commands.CamelJBangMain;
import org.apache.camel.dsl.jbang.core.commands.CommandHelper;
import org.apache.camel.dsl.jbang.core.commands.action.ActionBaseCommand;
import org.apache.camel.util.StopWatch;
import org.fusesource.jansi.Ansi;
import org.fusesource.jansi.AnsiConsole;
import picocli.CommandLine;

abstract class ActionWatchCommand
extends ActionBaseCommand {
    @CommandLine.Option(names={"--watch"}, description={"Execute periodically and showing output fullscreen"})
    boolean watch;
    private CommandHelper.ReadConsoleTask waitUserTask;

    public ActionWatchCommand(CamelJBangMain main) {
        super(main);
    }

    @Override
    public Integer doCall() throws Exception {
        int exit;
        AtomicBoolean running = new AtomicBoolean(true);
        if (this.watch) {
            Thread t = new Thread(() -> {
                this.waitUserTask = new CommandHelper.ReadConsoleTask(() -> running.set(false));
                this.waitUserTask.run();
            }, "WaitForUser");
            t.start();
            do {
                if ((exit = this.doWatchCall().intValue()) != 0) continue;
                try {
                    StopWatch watch = new StopWatch();
                    while (running.get() && watch.taken() < 2000L) {
                        Thread.sleep(100L);
                    }
                }
                catch (Exception e) {
                    running.set(false);
                }
            } while (exit == 0 && running.get());
        } else {
            exit = this.doWatchCall();
        }
        return exit;
    }

    protected void clearScreen() {
        AnsiConsole.out().print((Object)Ansi.ansi().eraseScreen().cursor(1, 1));
    }

    protected abstract Integer doWatchCall() throws Exception;
}

